/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.ctx.Status;
import com.sun.xacml.finder.PolicyFinderModule;
import com.sun.xacml.finder.PolicyFinderResult;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PolicyFinder {
    private Set allModules;
    private Set requestModules;
    private Set referenceModules;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$finder$PolicyFinder == null ? (class$com$sun$xacml$finder$PolicyFinder = PolicyFinder.class$("com.sun.xacml.finder.PolicyFinder")) : class$com$sun$xacml$finder$PolicyFinder).getName());
    static /* synthetic */ Class class$com$sun$xacml$finder$PolicyFinder;

    public Set getModules() {
        return new HashSet(this.allModules);
    }

    public void setModules(Set modules) {
        Iterator it = modules.iterator();
        this.allModules = new HashSet(modules);
        this.requestModules = new HashSet();
        this.referenceModules = new HashSet();
        while (it.hasNext()) {
            PolicyFinderModule module = (PolicyFinderModule)it.next();
            if (module.isRequestSupported()) {
                this.requestModules.add(module);
            }
            if (!module.isIdReferenceSupported()) continue;
            this.referenceModules.add(module);
        }
    }

    public void init() {
        logger.finer("Initializing PolicyFinder");
        Iterator it = this.allModules.iterator();
        while (it.hasNext()) {
            PolicyFinderModule module = (PolicyFinderModule)it.next();
            module.init(this);
        }
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicyFinderResult result = null;
        Iterator it = this.requestModules.iterator();
        while (it.hasNext()) {
            PolicyFinderModule module = (PolicyFinderModule)it.next();
            PolicyFinderResult newResult = module.findPolicy(context);
            if (newResult.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("An error occured while trying to find a single applicable policy for a request: " + newResult.getStatus().getMessage());
                }
                return newResult;
            }
            if (newResult.notApplicable()) continue;
            if (result != null) {
                logger.info("More than one top-level applicable policy for the request");
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            result = newResult;
        }
        if (result != null) {
            return result;
        }
        logger.info("No applicable policies were found for the request");
        return new PolicyFinderResult();
    }

    public PolicyFinderResult findPolicy(URI idReference, int type) throws IllegalArgumentException {
        PolicyFinderResult result = null;
        Iterator it = this.referenceModules.iterator();
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("Unknown reference type");
        }
        while (it.hasNext()) {
            PolicyFinderModule module = (PolicyFinderModule)it.next();
            PolicyFinderResult newResult = module.findPolicy(idReference, type);
            if (newResult.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("An error occured while trying to find the referenced policy " + idReference.toString() + ": " + newResult.getStatus().getMessage());
                }
                return newResult;
            }
            if (newResult.notApplicable()) continue;
            if (result != null) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("More than one policy applies for the reference: " + idReference.toString());
                }
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            result = newResult;
        }
        if (result != null) {
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("No policies were resolved for the reference: " + idReference.toString());
        }
        return new PolicyFinderResult();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

