/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.finder;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.finder.AttributeFinderModule;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;

public class AttributeFinder {
    private List allModules = new ArrayList();
    private List designatorModules = new ArrayList();
    private List selectorModules = new ArrayList();
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$finder$AttributeFinder == null ? (class$com$sun$xacml$finder$AttributeFinder = AttributeFinder.class$("com.sun.xacml.finder.AttributeFinder")) : class$com$sun$xacml$finder$AttributeFinder).getName());
    static /* synthetic */ Class class$com$sun$xacml$finder$AttributeFinder;

    public List getModules() {
        return new ArrayList(this.allModules);
    }

    public void setModules(List modules) {
        Iterator it = modules.iterator();
        this.allModules = new ArrayList(modules);
        this.designatorModules = new ArrayList();
        this.selectorModules = new ArrayList();
        while (it.hasNext()) {
            AttributeFinderModule module = (AttributeFinderModule)it.next();
            if (module.isDesignatorSupported()) {
                this.designatorModules.add(module);
            }
            if (!module.isSelectorSupported()) continue;
            this.selectorModules.add(module);
        }
    }

    public EvaluationResult findAttribute(URI attributeType, URI attributeId, URI issuer, URI subjectCategory, EvaluationCtx context, int designatorType) {
        Iterator it = this.designatorModules.iterator();
        while (it.hasNext()) {
            AttributeFinderModule module = (AttributeFinderModule)it.next();
            Set types = module.getSupportedDesignatorTypes();
            if (types != null && !types.contains(new Integer(designatorType))) continue;
            EvaluationResult result = module.findAttribute(attributeType, attributeId, issuer, subjectCategory, context, designatorType);
            if (result.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Error while trying to resolve values: " + result.getStatus().getMessage());
                }
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Failed to resolve any values for " + attributeId.toString());
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
    }

    public EvaluationResult findAttribute(String contextPath, Node namespaceNode, URI attributeType, EvaluationCtx context, String xpathVersion) {
        Iterator it = this.selectorModules.iterator();
        while (it.hasNext()) {
            AttributeFinderModule module = (AttributeFinderModule)it.next();
            EvaluationResult result = module.findAttribute(contextPath, namespaceNode, attributeType, context, xpathVersion);
            if (result.indeterminate()) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Error while trying to resolve values: " + result.getStatus().getMessage());
                }
                return result;
            }
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) continue;
            return result;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("Failed to resolve any values for " + contextPath);
        }
        return new EvaluationResult(BagAttribute.createEmptyBag(attributeType));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

