/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.cond;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.FunctionBase;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class LogicalFunction
extends FunctionBase {
    public static final String NAME_OR = "urn:oasis:names:tc:xacml:1.0:function:or";
    public static final String NAME_AND = "urn:oasis:names:tc:xacml:1.0:function:and";
    private static final int ID_OR = 0;
    private static final int ID_AND = 1;

    public LogicalFunction(String functionName) {
        super(functionName, LogicalFunction.getId(functionName), "http://www.w3.org/2001/XMLSchema#boolean", false, -1, "http://www.w3.org/2001/XMLSchema#boolean", false);
    }

    private static int getId(String functionName) {
        if (functionName.equals(NAME_OR)) {
            return 0;
        }
        if (functionName.equals(NAME_AND)) {
            return 1;
        }
        throw new IllegalArgumentException("unknown logical function: " + functionName);
    }

    public static Set getSupportedIdentifiers() {
        HashSet<String> set = new HashSet<String>();
        set.add(NAME_OR);
        set.add(NAME_AND);
        return set;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        Iterator it = inputs.iterator();
        while (it.hasNext()) {
            Evaluatable eval = (Evaluatable)it.next();
            EvaluationResult result = eval.evaluate(context);
            if (result.indeterminate()) {
                return result;
            }
            AttributeValue value = result.getAttributeValue();
            boolean argBooleanValue = ((BooleanAttribute)value).getValue();
            switch (this.getFunctionId()) {
                case 0: {
                    if (!argBooleanValue) break;
                    return EvaluationResult.getTrueInstance();
                }
                case 1: {
                    if (argBooleanValue) break;
                    return EvaluationResult.getFalseInstance();
                }
            }
        }
        if (this.getFunctionId() == 0) {
            return EvaluationResult.getFalseInstance();
        }
        return EvaluationResult.getTrueInstance();
    }
}

