/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.combine;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.MatchResult;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Status;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PermitOverridesPolicyAlg
extends PolicyCombiningAlgorithm {
    public static final String algId = "urn:oasis:names:tc:xacml:1.0:policy-combining-algorithm:permit-overrides";
    private static URI identifierURI;
    private static RuntimeException earlyException;

    public PermitOverridesPolicyAlg() {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
    }

    protected PermitOverridesPolicyAlg(URI identifier) {
        super(identifier);
    }

    public Result combine(EvaluationCtx context, List policies) {
        boolean atLeastOneError = false;
        boolean atLeastOneDeny = false;
        HashSet denyObligations = new HashSet();
        Status firstIndeterminateStatus = null;
        Iterator it = policies.iterator();
        while (it.hasNext()) {
            AbstractPolicy policy = (AbstractPolicy)it.next();
            MatchResult match = policy.match(context);
            if (match.getResult() == 2) {
                atLeastOneError = true;
                if (firstIndeterminateStatus != null) continue;
                firstIndeterminateStatus = match.getStatus();
                continue;
            }
            if (match.getResult() != 0) continue;
            Result result = policy.evaluate(context);
            int effect = result.getDecision();
            if (effect == 0) {
                return result;
            }
            if (effect == 1) {
                atLeastOneDeny = true;
                denyObligations.addAll(result.getObligations());
                continue;
            }
            if (effect != 2) continue;
            atLeastOneError = true;
            if (firstIndeterminateStatus != null) continue;
            firstIndeterminateStatus = result.getStatus();
        }
        if (atLeastOneDeny) {
            return new Result(1, context.getResourceId().encode(), denyObligations);
        }
        if (atLeastOneError) {
            return new Result(2, firstIndeterminateStatus, context.getResourceId().encode());
        }
        return new Result(3, context.getResourceId().encode());
    }

    static {
        try {
            identifierURI = new URI(algId);
        }
        catch (URISyntaxException se) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(se);
        }
    }
}

