/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml.attr;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeSelector
implements Evaluatable {
    private URI type;
    private String contextPath;
    private boolean mustBePresent;
    private String xpathVersion;
    private Node policyRoot;
    private static final Logger logger = Logger.getLogger((class$com$sun$xacml$attr$AttributeSelector == null ? (class$com$sun$xacml$attr$AttributeSelector = AttributeSelector.class$("com.sun.xacml.attr.AttributeSelector")) : class$com$sun$xacml$attr$AttributeSelector).getName());
    static /* synthetic */ Class class$com$sun$xacml$attr$AttributeSelector;

    public AttributeSelector(URI type, String contextPath, boolean mustBePresent, String xpathVersion) {
        this(type, contextPath, null, mustBePresent, xpathVersion);
    }

    public AttributeSelector(URI type, String contextPath, Node policyRoot, boolean mustBePresent, String xpathVersion) {
        this.type = type;
        this.contextPath = contextPath;
        this.mustBePresent = mustBePresent;
        this.xpathVersion = xpathVersion;
        this.policyRoot = policyRoot;
    }

    public static AttributeSelector getInstance(Node root, String xpathVersion) throws ParsingException {
        URI type = null;
        String contextPath = null;
        boolean mustBePresent = false;
        if (xpathVersion == null) {
            throw new ParsingException("An XPathVersion is required for any policies that use selectors");
        }
        NamedNodeMap attrs = root.getAttributes();
        try {
            type = new URI(attrs.getNamedItem("DataType").getNodeValue());
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required DataType attribute in AttributeSelector", e);
        }
        try {
            contextPath = attrs.getNamedItem("RequestContextPath").getNodeValue();
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing required RequestContextPath attribute in AttributeSelector", e);
        }
        try {
            Node node = attrs.getNamedItem("MustBePresent");
            if (node != null && node.getNodeValue().equals("true")) {
                mustBePresent = true;
            }
        }
        catch (Exception e) {
            throw new ParsingException("Error parsing optional attributes in AttributeSelector", e);
        }
        Node policyRoot = null;
        for (Node node = root.getParentNode(); node != null && node.getNodeType() == 1; node = node.getParentNode()) {
            policyRoot = node;
        }
        return new AttributeSelector(type, contextPath, policyRoot, mustBePresent, xpathVersion);
    }

    public URI getType() {
        return this.type;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean mustBePresent() {
        return this.mustBePresent;
    }

    public boolean evaluatesToBag() {
        return true;
    }

    public List getChildren() {
        return Collections.EMPTY_LIST;
    }

    public String getXPathVersion() {
        return this.xpathVersion;
    }

    public EvaluationResult evaluate(EvaluationCtx context) {
        EvaluationResult result = context.getAttribute(this.contextPath, this.policyRoot, this.type, this.xpathVersion);
        if (!result.indeterminate()) {
            BagAttribute bag = (BagAttribute)result.getAttributeValue();
            if (bag.isEmpty()) {
                if (this.mustBePresent) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.info("AttributeSelector failed to resolve a value for a required attribute: " + this.contextPath);
                    }
                    ArrayList<String> code = new ArrayList<String>();
                    code.add("urn:oasis:names:tc:xacml:1.0:status:missing-attribute");
                    String message = "couldn't resolve XPath expression " + this.contextPath + " for type " + this.type.toString();
                    return new EvaluationResult(new Status(code, message));
                }
                return result;
            }
            return result;
        }
        return result;
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String tag = "<AttributeSelector RequestContextPath=\"" + this.contextPath + "\" DataType=\"" + this.type.toString() + "\"";
        if (this.mustBePresent) {
            tag = tag + " MustBePresent=\"true\"";
        }
        tag = tag + "/>";
        out.println(indent + tag);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

