/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.EvaluationCtx;
import com.sun.xacml.Indenter;
import com.sun.xacml.MatchResult;
import com.sun.xacml.ParsingException;
import com.sun.xacml.UnknownIdentifierException;
import com.sun.xacml.attr.AttributeDesignator;
import com.sun.xacml.attr.AttributeFactory;
import com.sun.xacml.attr.AttributeSelector;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.BagAttribute;
import com.sun.xacml.attr.BooleanAttribute;
import com.sun.xacml.cond.Evaluatable;
import com.sun.xacml.cond.EvaluationResult;
import com.sun.xacml.cond.Function;
import com.sun.xacml.cond.FunctionFactory;
import com.sun.xacml.cond.FunctionTypeException;
import com.sun.xacml.ctx.Status;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TargetMatch {
    public static final int SUBJECT = 0;
    public static final int RESOURCE = 1;
    public static final int ACTION = 2;
    private int type;
    private Function function;
    private Evaluatable eval;
    private AttributeValue attrValue;

    public TargetMatch(int type, Function function, Evaluatable eval, AttributeValue attrValue) throws IllegalArgumentException {
        if (type != 0 && type != 1 && type != 2) {
            throw new IllegalArgumentException("Unknown TargetMatch type");
        }
        this.type = type;
        this.function = function;
        this.eval = eval;
        this.attrValue = attrValue;
    }

    /*
     * WARNING - void declaration
     */
    public static TargetMatch getInstance(Node root, String prefix, String xpathVersion) throws ParsingException, IllegalArgumentException {
        void var3_6;
        Function function;
        int type;
        Evaluatable eval = null;
        AttributeValue attrValue = null;
        AttributeFactory attrFactory = AttributeFactory.getInstance();
        if (prefix.equals("Subject")) {
            type = 0;
        } else if (prefix.equals("Resource")) {
            type = 1;
        } else if (prefix.equals("Action")) {
            type = 2;
        } else {
            throw new IllegalArgumentException("Unknown TargetMatch type");
        }
        String funcName = root.getAttributes().getNamedItem("MatchId").getNodeValue();
        FunctionFactory factory = FunctionFactory.getTargetInstance();
        try {
            URI funcId = new URI(funcName);
            function = factory.createFunction(funcId);
        }
        catch (URISyntaxException use) {
            throw new ParsingException("Error parsing TargetMatch", use);
        }
        catch (UnknownIdentifierException uie) {
            throw new ParsingException("Unknown MatchId", uie);
        }
        catch (FunctionTypeException fte) {
            try {
                URI funcId = new URI(funcName);
                function = factory.createAbstractFunction(funcId, root);
            }
            catch (Exception e) {
                throw new ParsingException("invalid abstract function", e);
            }
        }
        NodeList nodes = root.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals(prefix + "AttributeDesignator")) {
                eval = AttributeDesignator.getInstance(node, (int)var3_6);
                continue;
            }
            if (name.equals("AttributeSelector")) {
                eval = AttributeSelector.getInstance(node, xpathVersion);
                continue;
            }
            if (!name.equals("AttributeValue")) continue;
            try {
                attrValue = attrFactory.createValue(node);
                continue;
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown Attribute Type", uie);
            }
        }
        ArrayList<Evaluatable> inputs = new ArrayList<Evaluatable>();
        inputs.add(attrValue);
        inputs.add(eval);
        function.checkInputsNoBag(inputs);
        return new TargetMatch((int)var3_6, function, eval, attrValue);
    }

    public int getType() {
        return this.type;
    }

    public Function getMatchFunction() {
        return this.function;
    }

    public AttributeValue getMatchValue() {
        return this.attrValue;
    }

    public Evaluatable getMatchEvaluatable() {
        return this.eval;
    }

    public MatchResult match(EvaluationCtx context) {
        EvaluationResult result = this.eval.evaluate(context);
        if (result.indeterminate()) {
            return new MatchResult(2, result.getStatus());
        }
        BagAttribute bag = (BagAttribute)result.getAttributeValue();
        if (!bag.isEmpty()) {
            Iterator it = bag.iterator();
            boolean atLeastOneError = false;
            Status firstIndeterminateStatus = null;
            while (it.hasNext()) {
                ArrayList<AttributeValue> inputs = new ArrayList<AttributeValue>();
                inputs.add(this.attrValue);
                inputs.add((AttributeValue)it.next());
                MatchResult match = this.evaluateMatch(inputs, context);
                if (match.getResult() == 0) {
                    return match;
                }
                if (match.getResult() != 2) continue;
                atLeastOneError = true;
                if (firstIndeterminateStatus != null) continue;
                firstIndeterminateStatus = match.getStatus();
            }
            if (atLeastOneError) {
                return new MatchResult(2, firstIndeterminateStatus);
            }
            return new MatchResult(1);
        }
        return new MatchResult(1);
    }

    private MatchResult evaluateMatch(List inputs, EvaluationCtx context) {
        EvaluationResult result = this.function.evaluate(inputs, context);
        if (result.indeterminate()) {
            return new MatchResult(2, result.getStatus());
        }
        BooleanAttribute bool = (BooleanAttribute)result.getAttributeValue();
        if (bool.getValue()) {
            return new MatchResult(0);
        }
        return new MatchResult(1);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        String tagName = null;
        switch (this.type) {
            case 0: {
                tagName = "SubjectMatch";
                break;
            }
            case 1: {
                tagName = "ResourceMatch";
                break;
            }
            case 2: {
                tagName = "ActionMatch";
            }
        }
        out.println(indent + "<" + tagName + " MatchId=\"" + this.function.getIdentifier().toString() + "\">");
        indenter.in();
        this.attrValue.encode(output, indenter);
        this.eval.encode(output, indenter);
        indenter.out();
        out.println(indent + "</" + tagName + ">");
    }
}

