/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xacml;

import com.sun.xacml.AbstractPolicy;
import com.sun.xacml.Indenter;
import com.sun.xacml.ParsingException;
import com.sun.xacml.Policy;
import com.sun.xacml.PolicyReference;
import com.sun.xacml.Target;
import com.sun.xacml.combine.PolicyCombiningAlgorithm;
import com.sun.xacml.finder.PolicyFinder;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicySet
extends AbstractPolicy {
    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, Target target) {
        this(id, combiningAlg, null, target, null, null, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, Target target, List policies) {
        this(id, combiningAlg, null, target, policies, null, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, Target target, List policies, String defaultVersion) {
        this(id, combiningAlg, null, target, policies, defaultVersion, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies) {
        this(id, combiningAlg, description, target, policies, null, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies, String defaultVersion) {
        this(id, combiningAlg, description, target, policies, defaultVersion, null);
    }

    public PolicySet(URI id, PolicyCombiningAlgorithm combiningAlg, String description, Target target, List policies, String defaultVersion, Set obligations) {
        super(id, combiningAlg, description, target, defaultVersion, obligations);
        if (policies != null) {
            Iterator it = policies.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof AbstractPolicy) continue;
                throw new IllegalArgumentException("non-AbstractPolicy in policies");
            }
        }
        this.setChildren(policies);
    }

    private PolicySet(Node root, PolicyFinder finder) throws ParsingException {
        super(root, "PolicySet", "PolicyCombiningAlgId");
        ArrayList<AbstractPolicy> policies = new ArrayList<AbstractPolicy>();
        NodeList children = root.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            String name = child.getNodeName();
            if (name.equals("PolicySet")) {
                policies.add(PolicySet.getInstance(child, finder));
                continue;
            }
            if (name.equals("Policy")) {
                policies.add(Policy.getInstance(child));
                continue;
            }
            if (name.equals("PolicySetIdReference")) {
                policies.add(PolicyReference.getInstance(child, finder));
                continue;
            }
            if (!name.equals("PolicyIdReference")) continue;
            policies.add(PolicyReference.getInstance(child, finder));
        }
        this.setChildren(policies);
    }

    public static PolicySet getInstance(Node root) throws ParsingException {
        return PolicySet.getInstance(root, null);
    }

    public static PolicySet getInstance(Node root, PolicyFinder finder) throws ParsingException {
        if (!root.getNodeName().equals("PolicySet")) {
            throw new ParsingException("Cannot create PolicySet from root of type " + root.getNodeName());
        }
        return new PolicySet(root, finder);
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        String version;
        PrintStream out = new PrintStream(output);
        String indent = indenter.makeString();
        out.println(indent + "<PolicySet PolicySetId=\"" + this.getId().toString() + "\" PolicyCombiningAlgId=\"" + this.getCombiningAlg().getIdentifier().toString() + "\">");
        indenter.in();
        String nextIndent = indenter.makeString();
        String description = this.getDescription();
        if (description != null) {
            out.println(nextIndent + "<Description>" + description + "</Description>");
        }
        if ((version = this.getDefaultVersion()) != null) {
            out.println("<PolicySetDefaults><XPathVersion>" + version + "</XPathVersion></PolicySetDefaults>");
        }
        this.encodeCommonElements(output, indenter);
        indenter.out();
        out.println(indent + "</PolicySet>");
    }
}

