/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven2.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.EmbeddedLocalContainer;
import org.codehaus.cargo.container.InstalledLocalContainer;
import org.codehaus.cargo.container.LocalContainer;
import org.codehaus.cargo.container.configuration.Configuration;
import org.codehaus.cargo.container.installer.ZipURLInstaller;
import org.codehaus.cargo.generic.DefaultContainerFactory;
import org.codehaus.cargo.maven2.configuration.ArtifactInstaller;
import org.codehaus.cargo.maven2.configuration.Dependency;
import org.codehaus.cargo.maven2.configuration.ZipUrlInstaller;
import org.codehaus.cargo.maven2.util.CargoProject;
import org.codehaus.cargo.util.log.LogLevel;
import org.codehaus.cargo.util.log.Loggable;
import org.codehaus.cargo.util.log.Logger;

public class Container {
    private String containerId;
    private String implementation;
    private Dependency[] dependencies;
    private String home;
    private String output;
    private String installerZipFile;
    private ZipUrlInstaller zipUrlInstaller;
    private ArtifactInstaller artifactInstaller;
    private boolean append;
    private File log;
    private LogLevel logLevel;
    private String type = ContainerType.INSTALLED.getType();
    private Long timeout;
    private Map<String, String> systemProperties;
    private File systemPropertiesFile;

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Map<String, String> systemProperties) {
        this.systemProperties = systemProperties;
    }

    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public String getInstallerZipFile() {
        return this.installerZipFile;
    }

    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    public Dependency[] getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Dependency[] dependencies) {
        this.dependencies = dependencies;
    }

    public ContainerType getType() {
        return ContainerType.toType((String)this.type);
    }

    public void setType(ContainerType type) {
        this.type = type.getType();
    }

    public String getContainerId() {
        return this.containerId;
    }

    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getOutput() {
        return this.output;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public ZipUrlInstaller getZipUrlInstaller() {
        return this.zipUrlInstaller;
    }

    public void setZipUrlInstaller(ZipUrlInstaller zipUrlInstaller) {
        this.zipUrlInstaller = zipUrlInstaller;
    }

    public ArtifactInstaller getArtifactInstaller() {
        return this.artifactInstaller;
    }

    public void setArtifactInstaller(ArtifactInstaller artifactInstaller) {
        this.artifactInstaller = artifactInstaller;
    }

    public boolean shouldAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setLog(File log) {
        this.log = log;
    }

    public File getLog() {
        return this.log;
    }

    public void setLogLevel(String levelAsString) {
        this.logLevel = LogLevel.toLevel((String)levelAsString);
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public org.codehaus.cargo.container.Container createContainer(Configuration configuration, Logger logger, CargoProject project) throws MojoExecutionException {
        return this.createContainer(configuration, logger, project, null, null, null, null, null);
    }

    public org.codehaus.cargo.container.Container createContainer(Configuration configuration, Logger logger, CargoProject project, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Settings settings) throws MojoExecutionException {
        DefaultContainerFactory factory = new DefaultContainerFactory();
        if (this.getImplementation() != null) {
            try {
                Class<?> containerClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                factory.registerContainer(this.getContainerId(), this.getType(), containerClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MojoExecutionException("Custom container implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
            }
        }
        org.codehaus.cargo.container.Container container = factory.createContainer(this.getContainerId(), this.getType(), configuration);
        container.setLogger(logger);
        if (container.getType().isLocal()) {
            this.setupTimeout((LocalContainer)container, project);
            if (container.getType() == ContainerType.EMBEDDED) {
                this.setupEmbeddedExtraClasspath((EmbeddedLocalContainer)container, project);
                this.setupEmbeddedSystemProperties((EmbeddedLocalContainer)container);
                ((EmbeddedLocalContainer)container).setClassLoader(project.getEmbeddedClassLoader());
                Thread.currentThread().setContextClassLoader(project.getEmbeddedClassLoader());
            } else if (container.getType() == ContainerType.INSTALLED) {
                Proxy proxy = null;
                if (settings != null) {
                    proxy = settings.getActiveProxy();
                }
                this.setupHome((InstalledLocalContainer)container, project, artifactFactory, artifactResolver, localRepository, repositories, proxy);
                this.setupOutput((InstalledLocalContainer)container, project);
                this.setupExtraClasspath((InstalledLocalContainer)container, project);
                this.setupSystemProperties((InstalledLocalContainer)container);
                this.setupSharedClasspath((InstalledLocalContainer)container, project);
            }
        }
        return container;
    }

    private void setupEmbeddedExtraClasspath(EmbeddedLocalContainer container, CargoProject project) throws MojoExecutionException {
        if (this.getDependencies() != null) {
            URL[] dependencyURLs = new URL[this.getDependencies().length];
            for (int i = 0; i < this.getDependencies().length; ++i) {
                File pathFile = new File(this.getDependencies()[i].getDependencyPath(project));
                try {
                    dependencyURLs[i] = pathFile.toURL();
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new MojoExecutionException("Invalid classpath location [" + pathFile.getPath() + "]");
                }
            }
            URLClassLoader urlClassloader = new URLClassLoader(dependencyURLs, project.getEmbeddedClassLoader());
            project.setEmbeddedClassLoader(urlClassloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> mergeSystemProperties(Loggable container) throws MojoExecutionException {
        Map<String, String> systemProperties = null;
        if (this.getSystemPropertiesFile() != null) {
            Properties properties = new Properties();
            try {
                FileInputStream inputStream = new FileInputStream(this.getSystemPropertiesFile());
                try {
                    properties.load(new BufferedInputStream(inputStream));
                }
                finally {
                    ((InputStream)inputStream).close();
                }
                systemProperties = new HashMap<String, String>(properties.size());
                Enumeration<?> propertyNames = properties.propertyNames();
                while (propertyNames.hasMoreElements()) {
                    String propertyName = (String)propertyNames.nextElement();
                    String propertyValue = properties.getProperty(propertyName);
                    systemProperties.put(propertyName, propertyValue);
                }
            }
            catch (FileNotFoundException e) {
                container.getLogger().warn("System property file [" + this.getSystemPropertiesFile() + "] cannot be read", this.getClass().getName());
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("System property file [" + this.getSystemPropertiesFile() + "] cannot be loaded", (Exception)ioe);
            }
        }
        if (this.getSystemProperties() != null) {
            if (systemProperties != null) {
                systemProperties.putAll(this.getSystemProperties());
            } else {
                systemProperties = this.getSystemProperties();
            }
        }
        return systemProperties;
    }

    private void setupEmbeddedSystemProperties(EmbeddedLocalContainer container) throws MojoExecutionException {
        Map<String, String> systemProperties = this.mergeSystemProperties((Loggable)container);
        if (systemProperties != null) {
            for (Map.Entry<String, String> systemProperty : systemProperties.entrySet()) {
                if (systemProperty.getValue() == null) continue;
                System.setProperty(systemProperty.getKey(), systemProperty.getValue());
            }
        }
    }

    private void setupOutput(InstalledLocalContainer container, CargoProject project) {
        if (this.getOutput() != null) {
            container.setOutput(this.getOutput());
        } else if (project.getLog() != null) {
            project.getLog().debug((CharSequence)"No container log will be generated. Configure the plugin using the <output> element under <container> to generate container logs");
        }
    }

    private void setupTimeout(LocalContainer container, CargoProject project) {
        if (this.getTimeout() != null) {
            project.getLog().debug((CharSequence)("Setting container timeout to [" + this.getTimeout() + "]"));
            container.setTimeout(this.getTimeout().longValue());
        }
    }

    private void setupExtraClasspath(InstalledLocalContainer container, CargoProject project) throws MojoExecutionException {
        if (this.getDependencies() != null) {
            HashSet<String> classpaths = new HashSet<String>();
            for (Dependency dependency : this.getDependencies()) {
                if (!dependency.isOnClasspath("extra")) continue;
                classpaths.add(dependency.getDependencyPath(project));
            }
            container.setExtraClasspath(classpaths.toArray(new String[classpaths.size()]));
        }
    }

    private void setupSharedClasspath(InstalledLocalContainer container, CargoProject project) throws MojoExecutionException {
        if (this.getDependencies() != null) {
            HashSet<String> classpaths = new HashSet<String>();
            for (Dependency dependency : this.getDependencies()) {
                if (!dependency.isOnClasspath("shared")) continue;
                classpaths.add(dependency.getDependencyPath(project));
            }
            container.setSharedClasspath(classpaths.toArray(new String[classpaths.size()]));
        }
    }

    private void setupSystemProperties(InstalledLocalContainer container) throws MojoExecutionException {
        Map<String, String> systemProperties = this.mergeSystemProperties((Loggable)container);
        if (systemProperties != null) {
            container.setSystemProperties(systemProperties);
        }
    }

    private void setupHome(InstalledLocalContainer container, CargoProject project, ArtifactFactory artifactFactory, ArtifactResolver artifactResolver, ArtifactRepository localRepository, List<ArtifactRepository> repositories, Proxy proxy) throws MojoExecutionException {
        String tmpHome = null;
        if (this.getZipUrlInstaller() != null && this.getArtifactInstaller() != null) {
            throw new MojoExecutionException("You can use either ZipUrlInstaller or ArtifactInstaller; not both!");
        }
        if (this.getArtifactInstaller() != null) {
            URL homeURL;
            File home;
            try {
                home = this.getArtifactInstaller().resolve(artifactFactory, artifactResolver, localRepository, repositories);
                homeURL = home.toURI().toURL();
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed resolving artifact", e);
            }
            String extractDirectory = this.getArtifactInstaller().getExtractDir();
            if (extractDirectory == null) {
                File extractDirectoryFile = new File(project.getBuildDirectory(), "cargo/installs");
                extractDirectory = extractDirectoryFile.getPath();
            }
            ZipURLInstaller installer = new ZipURLInstaller(homeURL, home.getParent(), extractDirectory);
            if (this.getLog() != null) {
                installer.setLogger(container.getLogger());
            }
            if (project.isDaemonRun()) {
                if (!installer.isAlreadyDownloaded()) {
                    installer.download();
                }
            } else {
                installer.install();
                tmpHome = installer.getHome();
            }
            this.installerZipFile = installer.getDownloadFile();
        }
        if (this.getZipUrlInstaller() != null) {
            if (proxy != null && this.getZipUrlInstaller().getProxy() == null) {
                org.codehaus.cargo.container.installer.Proxy zipUrlInstallerProxy = this.getZipUrlInstaller().createProxy();
                zipUrlInstallerProxy.setExcludeHosts(proxy.getNonProxyHosts());
                zipUrlInstallerProxy.setHost(proxy.getHost());
                zipUrlInstallerProxy.setPassword(proxy.getPassword());
                zipUrlInstallerProxy.setPort(proxy.getPort());
                zipUrlInstallerProxy.setUser(proxy.getUsername());
            }
            ZipURLInstaller installer = this.getZipUrlInstaller().createInstaller(project.getBuildDirectory());
            if (this.getLog() != null) {
                installer.setLogger(container.getLogger());
            }
            if (project.isDaemonRun()) {
                if (!installer.isAlreadyDownloaded()) {
                    installer.download();
                }
            } else {
                installer.install();
                tmpHome = installer.getHome();
            }
            this.installerZipFile = installer.getDownloadFile();
        }
        if (this.getHome() != null) {
            tmpHome = this.getHome();
        }
        if (tmpHome != null) {
            container.setHome(tmpHome);
        }
    }
}

