/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.sli4j.core;

import com.google.inject.Binder;
import com.google.inject.MembersInjector;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.matcher.Matcher;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.googlecode.sli4j.core.AbstractLoggerInjector;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractLoggingModule<L>
extends TypeLiteral<L>
implements Module,
TypeListener {
    private final Matcher<? super TypeLiteral<?>> matcher;
    private final Class<?> loggerClass;
    private final Constructor<? extends MembersInjector<L>> logInjectorConstructor;

    public <LI extends AbstractLoggerInjector<L>> AbstractLoggingModule(Matcher<? super TypeLiteral<?>> matcher, Class<LI> loggerInjectorClass) {
        if (matcher == null) {
            throw new IllegalArgumentException("Parameter 'matcher' must not be null");
        }
        if (loggerInjectorClass == null) {
            throw new IllegalArgumentException("Parameter 'loggerInjectorClass' must not be null");
        }
        this.matcher = matcher;
        this.loggerClass = MoreTypes.getRawType((Type)this.getType());
        try {
            this.logInjectorConstructor = loggerInjectorClass.getConstructor(Field.class);
        }
        catch (SecurityException e) {
            throw new RuntimeException("Impossible to access to '" + loggerInjectorClass.getName() + "(" + Field.class.getName() + ")' public constructor due to security violation", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Class '" + loggerInjectorClass.getName() + "' doesn't have a public construcor with <" + Field.class.getName() + "> parameter type", e);
        }
    }

    public final void configure(Binder binder) {
        binder.bindListener(this.matcher, (TypeListener)this);
    }

    public final <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
        this.hear(type.getRawType(), encounter);
    }

    private <I> void hear(Class<?> klass, TypeEncounter<I> encounter) {
        if (Object.class == klass) {
            return;
        }
        for (Field field : klass.getDeclaredFields()) {
            if (this.loggerClass != field.getType()) continue;
            try {
                encounter.register(this.logInjectorConstructor.newInstance(field));
            }
            catch (Exception e) {
                throw new RuntimeException("Impossible to register '" + this.logInjectorConstructor.getName() + "' for field '" + field + "', see nested exception", e);
            }
        }
        this.hear(klass.getSuperclass(), encounter);
    }
}

