/*
 *  Copyright 2012 GWT-Bootstrap
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package com.github.gwtbootstrap.client.ui.constants;

import com.github.gwtbootstrap.client.ui.Navbar;

//@formatter:off
/**
 * Constants used for the {@link Navbar} and for Navbar contents.
 * 
 * @since 2.0.4.0
 * 
 * @author Dominik Mayer
 * 
 * @see <a href="http://getbootstrap.com/2.3.2/components.html#navbar">Bootstrap documentation</a>
 */
//@formatter:on
public interface NavbarConstants {

	public static final String NAVBAR = "navbar";

	public static final String NAVBAR_FORM = "navbar-form";

	public static final String NAVBAR_SEARCH = "navbar-search";

	public static final String NAVBAR_TEXT = "navbar-text";

	public static final String NAVBAR_INNER = "navbar-inner";

	public static final String NAVBAR_BUTTON = "btn-navbar";

}
