/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.config;

import java.io.File;
import javax.inject.Inject;
import org.virtual.files.common.Utils;

public class ConfigurationLocator {
    @Inject
    public ConfigurationLocator() {
    }

    public File locate() throws IllegalStateException {
        File dir = this.locate_directory();
        if (dir == null && !Utils.isValid(new File(dir = new File(System.getProperty("user.dir")), "vfiles.json"))) {
            dir = new File(System.getProperty("user.home"));
        }
        return new File(dir, "vfiles.json");
    }

    private File locate_directory() {
        String location = System.getProperty("vfiles.config");
        if (location != null) {
            return this.validDirectory(location);
        }
        location = System.getenv("vfiles.config");
        if (location != null) {
            return this.validDirectory(location);
        }
        return null;
    }

    private File validDirectory(String location) {
        File file = new File(location);
        try {
            Utils.validDirectory(file);
        }
        catch (Exception e) {
            throw Utils.unchecked("invalid configuration @ " + file, e);
        }
        return file;
    }
}

