/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import javax.inject.Inject;
import org.virtual.files.common.Utils;
import org.virtual.files.config.Configuration;

public class ConfigurationContext {
    @Inject
    ObjectMapper mapper;

    public Configuration bind(InputStream stream) {
        try {
            return (Configuration)this.mapper.readValue(stream, Configuration.class);
        }
        catch (Exception e) {
            throw Utils.unchecked("cannot read configuration (see cause)", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Configuration cfg, File location) {
        try {
            FileOutputStream stream = new FileOutputStream(location);
            try {
                this.mapper.writeValue((OutputStream)stream, (Object)cfg);
            }
            finally {
                if (Collections.singletonList(stream).get(0) != null) {
                    stream.close();
                }
            }
        }
        catch (Exception e) {
            throw Utils.unchecked("cannot save configuration (see cause)", e);
        }
    }
}

