/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files.common;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.files.index.AssetIndex;
import org.virtualrepository.Asset;
import org.virtualrepository.Properties;
import org.virtualrepository.Property;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private static final Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
    static JsonNodeFactory factory = JsonNodeFactory.instance;
    public static ObjectMapper mapper = new ObjectMapper();

    public static PropertyBuilder build(final Properties props) {
        return new PropertyBuilder(){

            @Override
            public PropertyBuilder add(String name, String value) {
                if (value != null) {
                    props.add(new Property[]{new Property(name, (Object)value)});
                }
                return this;
            }
        };
    }

    public static String hint(Asset asset, String hint) {
        return Utils.hintOr(asset, hint, null);
    }

    public static String hintOr(Asset asset, String hint, String or) {
        Properties props = asset.properties();
        if (props.contains(hint)) {
            Property prop = props.lookup(hint);
            if (prop.is(String.class)) {
                return (String)prop.value(String.class);
            }
            log.warn("ignoring hint in {}: not a string", (Object)hint, (Object)asset.name());
        }
        return or;
    }

    public static void verify(String msg, boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static void notNull(String name, Object o) throws IllegalArgumentException {
        Utils.verify(name + " is null", o != null);
    }

    public static void notEmpty(String name, String s) throws IllegalArgumentException {
        Utils.notNull(name, s);
        Utils.verify(name + " is empty", !s.isEmpty());
    }

    public static void validUri(String msg, String uri) throws IllegalArgumentException {
        try {
            URI o = URI.create(uri);
            if (!o.isAbsolute()) {
                throw new Exception("not an absolute URI");
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(msg, e);
        }
    }

    public static void validUris(String name, List<String> uris) throws IllegalArgumentException {
        Utils.notNull(name, uris);
        for (String uri : uris) {
            Utils.validUri(name, uri);
        }
    }

    public static void valid(String name, String s) throws IllegalArgumentException {
        Utils.notNull(name, s);
        Utils.notEmpty(name, s);
    }

    public static void positive(String name, int val) throws IllegalArgumentException {
        Utils.verify(name + " is not positive", val > 0);
    }

    public static void notEmpty(String name, Collection<? extends Object> c) throws IllegalArgumentException {
        Utils.notNull(name, c);
        Utils.verify(name + " is empty", !c.isEmpty());
    }

    public static void notEmpty(String name, Object[] a) throws IllegalArgumentException {
        Utils.notNull(name, a);
        Utils.verify(name + " is empty", a.length > 0);
    }

    public static void valid(String name, Object[] a) throws IllegalArgumentException {
        Utils.notNull(name, a);
        for (Object e : a) {
            Utils.notNull(name + "'s element", e);
        }
    }

    public static void noNulls(String name, Collection<?> c) throws IllegalArgumentException {
        Utils.notNull(name, c);
        Utils.notEmpty(name, c);
        for (Object e : c) {
            Utils.notNull(name + "'s element", e);
        }
    }

    public static void valid(String name, Collection<String> c) throws IllegalArgumentException {
        Utils.notNull(name, c);
        Utils.notEmpty(name, c);
        for (String e : c) {
            Utils.valid(name + "'s element", e);
        }
    }

    public static void valid(File file) throws IllegalArgumentException {
        Utils.notNull("file", file);
        Utils.verify(file + " does not exist, is a directory, or cannot be read", file.exists() && !file.isDirectory() && file.canRead());
    }

    public static void validDirectory(File dir) throws IllegalArgumentException {
        Utils.notNull("directory", dir);
        Utils.verify(dir + " does not exist or cannot be read", dir.exists() && dir.canRead());
    }

    public static boolean isValid(File file) {
        Utils.notNull("file", file);
        return file.exists() && !file.isDirectory() && file.canRead();
    }

    public static boolean isValidDirectory(File dir) {
        Utils.notNull("directory", dir);
        return dir.exists() && dir.canRead();
    }

    public static void validEmail(String email) {
        Utils.verify("invalid email address " + email, pattern.matcher(email).matches());
    }

    public static void valid(String text, QName name) throws IllegalArgumentException {
        Utils.notNull(text, name);
        Utils.valid(text, name.getLocalPart());
    }

    public static <T> T reveal(Object o, Class<T> type) {
        Utils.notNull("object", o);
        try {
            return type.cast(o);
        }
        catch (ClassCastException e) {
            throw new AssertionError((Object)("expected a " + type + ", found instead a " + o.getClass()));
        }
    }

    public static RuntimeException unchecked(Throwable t) {
        return t instanceof RuntimeException ? (RuntimeException)RuntimeException.class.cast(t) : new RuntimeException(t);
    }

    public static RuntimeException unchecked(String msg, Throwable t) {
        msg = msg + " (see cause) ";
        return t instanceof IllegalArgumentException ? new IllegalArgumentException(msg, t) : (t instanceof IllegalStateException ? new IllegalStateException(msg, t) : new RuntimeException(msg, t));
    }

    public static void rethrowUnchecked(String msg, Throwable t) throws RuntimeException {
        throw Utils.unchecked(msg, t);
    }

    public static void rethrowUnchecked(Throwable t) throws RuntimeException {
        throw Utils.unchecked(t);
    }

    public static ObjectNode toJson(Object o) {
        return Utils.toJson(o, false);
    }

    public static AssetIndex assetsFrom(InputStream stream) {
        try {
            return (AssetIndex)mapper.readValue(stream, AssetIndex.class);
        }
        catch (Exception e) {
            throw Utils.unchecked("invalid assets file", e);
        }
    }

    public static ObjectNode toJson(Object o, boolean print) {
        ObjectNode node = (ObjectNode)mapper.valueToTree(o);
        if (print) {
            try {
                System.out.println(mapper.writeValueAsString((Object)node));
            }
            catch (Exception e) {
                throw Utils.unchecked(e);
            }
        }
        return node;
    }

    public static <T> T fromJson(JsonNode node, Class<T> type) {
        try {
            return (T)mapper.treeToValue((TreeNode)node, type);
        }
        catch (Exception e) {
            throw Utils.unchecked("cannot parse json", e);
        }
    }

    public static <T> T jsonRoundtrip(T o) {
        return Utils.jsonRoundtrip(o, false);
    }

    public static <T> T jsonRoundtrip(T o, boolean print) {
        return (T)Utils.fromJson((JsonNode)Utils.toJson(o, print), o.getClass());
    }

    static {
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
    }

    public static interface PropertyBuilder {
        public PropertyBuilder add(String var1, String var2);
    }
}

