/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.files;

import java.beans.ConstructorProperties;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.virtual.files.Assets;
import org.virtual.files.Provider;
import org.virtual.files.common.Constants;
import org.virtual.files.common.Utils;
import org.virtual.files.index.AssetInfo;
import org.virtualrepository.Asset;
import org.virtualrepository.AssetType;
import org.virtualrepository.Property;
import org.virtualrepository.impl.Type;
import org.virtualrepository.spi.Publisher;

public class FilePublisher
implements Publisher<Asset, InputStream> {
    @NonNull
    Provider provider;
    public static final Map<AssetType, String> extensions = new HashMap<AssetType, String>();

    public void publish(Asset asset, InputStream content) throws Exception {
        Optional<AssetInfo> info = this.provider.index().lookup(asset.name());
        if (info.isPresent()) {
            this.update(asset, info.get(), content);
        } else {
            this.create(asset, content);
        }
    }

    public Type<? extends Asset> type() {
        return Type.any;
    }

    public Class<InputStream> api() {
        return InputStream.class;
    }

    private void create(Asset asset, InputStream content) {
        asset.properties().add(new Property[]{Constants.now("vfile_ created")});
        this.provider.create(asset, Assets.infoFor(this.pathFor(asset), asset), content);
    }

    private void update(Asset asset, AssetInfo info, InputStream content) {
        if (!this.provider.configuration().overwrite() || Utils.hint(asset, "vfile_no_overwrite") != null) {
            throw new IllegalArgumentException("asset " + asset.name() + " already exists and no overwrite is allowed.");
        }
        asset.properties().add(new Property[]{Constants.now("vfile_lastModified")});
        this.provider.update(asset, Assets.updateInfoWith(info, asset), content);
    }

    private String pathFor(Asset asset) {
        String path = Utils.hintOr(asset, "vfile_path", asset.name().replaceAll("\\W+", "_"));
        String extension = Utils.hintOr(asset, "vfile_extension", "asset");
        return String.format("%s.%s", path, extension);
    }

    @ConstructorProperties(value={"provider"})
    public FilePublisher(@NonNull Provider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider is null");
        }
        this.provider = provider;
    }
}

