/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.data.fao.resources;

import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import org.virtual.data.fao.resources.Database;
import org.virtual.data.fao.resources.Dimension;
import org.virtual.data.fao.resources.Member;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceType<T> {
    public static ResourceType<Database> databases = new ResourceType<Database>("databases.xml", Database.class);
    private final String path;
    private final Class<T> type;
    private final JAXBContext binder;
    private MediaType media = MediaType.APPLICATION_XML_TYPE;

    public static ResourceType<Dimension> dimensionsOf(String db) {
        return new ResourceType<Dimension>(String.format("%s/dimensions.xml", db), Dimension.class);
    }

    public static ResourceType<Member> membersOf(String db, String ds) {
        return new ResourceType<Member>(String.format("%s/%s/members.xml", db, ds), Member.class);
    }

    private ResourceType(String path, Class<T> type) {
        try {
            this.path = path;
            this.type = type;
            this.binder = JAXBContext.newInstance((Class[])new Class[]{type});
        }
        catch (Exception e) {
            throw new RuntimeException("jaxb initialisation problem", e);
        }
    }

    public MediaType media() {
        return this.media;
    }

    public String path() {
        return this.path;
    }

    public Class<T> type() {
        return this.type;
    }

    public T bind(Element e) throws Exception {
        return this.type.cast(this.binder.createUnmarshaller().unmarshal((Node)e));
    }
}

