/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.data.fao;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.virtual.data.fao.io.Request;
import org.virtual.data.fao.resources.Database;
import org.virtual.data.fao.resources.ResourceType;

@Singleton
public class Databases {
    private static final Logger log = LoggerFactory.getLogger(Databases.class);
    private static final Collection<String> whitelist = Arrays.asList("agro-maps", "aquastat", "crop-calendar", "empres-i", "faodata", "faostat", "fishstat", "gaez", "glipha", "hungermap");
    @Inject
    Provider<Request> requests;

    public Collection<Database> find() {
        long time = System.currentTimeMillis();
        try {
            Collection<Database> dbs = ((Request)this.requests.get()).over(ResourceType.databases).execute();
            int size = dbs.size();
            this.retainWhitelist(dbs);
            log.info("found {} FAO databases in {} ms, retained {} in whitelist", new Object[]{size, System.currentTimeMillis() - time, dbs.size()});
            return dbs;
        }
        catch (Exception e) {
            throw new RuntimeException("cannot discover FAO databases (see cause)", e);
        }
    }

    private void retainWhitelist(Collection<Database> dbs) {
        Iterator<Database> it = dbs.iterator();
        while (it.hasNext()) {
            if (whitelist.contains(it.next().mnemonic())) continue;
            it.remove();
        }
    }
}

