/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.data.fao;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.virtual.data.fao.DatabaseBrowser;
import org.virtual.data.fao.DatabaseImporter;
import org.virtual.data.fao.io.Request;
import org.virtual.data.fao.resources.Database;
import org.virtualrepository.csv.Table2CsvStream;
import org.virtualrepository.spi.Browser;
import org.virtualrepository.spi.ImportAdapter;
import org.virtualrepository.spi.Importer;
import org.virtualrepository.spi.Publisher;
import org.virtualrepository.spi.ServiceProxy;
import org.virtualrepository.spi.Transform;

@Singleton
public class DatabaseProxy
implements ServiceProxy {
    private final DatabaseBrowser browser;
    private final List<Publisher<?, ?>> publishers = new ArrayList();
    private final List<Importer<?, ?>> importers = new ArrayList();

    public DatabaseProxy(Database db, Provider<Request> requests) {
        this.browser = new DatabaseBrowser(db, requests);
        DatabaseImporter importer = new DatabaseImporter(db, requests);
        this.importers.add(importer);
        this.importers.add(ImportAdapter.adapt((Importer)importer, (Transform)new Table2CsvStream()));
    }

    public Browser browser() {
        return this.browser;
    }

    public List<? extends Importer<?, ?>> importers() {
        return this.importers;
    }

    public List<? extends Publisher<?, ?>> publishers() {
        return this.publishers;
    }
}

