/*
 * Decompiled with CFR 0.152.
 */
package api.tabular;

import api.tabular.Column;
import api.tabular.utils.Streamable;
import api.tabular.utils.TableUtils;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;

public class Row
implements Streamable<String> {
    @NonNull
    private Map<String, String> data;

    public Row() {
        this(new HashMap<String, String>());
    }

    public Row(Row row) {
        this();
        this.merge(row);
    }

    @Override
    public Iterator<String> iterator() {
        return this.data.values().iterator();
    }

    public void forEach(BiConsumer<String, String> consumer) {
        this.data.entrySet().forEach((? super T e) -> consumer.accept((String)e.getKey(), (String)e.getValue()));
    }

    public boolean has(Iterable<Column> cols) {
        return this.has(TableUtils.streamof(cols).map(Column::name).collect(Collectors.toList()));
    }

    public boolean has(Collection<String> cols) {
        return cols.stream().allMatch(this.data::containsKey);
    }

    public boolean has(Column ... cols) {
        return this.has((Iterable<Column>)Arrays.asList(cols));
    }

    public boolean has(String ... cols) {
        return this.has((Collection<String>)Arrays.asList(cols));
    }

    public String get(String name) {
        return this.data.get(name);
    }

    public String get(Column col) {
        return this.get(col.name());
    }

    public String getOr(Column col, String fallbackValue) {
        return this.getOr(col.name(), fallbackValue);
    }

    public String getOr(String col, String fallbackValue) {
        return this.has(col) ? this.get(col) : fallbackValue;
    }

    public Set<String> columns() {
        return new HashSet<String>(this.data.keySet());
    }

    public Row set(Column column, Object value) {
        this.data.put(column.name(), value.toString());
        return this;
    }

    public Row set(String column, Object value) {
        this.data.put(column, value.toString());
        return this;
    }

    public Row merge(Row ... rows) {
        return this.merge(Arrays.asList(rows));
    }

    public Row merge(Iterable<Row> rows) {
        TableUtils.streamof(rows).forEach((? super T r) -> this.data.putAll(r.data));
        return this;
    }

    public Row remove(Column ... columns) {
        return this.remove((Iterable<Column>)Arrays.asList(columns));
    }

    public Row remove(Iterable<Column> columns) {
        return this.remove(TableUtils.streamof(columns).map(Column::name).collect(Collectors.toList()));
    }

    public Row remove(String ... columns) {
        return this.remove((Collection<String>)Arrays.asList(columns));
    }

    public Row remove(Collection<String> columns) {
        for (String col : columns) {
            this.data.remove(col);
        }
        return this;
    }

    public Row remove(Row row) {
        return this.remove((Collection<String>)this.data.keySet());
    }

    public Row extract(Column ... columns) {
        return this.extract((Iterable<Column>)Arrays.asList(columns));
    }

    public Row extract(Iterable<Column> columns) {
        return this.extract(TableUtils.streamof(columns).map(Column::name).collect(Collectors.toList()));
    }

    public Row extract(String ... columns) {
        return this.extract((Collection<String>)Arrays.asList(columns));
    }

    public Row extract(Collection<String> columns) {
        Row row = new Row();
        for (String col : columns) {
            if (!this.has(col)) continue;
            row.set(col, (Object)this.get(col));
        }
        return row;
    }

    public int size() {
        return this.data.size();
    }

    @ConstructorProperties(value={"data"})
    public Row(@NonNull Map<String, String> data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Row)) {
            return false;
        }
        Row other = (Row)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, String> this$data = this.data;
        Map<String, String> other$data = other.data;
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Row;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, String> $data = this.data;
        result = result * 59 + ($data == null ? 0 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "Row(" + this.data + ")";
    }
}

