/*
 * Decompiled with CFR 0.152.
 */
package org.virtual.grade.configuration;

import java.io.File;
import javax.inject.Inject;
import org.virtual.grade.common.Utils;

public class ConfigurationLocator {
    @Inject
    public ConfigurationLocator() {
    }

    public File locate() throws IllegalStateException {
        File dir = this.locate_directory();
        if (dir == null && !Utils.isValid(new File(dir = new File(System.getProperty("user.dir")), "grade-repositories.json"))) {
            dir = new File(System.getProperty("user.home"));
        }
        return new File(dir, "grade-repositories.json");
    }

    private File locate_directory() {
        String location = System.getProperty("grade.config");
        if (location != null) {
            return this.validDirectory(location);
        }
        location = System.getenv("grade.config");
        if (location != null) {
            return this.validDirectory(location);
        }
        return null;
    }

    private File validDirectory(String location) {
        File file = new File(location);
        try {
            Utils.validDirectory(file);
        }
        catch (Exception e) {
            throw Utils.unchecked("invalid configuration @ " + file, e);
        }
        return file;
    }
}

