/*
 * Decompiled with CFR 0.152.
 */
package org.grade.service.resources;

import com.hp.hpl.jena.rdf.model.Model;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import lombok.NonNull;
import org.grade.configuration.Configuration;
import org.grade.engine.Results;
import org.grade.engine.TaskEngine;
import org.grade.engine.TaskExecution;
import org.grade.repo.Task;
import org.grade.repo.TaskRepository;
import org.grade.service.resources.RepositoryResource;

@ApplicationScoped
@Path(value="/catalogue")
public class CatalogueResource
extends RepositoryResource<TaskRepository> {
    TaskEngine engine;

    CatalogueResource() {
    }

    @Inject
    public CatalogueResource(TaskRepository repo, Configuration cfg, Event<Configuration> events, TaskEngine engine) {
        super(repo, cfg, cfg.tasks(), events);
        this.engine = engine;
    }

    @GET
    @Path(value="/tasks")
    @Produces(value={"application/json"})
    public List<Task> tasks() {
        return ((TaskRepository)this.repo).get("all_tasks", Collections.emptyMap());
    }

    @POST
    @Path(value="/tasks")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Task writeTask(Task task) {
        ((TaskRepository)this.repo).save(task);
        return task;
    }

    @GET
    @Path(value="/task")
    @Produces(value={"application/json"})
    public Task getTask(@QueryParam(value="uri") @NonNull String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        return ((TaskRepository)this.repo).lookup(uri);
    }

    @DELETE
    @Path(value="/task")
    public void deleteTask(@QueryParam(value="uri") @NonNull String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        ((TaskRepository)this.repo).remove(uri);
    }

    @GET
    @Path(value="/tasks/executions")
    @Produces(value={"application/json"})
    public List<TaskExecution> executions() {
        return this.engine.all();
    }

    @POST
    @Path(value="/tasks/executions")
    @Produces(value={"application/json"})
    public TaskExecution start(@QueryParam(value="uri") @NonNull String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri is null");
        }
        return this.engine.execute(((TaskRepository)this.repo).lookup(uri));
    }

    @POST
    @Path(value="/tasks/executions/{id}")
    @Produces(value={"application/json"})
    public TaskExecution stop(@PathParam(value="id") String id) {
        TaskExecution execution = this.engine.lookup(id);
        execution.stop();
        return execution;
    }

    @GET
    @Path(value="/tasks/executions/{id}")
    @Produces(value={"application/json"})
    public TaskExecution poll(@PathParam(value="id") String id) {
        return this.engine.lookup(id);
    }

    @DELETE
    @Path(value="/tasks/executions/{id}")
    public void delete(@PathParam(value="id") String id) {
        this.engine.remove(id);
    }

    @POST
    @Path(value="/tasks/sandbox/executions")
    public TaskExecution dryExecute(Task task) {
        return this.engine.dryExecute(task);
    }

    @GET
    @Path(value="/tasks/executions/{id}/results/transform")
    @Produces(value={"application/sparql-results+json", "application/n-triples", "application/json", "application/ld+json", "application/xml", "application/rdf+xml", "text/turtle", "application/x-turtle"})
    public Model transformResults(@PathParam(value="id") String id, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="uri") String uri) {
        return this.sampling_query(this.engine.lookup(id).transformation(), offset, limit, uri);
    }

    @GET
    @Path(value="/tasks/executions/{id}/results/difference")
    @Produces(value={"application/sparql-results+json", "application/n-triples", "application/json", "application/ld+json", "application/xml", "application/rdf+xml", "text/turtle", "application/x-turtle"})
    public Model deltaResults(@PathParam(value="id") String id, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="uri") String uri) {
        return this.sampling_query(this.engine.lookup(id).delta(), offset, limit, uri);
    }

    @GET
    @Path(value="/tasks/executions/{id}/results/target")
    @Produces(value={"application/sparql-results+json", "application/n-triples", "application/json", "application/ld+json", "application/xml", "application/rdf+xml", "text/turtle", "application/x-turtle"})
    public Model target(@PathParam(value="id") String id, @QueryParam(value="offset") Integer offset, @QueryParam(value="limit") Integer limit, @QueryParam(value="uri") String uri) {
        return this.sampling_query(this.engine.lookup(id).results(), offset, limit, uri);
    }

    private Model sampling_query(Results results, Integer offset, Integer limit, String uri) {
        if (uri != null) {
            return results.describe(uri);
        }
        if (offset == null) {
            offset = 0;
        }
        if (limit == null) {
            limit = Integer.valueOf("100");
        }
        return results.get(offset.intValue(), limit.intValue());
    }
}

