/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.workspace.client.folder.events;

import com.google.gwt.core.client.GWT;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.data.Record;
import com.gwtext.client.dd.DragData;
import com.gwtext.client.dd.DragSource;
import com.gwtext.client.dd.DropTarget;
import com.gwtext.client.dd.DropTargetConfig;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.grid.GridDragData;
import com.gwtext.client.widgets.grid.GridView;
import com.gwtext.client.widgets.tree.TreeDragData;
import com.gwtext.client.widgets.tree.TreeNode;
import java.util.LinkedList;
import org.gcube.portlets.user.workspace.client.folder.FolderListView;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspace;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspaceDD;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspaceFolder;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspaceItem;

public class FolderDragAnDropManager
extends DropTarget {
    protected GWTWorkspace workspace;
    public static final String NO_DROP = "x-dd-drop-nodrop";
    public static final String OK_DROP = "x-dd-drop-ok";
    public static final String OK_DROP_ADD = "x-dd-drop-ok-add";
    protected FolderListView folder;

    public FolderDragAnDropManager(GWTWorkspace workspace, FolderListView folder, DropTargetConfig config) {
        super((Component)folder, config);
        this.folder = folder;
        this.workspace = workspace;
    }

    public boolean notifyDrop(DragSource source, EventObject e, DragData data) {
        GWT.log((String)("Notify drop " + data.getClass()), null);
        if (data instanceof TreeDragData) {
            TreeDragData treeDragData = (TreeDragData)data;
            TreeNode treeNode = treeDragData.getTreeNode();
            if (!(treeNode.getUserObject() instanceof GWTWorkspaceItem)) {
                return false;
            }
            GWTWorkspaceItem sourceItem = (GWTWorkspaceItem)treeNode.getUserObject();
            GridView view = this.folder.getView();
            int droppedRow = view.findRowIndex(e);
            GWTWorkspaceItem targetItem = null;
            if (droppedRow >= 0) {
                Record record = this.folder.getStore().getAt(droppedRow);
                targetItem = (GWTWorkspaceItem)record.getAsObject("item");
            } else {
                targetItem = this.folder.getShowedItem();
            }
            if (!GWTWorkspaceDD.canDrop((GWTWorkspaceItem)targetItem, (GWTWorkspaceItem)sourceItem)) {
                return false;
            }
            this.workspace.moveItem(sourceItem, (GWTWorkspaceFolder)targetItem);
            return true;
        }
        if (data instanceof GridDragData) {
            GridView view = this.folder.getView();
            int droppedRow = view.findRowIndex(e);
            GWTWorkspaceItem targetItem = null;
            if (droppedRow >= 0) {
                Record record = this.folder.getStore().getAt(droppedRow);
                targetItem = (GWTWorkspaceItem)record.getAsObject("item");
            } else {
                targetItem = this.folder.getShowedItem();
            }
            GridDragData gridDragData = (GridDragData)data;
            Record[] records = gridDragData.getSelections();
            LinkedList<GWTWorkspaceItem> sources = new LinkedList<GWTWorkspaceItem>();
            Record[] recordArray = records;
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                Record record = recordArray[n2];
                if (record.getAsObject("item") instanceof GWTWorkspaceItem) {
                    GWTWorkspaceItem sourceItem = (GWTWorkspaceItem)record.getAsObject("item");
                    if (!GWTWorkspaceDD.canDrop((GWTWorkspaceItem)targetItem, (GWTWorkspaceItem)sourceItem)) {
                        return false;
                    }
                    sources.add(sourceItem);
                }
                ++n2;
            }
            for (GWTWorkspaceItem sourceItem : sources) {
                this.workspace.moveItem(sourceItem, (GWTWorkspaceFolder)targetItem);
            }
        }
        return false;
    }

    public String notifyOver(DragSource source, EventObject e, DragData data) {
        if (data instanceof TreeDragData) {
            TreeDragData treeDragData = (TreeDragData)data;
            TreeNode treeNode = treeDragData.getTreeNode();
            if (!(treeNode.getUserObject() instanceof GWTWorkspaceItem)) {
                return NO_DROP;
            }
            GWTWorkspaceItem sourceItem = (GWTWorkspaceItem)treeNode.getUserObject();
            GridView view = this.folder.getView();
            int droppedRow = view.findRowIndex(e);
            GWTWorkspaceItem targetItem = null;
            if (droppedRow >= 0) {
                Record record = this.folder.getStore().getAt(droppedRow);
                targetItem = (GWTWorkspaceItem)record.getAsObject("item");
            } else {
                targetItem = this.folder.getShowedItem();
            }
            if (!GWTWorkspaceDD.canDrop((GWTWorkspaceItem)targetItem, (GWTWorkspaceItem)sourceItem)) {
                return NO_DROP;
            }
            return OK_DROP_ADD;
        }
        if (data instanceof GridDragData) {
            Record[] records;
            GridView view = this.folder.getView();
            int droppedRow = view.findRowIndex(e);
            GWTWorkspaceItem targetItem = null;
            if (droppedRow >= 0) {
                Record record = this.folder.getStore().getAt(droppedRow);
                targetItem = (GWTWorkspaceItem)record.getAsObject("item");
            } else {
                targetItem = this.folder.getShowedItem();
            }
            GridDragData gridDragData = (GridDragData)data;
            Record[] recordArray = records = gridDragData.getSelections();
            int n = records.length;
            int n2 = 0;
            while (n2 < n) {
                GWTWorkspaceItem sourceItem;
                Record record = recordArray[n2];
                if (record.getAsObject("item") instanceof GWTWorkspaceItem && !GWTWorkspaceDD.canDrop((GWTWorkspaceItem)targetItem, (GWTWorkspaceItem)(sourceItem = (GWTWorkspaceItem)record.getAsObject("item")))) {
                    return NO_DROP;
                }
                ++n2;
            }
            return OK_DROP_ADD;
        }
        return NO_DROP;
    }
}

