/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.workspace.client.explorer;

import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarItem;
import com.gwtext.client.widgets.ToolbarTextItem;
import java.util.List;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspaceFolder;
import org.gcube.portlets.user.workspace.client.workspace.GWTWorkspaceItem;
import org.gcube.portlets.user.workspace.client.workspace.events.GWTWorkspaceListener;
import org.gcube.portlets.user.workspace.client.workspace.folder.GWTLoadingFolder;
import org.gcube.portlets.user.workspace.client.workspace.folder.item.GWTExternalUrl;
import org.gcube.portlets.user.workspace.client.workspace.sharing.GWTItemSendRequest;

public class WorkspaceStatusBar
extends Toolbar
implements GWTWorkspaceListener {
    protected ToolbarTextItem status;

    public WorkspaceStatusBar() {
        this.setHeight(20);
        this.status = new ToolbarTextItem("Loading...");
        this.addItem((ToolbarItem)this.status);
    }

    public void itemMoved(GWTWorkspaceItem item) {
        this.status.setText(String.valueOf(item.getName()) + " moved.");
    }

    public void itemRemoved(GWTWorkspaceItem item) {
        this.status.setText(String.valueOf(item.getName()) + " removed.");
    }

    public void itemRenamed(GWTWorkspaceItem item) {
        this.status.setText(String.valueOf(item.getName()) + " renamed.");
    }

    public void onBeforeItemMove(GWTWorkspaceItem item) {
        this.status.setText("Moving on server side the " + item.getName() + " item.");
    }

    public void onBeforeItemRemove(GWTWorkspaceItem item) {
        this.status.setText("Removing on server side the " + item.getName() + " item.");
    }

    public void onBeforeItemRename(GWTWorkspaceItem item, String newName) {
        this.status.setText("Renaming on server side the " + item.getName() + " item.");
    }

    public void onBeforeWorkspaceCreate(GWTWorkspaceFolder parent, String tmpId, String newWorkspaceName) {
        this.status.setText("Creating on server side the new workspace " + newWorkspaceName + ".");
    }

    public void rootUpdated(GWTWorkspaceFolder root) {
        this.status.setText("User workspace area loaded.");
    }

    public void workspaceCreated(String tmpId, GWTWorkspaceFolder workspace) {
        this.status.setText(String.valueOf(workspace.getName()) + " workspace created.");
    }

    public void onBeforeRootUpdated() {
        this.status.setText("Retrieving workspace data from server...");
    }

    public void itemCloned(String tmpId, GWTWorkspaceItem item) {
        this.status.setText(String.valueOf(item.getName()) + " cloned.");
    }

    public void onBeforeItemCloned(GWTWorkspaceItem clonedItem, String tmpId, String cloneItemName) {
        this.status.setText("Cloning on server side the " + cloneItemName + " item.");
    }

    public void onOperationFailed(String message) {
        this.status.setText("Error: " + message);
    }

    public void itemDescriptionSetted(GWTWorkspaceItem item) {
        this.status.setText(String.valueOf(item.getName()) + " item description setted.");
    }

    public void onBeforeSetItemDescription(GWTWorkspaceItem item, String newDescription) {
        this.status.setText("Setting " + item.getName() + " item description on server side.");
    }

    public void loadingFoldersGetted(List<GWTLoadingFolder> folders) {
    }

    public void loadingFolderTerminated(GWTLoadingFolder loadingFolder) {
        this.status.setText("Folder " + loadingFolder.getName() + " imported.");
    }

    public void itemSendRequests(List<GWTItemSendRequest> requests) {
    }

    public void itemSent(GWTWorkspaceItem item) {
        this.status.setText("The item " + item.getName() + " has been sent.");
    }

    public void onBeforeUrlCreate(GWTWorkspaceFolder parent, String tmpId, String newUrlName) {
        this.status.setText("Creating the " + newUrlName + " on server side.");
    }

    public void urlCreated(String tmpId, GWTExternalUrl url) {
        this.status.setText("Url " + url.getName() + " created.");
    }
}

