/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.gcube.com.fasterxml.jackson.core.JsonProcessingException;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.utils.InnerMethodName;
import org.gcube.vremanagement.executor.annotation.PURGE;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.InvalidInputsException;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;
import org.gcube.vremanagement.executor.exception.SchedulerNotFoundException;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.json.SEMapper;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDefinition;
import org.gcube.vremanagement.executor.plugin.PluginStateEvolution;
import org.gcube.vremanagement.executor.plugin.ScheduledTask;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="plugins")
public class RestSmartExecutor {
    private static Logger logger = LoggerFactory.getLogger(RestSmartExecutor.class);
    private static final String UUID_PATH_PARAM = "UUID";
    private static final String PLUGIN_NAME_PATH_PARAM = "NAME";
    protected static final String LOCATION_HEADER = "Location";
    public static final String PLUGIN_ENDPOINT_FORMAT = "plugins/%s/executions";
    public static final String PLUGIN_ENDPOINT = "/{NAME}/executions";
    @Context
    protected UriInfo uriInfo;

    protected void setCalledMethod(String calledMethod) {
        logger.trace("Going to set calledMethod as '{}'", (Object)calledMethod);
        InnerMethodName.set((String)calledMethod);
        logger.info("Arrived request at {} with query parameters {}", (Object)this.uriInfo.getAbsolutePath(), (Object)this.uriInfo.getQueryParameters());
    }

    protected Response.ResponseBuilder addLocation(Response.ResponseBuilder responseBuilder, String id) {
        return responseBuilder.header(LOCATION_HEADER, (Object)"%s %s/%s".formatted(this.uriInfo.getAbsolutePath().toString(), id));
    }

    @GET
    @Produces(value={"application/json"})
    public String getAvailablePlugins() throws ExecutorException {
        this.setCalledMethod("getAvailablePlugins");
        try {
            PluginManager pluginManager = PluginManager.getInstance();
            Map availablePlugins = pluginManager.getAvailablePlugins();
            ArrayList<Plugin> plugins = new ArrayList<Plugin>();
            for (String pluginName : availablePlugins.keySet()) {
                plugins.add(pluginManager.getPlugin(pluginName));
            }
            return ExtendedSEMapper.getInstance().marshal(PluginDefinition.class, plugins);
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{NAME}/executions")
    @Produces(value={"application/json"})
    public String getScheduled(@PathParam(value="NAME") String pluginName) throws ExecutorException {
        this.setCalledMethod("getScheduledExecution");
        try {
            ArrayList<org.gcube.vremanagement.executor.scheduledtask.ScheduledTask> scheduledTasks;
            SmartExecutorPersistenceConnector persistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
            PluginManager.getInstance();
            ArrayList<String> plugins = new ArrayList<String>();
            boolean orphan = false;
            if (pluginName.compareTo("ORPHAN") != 0) {
                plugins.add(pluginName);
            } else {
                orphan = true;
            }
            ArrayList<org.gcube.vremanagement.executor.scheduledtask.ScheduledTask> gotScheduledTasks = persistenceConnector.getScheduledTasks(plugins);
            if (orphan) {
                scheduledTasks = new ArrayList<org.gcube.vremanagement.executor.scheduledtask.ScheduledTask>();
                for (org.gcube.vremanagement.executor.scheduledtask.ScheduledTask scheduledTask : gotScheduledTasks) {
                    if (!persistenceConnector.isOrphan(scheduledTask, false)) continue;
                    scheduledTasks.add(scheduledTask);
                }
            } else {
                scheduledTasks = gotScheduledTasks;
            }
            ArrayList<ScheduledTask> tasks = new ArrayList<ScheduledTask>();
            for (org.gcube.vremanagement.executor.scheduledtask.ScheduledTask scheduledTask : scheduledTasks) {
                ScheduledTask task = new ScheduledTask(scheduledTask.getUUID(), scheduledTask.getRunOn(), scheduledTask.getLaunchParameter());
                tasks.add(task);
            }
            return SEMapper.getInstance().marshal(ScheduledTask.class, tasks);
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @POST
    @Path(value="/{NAME}/executions")
    @Consumes(value={"text/plain", "application/json"})
    @Produces(value={"text/plain"})
    public String launch(@PathParam(value="NAME") String pluginName, String launchParameterString) throws ExecutorException {
        this.setCalledMethod("execute");
        try {
            logger.info("Requested to launch {} ({})", (Object)pluginName, (Object)launchParameterString);
            LaunchParameter launchParameter = (LaunchParameter)ExtendedSEMapper.getInstance().unmarshal(LaunchParameter.class, launchParameterString);
            if (pluginName == null) {
                String error = "Plugin Name provided in the URL (%s) cannot be null".formatted(pluginName);
                logger.error(error);
                throw new InputsNullException(error);
            }
            if (pluginName.compareTo(launchParameter.getPluginName()) != 0) {
                String error = "Plugin Name provided in the URL (%s) does not match with the one provided in %s (%s)".formatted(pluginName, LaunchParameter.class.getSimpleName(), launchParameter.getPluginName());
                logger.error(error);
                throw new InvalidInputsException(error);
            }
            SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
            Secret requestSecret = SecretManagerProvider.get();
            String taskContext = requestSecret.getContext();
            String ownerID = requestSecret.getOwner().getId();
            Secret secret = ContextProvider.get().container().authorizationProvider().getSecretForContext(taskContext);
            UUID uuid = UUID.randomUUID();
            try {
                AuthorizedTasks.executeSafely(() -> smartExecutorScheduler.schedule(launchParameter, uuid, ownerID), (Secret)secret);
            }
            catch (ExecutorException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ExecutorException(e);
            }
            logger.info("{} ({}) has been lauched with uuid {}", new Object[]{pluginName, launchParameterString, uuid});
            return uuid.toString();
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{NAME}/executions/{UUID}")
    @Produces(value={"application/json"})
    public String getLaunchState(@PathParam(value="NAME") String pluginName, @PathParam(value="UUID") String executionIdentifier, @QueryParam(value="iteration") Integer iteration) throws ExecutorException {
        this.setCalledMethod("getState");
        PluginStateEvolution pluginStateEvolution = null;
        try {
            SmartExecutorPersistenceConnector persistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
            pluginStateEvolution = persistenceConnector.getPluginInstanceState(UUID.fromString(executionIdentifier), iteration);
            logger.info("{} for {} (iteration n. {}) is {}", new Object[]{PluginStateEvolution.class.getSimpleName(), executionIdentifier, iteration, pluginStateEvolution});
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
        if (pluginName.compareTo(pluginStateEvolution.getPluginDefinition().getName()) != 0) {
            String error = "Plugin Name provided in the URL (%s) does not match with the one got from %s (%s)".formatted(pluginName, PluginStateEvolution.class.getSimpleName(), pluginStateEvolution.getPluginDefinition().getName());
            throw new InvalidInputsException(error);
        }
        try {
            return ExtendedSEMapper.getInstance().marshal((Object)pluginStateEvolution);
        }
        catch (JsonProcessingException e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{NAME}/executions/{UUID}")
    public Response delete(@PathParam(value="NAME") String pluginName, @PathParam(value="UUID") String executionIdentifier, @QueryParam(value="unschedule") Boolean unschedule) throws ExecutorException {
        try {
            if (unschedule == null) {
                unschedule = false;
            }
            this.setCalledMethod("stop");
            logger.info("Requested to delete for {} with UUID {}{}", new Object[]{pluginName, executionIdentifier, unschedule != false ? "globally" : ""});
            boolean currentStopped = true;
            try {
                SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
                UUID uuid = UUID.fromString(executionIdentifier);
                smartExecutorScheduler.stop(uuid, unschedule.booleanValue());
            }
            catch (SchedulerNotFoundException e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            catch (SchedulerException e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            catch (SchedulePersistenceException e) {
                logger.error("Error removing scheduled task from persistence.", (Throwable)e);
            }
            catch (ExecutorException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error("Error unscheduling task {}", (Object)executionIdentifier, (Object)e);
                throw new ExecutorException((Throwable)e);
            }
            logger.info("{} with UUID {} was{} stopped successfully", new Object[]{pluginName, executionIdentifier, currentStopped ? "" : " NOT"});
            if (currentStopped) {
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            throw new ExecutorException(pluginName + " with UUID " + executionIdentifier + " was NOT stopped successfully");
        }
        catch (ExecutorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutorException((Throwable)e);
        }
    }

    @PURGE
    @Path(value="/{NAME}/executions/{UUID}")
    public Response purge(@PathParam(value="NAME") String pluginName, @PathParam(value="UUID") String executionIdentifier) throws ExecutorException {
        return this.delete(pluginName, executionIdentifier, Boolean.valueOf(true));
    }
}

