/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduledtask;

import java.util.UUID;
import org.gcube.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.gcube.common.authorization.library.provider.ClientInfo;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.smartgears.ContextProvider;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.plugin.Ref;
import org.gcube.vremanagement.executor.plugin.RunOn;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="@class")
public class ScheduledTask
extends org.gcube.vremanagement.executor.plugin.ScheduledTask {
    protected String token;
    protected String context;
    protected ClientInfo clientInfo;
    public static final String LOCALHOST = "localhost";

    protected ScheduledTask() {
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter) throws Exception {
        this(uuid, launchParameter, ScheduledTask.generateRunOn());
    }

    public ScheduledTask(UUID uuid, LaunchParameter launchParameter, RunOn runOn) throws Exception {
        this.uuid = uuid;
        this.launchParameter = launchParameter;
        SecretManager secretManager = SecretManagerProvider.instance.get();
        Secret secret = (Secret)secretManager.getCurrentSecretHolder().getSecrets().first();
        this.token = secret.getToken();
        this.context = secretManager.getContext();
        this.clientInfo = secret.getClientInfo();
        this.runOn = runOn;
    }

    public String getToken() {
        return this.token;
    }

    public String getContext() {
        return this.context;
    }

    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public static RunOn generateRunOn() {
        Ref hostingNodeRef = null;
        try {
            HostingNode hostingNode = (HostingNode)ContextProvider.get().container().profile(HostingNode.class);
            hostingNodeRef = new Ref(hostingNode.id(), hostingNode.profile().description().name());
        }
        catch (Exception e) {
            hostingNodeRef = new Ref(LOCALHOST, LOCALHOST);
        }
        Ref eServiceRef = null;
        try {
            GCoreEndpoint gCoreEndpoint = (GCoreEndpoint)ContextProvider.get().profile(GCoreEndpoint.class);
            String address = "";
            Group endpoints = gCoreEndpoint.profile().endpoints();
            for (GCoreEndpoint.Profile.Endpoint endpoint : endpoints) {
                if (endpoint.name().contains("remote-management")) continue;
                address = endpoint.uri().toString();
                break;
            }
            eServiceRef = new Ref(gCoreEndpoint.id(), address);
        }
        catch (Exception e) {
            eServiceRef = new Ref(LOCALHOST, LOCALHOST);
        }
        RunOn runOn = new RunOn(hostingNodeRef, eServiceRef);
        return runOn;
    }

    public String toString() {
        try {
            return ExtendedSEMapper.getInstance().marshal((Object)this);
        }
        catch (Exception e) {
            return "ScheduledTask [token=" + this.token + ", context=" + this.context + ", clientInfo=" + this.clientInfo + ", uuid=" + this.uuid + ", launchParameter=" + this.launchParameter + ", runOn=" + this.runOn + "]";
        }
    }
}

