/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gcube.common.authorization.utils.manager.SecretManager;
import org.gcube.common.authorization.utils.manager.SecretManagerProvider;
import org.gcube.common.authorization.utils.secret.Secret;
import org.gcube.common.authorization.utils.secret.SecretUtility;
import org.gcube.smartgears.ApplicationManager;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.executor.ContextUtility;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.ispublisher.ISPublisher;
import org.gcube.vremanagement.executor.ispublisher.RestISPublisher;
import org.gcube.vremanagement.executor.json.ExtendedSEMapper;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.rest.RequestFilter;
import org.gcube.vremanagement.executor.scheduledtask.ScheduledTask;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorSchedulerFactory;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorInitializator
implements ApplicationManager {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorInitializator.class);
    public static final long JOIN_TIMEOUT = 1000L;

    public void onInit() {
        SmartExecutorPersistenceConnector smartExecutorPersistenceConnector;
        RequestFilter requestFilter = new RequestFilter();
        try {
            requestFilter.filter(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        final String context = ContextUtility.getCurrentContext();
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Starting on context {}\n-------------------------------------------------------", (Object)context);
        logger.debug("Getting Available Plugins and their own supported capabilities");
        PluginManager pluginManager = PluginManager.getInstance();
        Map<String, Class<? extends Plugin>> availablePlugins = pluginManager.getAvailablePlugins();
        ApplicationContext applicationContext = ContextProvider.get();
        List<ISPublisher> isPublishers = ISPublisher.getISPublishers(applicationContext);
        for (ISPublisher isPublisher : isPublishers) {
            try {
                isPublisher.unpublishPlugins(true);
            }
            catch (Exception e) {
                logger.error("Unable to unpublish plugins from IS using {}. Trying to continue.", (Object)isPublisher.getClass().getName());
            }
            try {
                isPublisher.publishPlugins(availablePlugins);
            }
            catch (Exception e) {
                if (isPublisher instanceof RestISPublisher) {
                    logger.warn("Unable to create RunningPlugin in context {}. {}", (Object)context, (Object)e.getMessage());
                    continue;
                }
                logger.error("Unable to create ServiceEndpoint in context {}. The Service will be aborted", (Object)context, (Object)e);
                throw new RuntimeException(e);
            }
        }
        try {
            smartExecutorPersistenceConnector = SmartExecutorPersistenceFactory.getPersistenceConnector();
        }
        catch (Exception e) {
            logger.error("Unable to instantiate {} for scope {}. The Service will be aborted", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), context, e});
            throw new RuntimeException(e);
        }
        try {
            logger.debug("Going to get Orphan Scheduled Tasks in scope {}", (Object)context);
            List gotScheduledTasks = smartExecutorPersistenceConnector.getScheduledTasks(pluginManager.getAvailablePlugins().keySet());
            ArrayList<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
            for (final ScheduledTask scheduledTask : gotScheduledTasks) {
                if (!smartExecutorPersistenceConnector.isOrphan(scheduledTask, true)) continue;
                scheduledTasks.add(scheduledTask);
            }
            if (scheduledTasks.size() == 0) {
                logger.debug("No Orphan Scheduled Tasks this instance can take in charge in scope {}", (Object)context);
            }
            for (final ScheduledTask scheduledTask : scheduledTasks) {
                final String taskAsString = ExtendedSEMapper.getInstance().marshal((Object)scheduledTask);
                try {
                    smartExecutorPersistenceConnector.reserveScheduledTask(scheduledTask);
                }
                catch (Exception e) {
                    logger.debug("({}) Someone else is going to take in charge the scheduled task {}. Skipping.", (Object)context, (Object)taskAsString);
                    continue;
                }
                Thread thread = new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LaunchParameter launchParameter = scheduledTask.getLaunchParameter();
                        try {
                            logger.info("({}) Going to schedule an already scheduled task with the following parameters {}", (Object)context, (Object)ExtendedSEMapper.getInstance().marshal(launchParameter));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        String scheduledTasktoken = scheduledTask.getToken();
                        Secret secret = SecretUtility.getSecretByTokenString((String)scheduledTasktoken);
                        SecretManager secretManager = SecretManagerProvider.instance.get();
                        try {
                            secretManager.startSession(secret);
                            SmartExecutorScheduler smartExecutorScheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
                            smartExecutorPersistenceConnector.removeScheduledTask(scheduledTask);
                            smartExecutorScheduler.schedule(launchParameter, scheduledTask.getUUID());
                        }
                        catch (Exception e) {
                            logger.error("({}) Error while trying to relaunch scheduled task.", (Object)context, (Object)e);
                            try {
                                smartExecutorPersistenceConnector.addScheduledTask(scheduledTask);
                            }
                            catch (Exception ex) {
                                logger.error("({}) Unable to add back scheduled task {}", (Object)context, (Object)taskAsString);
                            }
                        }
                        finally {
                            secretManager.endSession();
                        }
                    }
                };
                thread.start();
            }
        }
        catch (Exception e) {
            logger.error("Unable to get Orphan Scheduled Tasksfor scope {}.", (Object)context, (Object)e);
            return;
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Started Successfully on context {}\n-------------------------------------------------------", (Object)context);
    }

    public void onShutdown() {
        RequestFilter requestFilter = new RequestFilter();
        try {
            requestFilter.filter(null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor is Stopping on context {}\n-------------------------------------------------------", (Object)ContextUtility.getCurrentContext());
        try {
            SmartExecutorScheduler scheduler = SmartExecutorSchedulerFactory.getSmartExecutorScheduler();
            scheduler.stopAll();
            SmartExecutorSchedulerFactory.removeCurrentSmartExecutorScheduler();
        }
        catch (SchedulerException e) {
            logger.error("", (Throwable)e);
        }
        ApplicationContext applicationContext = ContextProvider.get();
        List<ISPublisher> isPublishers = ISPublisher.getISPublishers(applicationContext);
        for (ISPublisher isPublisher : isPublishers) {
            try {
                isPublisher.unpublishPlugins(false);
            }
            catch (Exception e) {
                logger.error("unable to unpublish plugins from IS using {}", (Object)isPublisher.getClass().getName());
            }
        }
        try {
            SmartExecutorPersistenceFactory.closeCurrentPersistenceConnector();
        }
        catch (Throwable e) {
            logger.error("Unable to correctly close {} for context {}", new Object[]{SmartExecutorPersistenceConnector.class.getSimpleName(), ContextUtility.getCurrentContext(), e});
        }
        logger.trace("\n-------------------------------------------------------\nSmart Executor Stopped Successfully on context {}\n-------------------------------------------------------", (Object)ContextUtility.getCurrentContext());
    }
}

