/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.ispublisher;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.IdentifiableElement;
import org.gcube.informationsystem.model.impl.properties.HeaderImpl;
import org.gcube.informationsystem.model.impl.properties.PropagationConstraintImpl;
import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.model.reference.properties.Header;
import org.gcube.informationsystem.model.reference.properties.PropagationConstraint;
import org.gcube.informationsystem.model.reference.relations.ConsistsOf;
import org.gcube.informationsystem.model.reference.relations.IsRelatedTo;
import org.gcube.informationsystem.resourceregistry.api.exceptions.AvailableInAnotherContextException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.NotFoundException;
import org.gcube.informationsystem.resourceregistry.api.exceptions.ResourceRegistryException;
import org.gcube.informationsystem.resourceregistry.client.Direction;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClient;
import org.gcube.informationsystem.resourceregistry.client.ResourceRegistryClientFactory;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisher;
import org.gcube.informationsystem.resourceregistry.publisher.ResourceRegistryPublisherFactory;
import org.gcube.resourcemanagement.model.impl.entities.facets.SimplePropertyFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.facets.SoftwareFacetImpl;
import org.gcube.resourcemanagement.model.impl.entities.resources.RunningPluginImpl;
import org.gcube.resourcemanagement.model.impl.relations.consistsof.IsIdentifiedByImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.ActivatesImpl;
import org.gcube.resourcemanagement.model.impl.relations.isrelatedto.EnablesImpl;
import org.gcube.resourcemanagement.model.reference.entities.resources.EService;
import org.gcube.resourcemanagement.model.reference.entities.resources.RunningPlugin;
import org.gcube.resourcemanagement.model.reference.entities.resources.Service;
import org.gcube.resourcemanagement.model.reference.entities.resources.Software;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.Activates;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.vremanagement.executor.ispublisher.ISPublisher;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestISPublisher
extends ISPublisher {
    private static Logger logger = LoggerFactory.getLogger(RestISPublisher.class);
    protected final UUID eServiceUUID;
    protected ResourceRegistryClient resourceRegistryClient;
    protected ResourceRegistryPublisher resourceRegistryPublisher;

    public RestISPublisher(ApplicationContext applicationContext) {
        super(applicationContext);
        this.eServiceUUID = UUID.fromString(applicationContext.id());
        this.resourceRegistryClient = ResourceRegistryClientFactory.create();
        this.resourceRegistryPublisher = ResourceRegistryPublisherFactory.create();
    }

    protected RunningPlugin publishRunningPluginWithRelations(Plugin plugin, UUID pluginUUID) throws Exception {
        RunningPluginImpl runningPlugin = new RunningPluginImpl();
        runningPlugin.setHeader((Header)new HeaderImpl(pluginUUID));
        SoftwareFacetImpl softwareFacet = new SoftwareFacetImpl();
        softwareFacet.setGroup(plugin.getGroup());
        softwareFacet.setName(plugin.getName());
        softwareFacet.setVersion(plugin.getVersion());
        softwareFacet.setDescription(plugin.getDescription());
        IsIdentifiedByImpl isIdentifiedBy = new IsIdentifiedByImpl((Resource)runningPlugin, (Facet)softwareFacet);
        runningPlugin.addFacet((ConsistsOf)isIdentifiedBy);
        Map pluginCapabilities = plugin.getSupportedCapabilities();
        if (pluginCapabilities != null) {
            for (String capabilityName : pluginCapabilities.keySet()) {
                SimplePropertyFacetImpl simplePropertyFacet = new SimplePropertyFacetImpl();
                simplePropertyFacet.setName(capabilityName);
                simplePropertyFacet.setValue((String)pluginCapabilities.get(capabilityName));
                runningPlugin.addFacet((Facet)simplePropertyFacet);
            }
        }
        EService smartExecutorEService = (EService)this.resourceRegistryClient.getInstance(EService.class, this.eServiceUUID);
        PropagationConstraintImpl usesPropagationConstraint = new PropagationConstraintImpl();
        usesPropagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
        usesPropagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.cascade);
        ActivatesImpl activates = new ActivatesImpl((Service)smartExecutorEService, (Service)runningPlugin, (PropagationConstraint)usesPropagationConstraint);
        try {
            this.resourceRegistryPublisher.createIsRelatedTo((IsRelatedTo)activates);
        }
        catch (ResourceRegistryException e) {
            logger.error("Unable to publish %s instace %s for plugin %s. I'm going to stop the service.", new Object[]{"Resource", "RunningPlugin", plugin.getName()});
            throw e;
        }
        Software pluginResource = null;
        if (pluginResource != null) {
            PropagationConstraintImpl enablesPropagationConstraint = new PropagationConstraintImpl();
            enablesPropagationConstraint.setAddConstraint(PropagationConstraint.AddConstraint.propagate);
            enablesPropagationConstraint.setRemoveConstraint(PropagationConstraint.RemoveConstraint.keep);
            EnablesImpl enables = new EnablesImpl((Service)runningPlugin, pluginResource, (PropagationConstraint)enablesPropagationConstraint);
            try {
                this.resourceRegistryPublisher.createIsRelatedTo((IsRelatedTo)enables);
            }
            catch (ResourceRegistryException e) {
                logger.error("Unable to publish %s instace %s for plugin %s. I'm going to stop the service.", new Object[]{"Resource", "RunningPlugin", plugin.getName()});
                throw e;
            }
        }
        return runningPlugin;
    }

    public void publishPlugins(Map<String, Class<? extends Plugin>> availablePlugins) throws Exception {
        PluginManager pluginManager = PluginManager.getInstance();
        for (String pluginName : availablePlugins.keySet()) {
            RunningPluginImpl runningPlugin;
            Plugin plugin = pluginManager.getPlugin(pluginName);
            UUID pluginUUID = pluginManager.getPluginUUID(pluginName);
            try {
                runningPlugin = (RunningPlugin)this.resourceRegistryClient.getInstance(RunningPlugin.class, pluginUUID);
            }
            catch (NotFoundException e) {
                runningPlugin = this.publishRunningPluginWithRelations(plugin, pluginUUID);
            }
            catch (AvailableInAnotherContextException e) {
                runningPlugin = new RunningPluginImpl();
                runningPlugin.setHeader((Header)new HeaderImpl(pluginUUID));
                this.resourceRegistryPublisher.addToCurrentContext((IdentifiableElement)runningPlugin);
            }
            catch (ResourceRegistryException e) {
                throw e;
            }
        }
    }

    public void unpublishPlugins(boolean force) throws Exception {
        if (force) {
            List runningPlugins = this.resourceRegistryClient.getRelatedResourcesFromReferenceResource(RunningPlugin.class, Activates.class, EService.class, this.eServiceUUID, Direction.IN, true);
            for (RunningPlugin runningPlugin : runningPlugins) {
                this.resourceRegistryPublisher.delete((IdentifiableElement)runningPlugin);
            }
        } else {
            logger.info("The Plugin will be removed when the Eservice will be removed thanks to propagation contraints. Nothing to do");
        }
    }
}

