/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor.scheduler;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.api.types.Scheduling;
import org.gcube.vremanagement.executor.exception.AlreadyInFinalStateException;
import org.gcube.vremanagement.executor.exception.InvalidPluginStateEvolutionException;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceConnector;
import org.gcube.vremanagement.executor.persistence.SmartExecutorPersistenceFactory;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.plugin.PluginStateNotification;
import org.gcube.vremanagement.executor.pluginmanager.PluginManager;
import org.gcube.vremanagement.executor.pluginmanager.RunnablePlugin;
import org.gcube.vremanagement.executor.scheduler.JobCompletedNotification;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorSchedulerFactory;
import org.quartz.InterruptableJob;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartExecutorTask
implements InterruptableJob {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorTask.class);
    public static final String UUID = "UUID";
    public static final String LAUNCH_PARAMETER = "LAUNCH_PARAMETER";
    public static final String TOKEN = "TOKEN";
    protected static Map<UUID, Integer> executionsCount = new HashMap();
    protected static Map<UUID, Map<Integer, PluginState>> executionsState = new HashMap();
    protected List<PluginStateNotification> pluginStateNotifications = new ArrayList();
    protected boolean initialized = false;
    protected UUID uuid;
    protected LaunchParameter launchParameter;
    protected String token;
    protected int executionCount;
    protected String pluginName;
    protected Plugin plugin;
    protected Map<String, Object> inputs;
    protected RunnablePlugin<Plugin> runnablePlugin;
    protected boolean mustPreviousExecutionsCompleted;
    protected int maxExecutionNumber;
    protected Boolean interrupted = false;

    public static Map<UUID, Integer> getExecutionsCount() {
        return executionsCount;
    }

    protected void init(JobDataMap jobDataMap) throws JobExecutionException {
        Map pluginStateNotificationWithInputs;
        this.uuid = (UUID)jobDataMap.get((Object)UUID);
        this.launchParameter = (LaunchParameter)jobDataMap.get((Object)LAUNCH_PARAMETER);
        this.token = (String)jobDataMap.get((Object)TOKEN);
        this.pluginName = this.launchParameter.getPluginName();
        PluginManager pluginManager = PluginManager.getInstance();
        try {
            this.plugin = pluginManager.getPlugin(this.pluginName);
        }
        catch (Exception e) {
            throw new JobExecutionException((Throwable)e);
        }
        this.inputs = this.launchParameter.getInputs();
        Scheduling scheduling = this.launchParameter.getScheduling();
        if (scheduling != null) {
            this.mustPreviousExecutionsCompleted = scheduling.mustPreviousExecutionsCompleted();
            if (this.mustPreviousExecutionsCompleted) {
                Map<Integer, PluginState> executionState;
                if (executionsState.containsKey(this.uuid)) {
                    executionState = (Map)executionsState.get(this.uuid);
                } else {
                    executionState = new HashMap();
                    executionsState.put(this.uuid, executionState);
                    executionState.put(0, PluginState.DONE);
                }
                this.pluginStateNotifications.add(new JobCompletedNotification(executionState));
            }
            this.maxExecutionNumber = scheduling.getSchedulingTimes();
        }
        if ((pluginStateNotificationWithInputs = this.launchParameter.getPluginStateNotifications()) != null) {
            for (String pluginStateNotificationsClassName : pluginStateNotificationWithInputs.keySet()) {
                if (pluginStateNotificationsClassName.compareTo(SmartExecutorPersistenceConnector.class.getName()) == 0) {
                    logger.warn("{} is for internal use only. It will be skypped", (Object)pluginStateNotificationsClassName);
                    continue;
                }
                if (pluginStateNotificationsClassName.compareTo(JobCompletedNotification.class.getName()) == 0) {
                    logger.warn("{} is for internal use only. It will be skypped", (Object)pluginStateNotificationsClassName);
                    continue;
                }
                try {
                    logger.trace("Trying to instantiate {}", (Object)pluginStateNotificationsClassName);
                    Class<?> clazz = Class.forName(pluginStateNotificationsClassName);
                    Constructor<?> constructor = clazz.getConstructor(Map.class);
                    Map notificationInputs = (Map)pluginStateNotificationWithInputs.get(pluginStateNotificationsClassName);
                    PluginStateNotification pluginStateNotification = (PluginStateNotification)constructor.newInstance(notificationInputs);
                    logger.trace("{} succesfully instantiated : {}", (Object)pluginStateNotificationsClassName, (Object)pluginStateNotification);
                    this.pluginStateNotifications.add(pluginStateNotification);
                }
                catch (Exception e) {
                    logger.error("Error instantiating {} : {}. It will be ignored", (Object)pluginStateNotificationsClassName, (Object)e.getMessage());
                }
            }
        }
        this.initialized = true;
    }

    public SmartExecutorTask() throws Exception {
        this.pluginStateNotifications.add(SmartExecutorPersistenceFactory.getPersistenceConnector());
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public LaunchParameter getLaunchParameter() {
        return this.launchParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        logger.debug("Execute of {}", (Object)this);
        SmartExecutorTask smartExecutorTask = this;
        synchronized (smartExecutorTask) {
            if (this.interrupted.booleanValue()) {
                logger.info("A job interruption has been called before that this {} has been executed for the first time", (Object)SmartExecutorTask.class.getSimpleName());
                return;
            }
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            logger.debug("Execute of {} with {}", (Object)this, (Object)jobDataMap);
            if (!this.initialized) {
                this.init(jobDataMap);
            }
            this.executionCount = executionsCount.containsKey(this.uuid) ? (Integer)executionsCount.get(this.uuid) : 0;
            ++this.executionCount;
            executionsCount.put(this.uuid, this.executionCount);
            if (this.isMaxExecutionNumberReached()) {
                logger.debug("The Scheduled Max Number of execution ({}) is reached. The SmartExecutor Task {} will be descheduled", (Object)this.maxExecutionNumber, (Object)this.uuid);
                try {
                    this.unschedule(true);
                }
                catch (Exception e) {
                    throw new JobExecutionException((Throwable)e);
                }
                return;
            }
            this.runnablePlugin = new RunnablePlugin(this.plugin, this.inputs, this.uuid, this.executionCount, this.pluginStateNotifications, this.token);
            logger.debug("Going to run Job with ID {} (iteration {})", (Object)this.uuid, (Object)this.executionCount);
        }
        if (this.mustPreviousExecutionsCompleted) {
            Map executionState = (Map)executionsState.get(this.uuid);
            boolean previousExecutionCompleted = true;
            int notTerminatedExecutionNumber = -1;
            for (int i = this.executionCount - 1; i >= 0; --i) {
                PluginState previousState = (PluginState)executionState.get(i);
                previousExecutionCompleted = previousState.isFinalState();
                if (previousExecutionCompleted) continue;
                notTerminatedExecutionNumber = i;
                break;
            }
            if (previousExecutionCompleted) {
                this.runnablePlugin.run();
            } else {
                logger.info("A previuos execution ({}) is still not completed. The Launch Parameters require this. This execution ({}) is discarded.", (Object)notTerminatedExecutionNumber, (Object)this.executionCount);
                try {
                    this.runnablePlugin.setState(PluginState.DISCARDED);
                }
                catch (AlreadyInFinalStateException | InvalidPluginStateEvolutionException throwable) {}
            }
        } else {
            this.runnablePlugin.run();
        }
    }

    protected synchronized void finished(JobExecutionContext context) {
        logger.debug("Job with ID {} (iteration {})terminated", (Object)this.uuid, (Object)this.executionCount);
    }

    public synchronized void interrupt() throws UnableToInterruptJobException {
        if (!this.initialized) {
            logger.info("{} does not need to be interrupted, because the execute method is not still called.", (Object)SmartExecutorTask.class.getSimpleName());
            this.interrupted = true;
            return;
        }
        logger.debug("Trying to interrupt {} iteration({})", (Object)this.uuid, (Object)this.executionCount);
        try {
            logger.debug("Requesting Stop to plugin instance ({}) identified by the UUID {} of Plugin named {}", new Object[]{this.executionCount, this.uuid, this.pluginName});
            this.runnablePlugin.stop();
            logger.debug("Plugin instance ({}) identified by the UUID {} of Plugin named {} stopped itself correctly.", new Object[]{this.executionCount, this.uuid, this.pluginName});
        }
        catch (Exception e) {
            logger.error("Running plugin instance ({}) identified by the UUID {} of Plugin named {} failed to request of being stopped.", new Object[]{this.executionCount, this.uuid, this.pluginName});
        }
    }

    protected boolean isMaxExecutionNumberReached() {
        if (this.maxExecutionNumber == 0) {
            return false;
        }
        return this.executionCount > this.maxExecutionNumber;
    }

    protected void unschedule(boolean globally) throws Exception {
        SmartExecutorSchedulerFactory.getSmartExecutorScheduler().stop(this.uuid, globally);
    }

    public String toString() {
        if (!this.initialized) {
            return super.toString();
        }
        return String.format("JOb with ID %s (iteration %d). Parameters : %s", this.uuid, this.executionCount, this.launchParameter);
    }
}

