/**
 * 
 */
package org.gcube.vremanagement.executor.configuration;

import java.util.List;
import java.util.UUID;

import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.SchedulePersistenceException;

/**
 * Every implementation MUST take in account to store/query the records
 * on the current scope which is not passed as argument but MUSt be retrieved
 * using {#org.gcube.common.scope.api.ScopeProvider} facilities
 * i.e. ScopeProvider.instance.get()
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public interface ScheduledTaskConfiguration {

	/**
	 * Retrieve from the #SmartExecutorPersistenceConnector the orphaned
	 * Scheduled tasks
	 * @return the list of orphaned Scheduled
	 * @throws SchedulePersistenceException if fails
	 */
	public List<LaunchParameter> getAvailableScheduledTasks() throws SchedulePersistenceException;
	
	/**
	 * @param uuid the uuid which identify the task on the SmartExecutor instance
	 * @param parameter
	 * @throws SchedulePersistenceException
	 */
	public void addScheduledTask(UUID uuid, String consumerID, LaunchParameter parameter) throws SchedulePersistenceException;
	
	/**
	 * @param uuid
	 * @throws SchedulePersistenceException
	 */
	public void reserveScheduledTask(UUID uuid, String consumerID) throws SchedulePersistenceException;
	
	/**
	 * @param uuid the uuid which identify the task on the SmartExecutor instance
	 * @param parameter
	 * @throws SchedulePersistenceException
	 */
	public void removeScheduledTask(UUID uuid)throws SchedulePersistenceException;
	
	/**
	 * 
	 * @param uuid
	 * @throws SchedulePersistenceException
	 */
	public void releaseScheduledTask(UUID uuid) throws SchedulePersistenceException;
	
}
