/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.executor;

import java.util.UUID;
import javax.jws.WebService;
import org.gcube.vremanagement.executor.SmartExecutorInitalizator;
import org.gcube.vremanagement.executor.api.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.persistence.JDBCPersistenceConnector;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.gcube.vremanagement.executor.scheduler.SmartExecutorScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService(portName="SmartExecutorPort", serviceName="gcube/vremanagement/smart-executor", targetNamespace="http://gcube-system.org/", endpointInterface="org.gcube.vremanagement.executor.api.SmartExecutor")
public class SmartExecutorImpl
implements SmartExecutor {
    private static Logger logger = LoggerFactory.getLogger(SmartExecutorImpl.class);

    public String launch(LaunchParameter parameter) throws InputsNullException, PluginNotFoundException, LaunchException, ExecutorException {
        SmartExecutorScheduler smartExecutorScheduler = SmartExecutorInitalizator.getSmartExecutorScheduler();
        UUID uuid = smartExecutorScheduler.schedule(parameter);
        logger.debug(String.format("The Plugin named %s with UUID %s has been launched with the provided inputs", parameter.getName(), uuid));
        return uuid.toString();
    }

    public PluginState getState(String executionIdentifier) throws PluginInstanceNotFoundException, ExecutorException {
        try {
            JDBCPersistenceConnector jdbcPersistenceConnector = SmartExecutorInitalizator.getJdbcPersistenceConnector();
            return jdbcPersistenceConnector.getLastPluginInstanceState(UUID.fromString(executionIdentifier));
        }
        catch (Exception e) {
            throw new PluginInstanceNotFoundException();
        }
    }

    public PluginState getIterationState(String executionIdentifier, int iterationNumber) throws PluginInstanceNotFoundException, ExecutorException {
        try {
            JDBCPersistenceConnector jdbcPersistenceConnector = SmartExecutorInitalizator.getJdbcPersistenceConnector();
            return jdbcPersistenceConnector.getPluginInstanceState(UUID.fromString(executionIdentifier), iterationNumber);
        }
        catch (Exception e) {
            throw new PluginInstanceNotFoundException();
        }
    }
}

