/**
 * 
 */
package org.gcube.vremanagement.executor.pluginmanager;

import java.util.Map;
import java.util.UUID;

import org.gcube.vremanagement.executor.SmartExecutorInitalizator;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.gcube.vremanagement.executor.plugin.PluginDeclaration;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 *
 */
public class PluginThread<T extends Plugin<? extends PluginDeclaration>> extends Thread {
	
	/**
	 * Logger
	 */
	private static Logger logger = LoggerFactory.getLogger(PluginThread.class);
	
	protected static final String SEPARATOR = "---";
	
	public static final String getThreadName(Plugin<? extends PluginDeclaration> plugin, 
			Map<String, Object> inputs, UUID uuid){
		return String.format("%s%s%s%s%s", 
				plugin.getPluginDeclaration().getName(),SEPARATOR, 
				inputs.hashCode(), SEPARATOR, uuid);
	}
	
	protected final T plugin;
	protected final UUID uuid;
	protected final Map<String, Object> inputs;
		
	public PluginThread(T plugin, Map<String, Object> inputs, UUID uuid){
		super(getThreadName(plugin, inputs, uuid));
		this.plugin = plugin;
		this.uuid = uuid;
		this.inputs = inputs;
		this.plugin.setState(PluginState.CREATED);
	}
	
	@Override
	public void run(){
		try {
			plugin.setState(PluginState.RUNNING);
			plugin.launch(inputs);
			plugin.setState(PluginState.DONE);
		} catch(Exception e) {
			logger.trace(String.format("Thread %s failed", getName()),e);
			plugin.setState(PluginState.FAILED);
		} finally{
			SmartExecutorInitalizator.getPluginInstances().remove(uuid);
		}
	}
	
	/**
	 * @return the plugin
	 */
	public T getPlugin() {
		return plugin;
	}

	/**
	 * @return the launchInputs
	 */
	public Map<String, Object> getInputs() {
		return inputs;
	}
	
}
