/**
 * 
 */
package org.gcube.vremanagement.executor.client.proxies;

import static org.gcube.common.clients.exceptions.FaultDSL.again;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.vremanagement.executor.api.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.LaunchException;
import org.gcube.vremanagement.executor.exception.PluginInstanceNotFoundException;
import org.gcube.vremanagement.executor.exception.PluginNotFoundException;
import org.gcube.vremanagement.executor.plugin.PluginState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR) http://www.lucafrosini.com/
 */
public class DefaultSmartExecutorProxy implements SmartExecutorProxy {

	/**
	 * Logger
	 */
	private static Logger logger = LoggerFactory.getLogger(DefaultSmartExecutorProxy.class);
	
	private ProxyDelegate<SmartExecutor> proxyDelegate;
	
	public DefaultSmartExecutorProxy(ProxyDelegate<SmartExecutor> proxyDelegate) {
		this.proxyDelegate = proxyDelegate;
	}

	/** {@inheritDoc} */
	@Override
	public String launch(final LaunchParameter launchParameter)
			throws InputsNullException, PluginNotFoundException,
			LaunchException, ExecutorException {
		
		Call<SmartExecutor, String> call = new Call<SmartExecutor, String>() {
			@Override
			public String call(SmartExecutor endpoint) throws Exception {
				logger.debug("Calling launch() function");
				return endpoint.launch(launchParameter);
			}
		};
		
		try {
			return proxyDelegate.make(call);
		} catch (Exception e) {
			logger.debug("Failed to call launch() function");
			throw again(e).asServiceException();
		}
		
	}

	/** {@inheritDoc} */
	@Override
	public PluginState getState(final String executionIdentifier)
			throws PluginInstanceNotFoundException, ExecutorException {
		
		Call<SmartExecutor, PluginState> call = new Call<SmartExecutor, PluginState>() {
			@Override
			public PluginState call(SmartExecutor endpoint) throws Exception {
				logger.debug("Calling getState() function");
				return endpoint.getState(executionIdentifier);
			}
		};
		
		try {
			return proxyDelegate.make(call);
		} catch (Exception e) {
			logger.debug("Failed to call getState() function");
			throw again(e).asServiceException();
		}
	}

}
