package org.gcube.vremanagement.helloworld;

import java.util.Map;

import org.gcube.vremanagement.executor.exception.InputsNullException;
import org.gcube.vremanagement.executor.exception.InvalidInputsException;
import org.gcube.vremanagement.executor.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Luca Frosini (ISTI - CNR)
 */
public class HelloWorldPlugin extends Plugin {

	/**
	 * Logger
	 */
	private static Logger logger = LoggerFactory.getLogger(HelloWorldPlugin.class);
	
	/**
	 * Configuration parameter name for sleep time in milliseconds
	 */
	public static final String SLEEP_TIME = "sleepTime";
	
	/**
	 * Default constructor for HelloWorldPlugin
	 */
	public HelloWorldPlugin() {
		super();
		logger.debug("{} contructor", this.getClass().getSimpleName());
	}
	
	/**{@inheritDoc}*/
	@Override
	public void launch(Map<String, Object> inputs) throws Exception {
		logger.debug("My UUID is {}", uuid.toString());
		logger.debug("My iteration number is {}", iterationNumber);
		
		logger.debug("Launching HelloWorld");
		if(inputs == null){
			throw new InputsNullException();
		}else if(inputs.isEmpty() || !inputs.containsKey(SLEEP_TIME)){
			logger.debug("HelloWorld inputs {} are not valid", inputs);
			throw new InvalidInputsException();
		}
		
		this.setPercentageEvolution(20);
		logger.debug("{} - Inputs : {}", this.getClass().getSimpleName(), inputs);
		
		this.setPercentageEvolution(30);
		
		Long sleepTime;
		Object sleepTimeObject = inputs.get(SLEEP_TIME);
		if(sleepTimeObject instanceof Integer integer){
			sleepTime = Long.valueOf(integer);
		}else if(sleepTimeObject instanceof Long long1){
			sleepTime = long1;
		} else {
			sleepTime = Long.valueOf(sleepTimeObject.toString());
		}
		
		Thread.sleep(sleepTime);
		
		this.setPercentageEvolution(90);
		logger.debug("HelloWorld finished");
	}

	/**{@inheritDoc}*/
	@Override
	protected void onStop() throws Exception {
		logger.debug("onStop()");
		Thread.currentThread().interrupt();
	}
	
	public Map<String,String> getSupportedCapabilities() {
		logger.debug("getSupportedCapabilities() {}", HelloWorldPlugin.class.getSimpleName());
		return null;
	}

}
