package org.gcube.vremanagement.contextmanager.handlers;


import java.util.List;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resource.Type;

public interface ResourceHandler {

	public List<Type> getManagedResources();
	
	public void addResource(String contextName, Resource resource);
	
	public void removeResource(String contextName, Resource resource);
	
	//in case of resource created directly by the publisher
	public void createResourceNotified(String contextName, Resource resource);
	
	//in case of resource deleted directly by the publisher
	public void removeResourceNotified(String contextName, Resource resource);
	
}
