package org.gcube.vremanagement.contextmanager;

import java.util.Iterator;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;

import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.Resource.Type;
import org.gcube.vremanagement.contextmanager.handlers.ResourceHandler;
import org.gcube.vremanagement.contextmanager.model.collectors.BackendConnector;


@Singleton
public class ResourceManager {

	@Inject
	@Any
	Instance<ResourceHandler> resourcesHandlers;
	
	@Inject
	@Default
	BackendConnector defaultCollector;

	public ScopedResource addResourceToContext(String context, Resource resource) {
		ResourceHandler handler = retrieveHandler(resource.type());
		handler.addResource(context, resource);
		return getScopedResource(resource);
	}

	public ScopedResource removeResourceFromContext(String context, String id ) {
		Resource res = retrieveResource(id);
		ResourceHandler handler = retrieveHandler(res.type());
		handler.removeResource(context, res);
		return getScopedResource(res);
	}

	private Resource retrieveResource(String id) {
		return defaultCollector.find(id);
		/*
		XQuery query = ICFactory.queryFor(Resource.class);
		query.addCondition(String.format("$resource/ID/text() eq '%s'",id));
		query.setResult("<Ret>{$resource/Type}{$resource}</Ret>");
		DiscoveryClient<? extends Resource> client = ICFactory.clientWith(new ResourceParser());
		List<? extends Resource> resources = client.submit(query);
		//TODO check return size
		return resources.get(0);
		
		public static class ResourceParser implements ResultParser<Resource>{

		private enum ResourceType {
			GenericResource(GenericResource.class),
			RuntimeResource(ServiceEndpoint.class),
			RunningInstance(GCoreEndpoint.class),
			Service(Software.class),
			GHN(HostingNode.class);

			private Class<? extends Resource> managerClass;

			ResourceType(Class<? extends Resource> managerClass) {
				this.managerClass = managerClass;
			}

			public Class<? extends Resource> getManagerClass(){
				return this.managerClass;
			}
		}

		@Override
		public Resource parse(String res) throws Exception {
			String type = res.replaceAll("<Ret>\\s*<Type>([^<]*).*", "$1");
			String resource = res.replaceAll(".*(<Resource.*>.*</Resource>).*", "$1");
			Class<? extends Resource> classForUnmrshalling= ResourceType.valueOf(type).getManagerClass();
			return Resources.unmarshal(classForUnmrshalling, new StringReader(resource));
		}


	}
		
		
		*/
	}

	private ResourceHandler retrieveHandler(Type type) {
		Iterator<ResourceHandler> it = resourcesHandlers.iterator();
		while (it.hasNext()) {
			ResourceHandler rh = it.next();
			if (rh.getManagedResources().contains(type))
				return rh;
		}

		//TODO return handler not found 
		return null;

	}

	private ScopedResource getScopedResource(Resource res) {
		return new ScopedResource(res.id(), res.type().name(), Long.toString(System.currentTimeMillis()));
	}

	
}
