/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.usermanagement.impl.ws;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.ws.utils.HttpUtils;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeTeam;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayWSRoleManager
implements RoleManager {
    private HttpClientContext localContext;
    private CredentialsProvider credsProvider;
    private HttpHost target;
    private Long companyId;
    private static final String API_BASE_URL = "/api/jsonws";
    private static final String GET_COMPANY_ID = "/company/get-company-by-web-id/web-id/liferay.com";
    private static final String GET_USER_ROLES_IN_GROUP = "/role/get-user-group-roles/user-id/$USER_ID/group-id/$GROUP_ID";
    private static final String GET_ROLE_BY_NAME = "/role/get-role/company-id/$COMPANY_ID/name/$NAME";
    private static final Logger logger = LoggerFactory.getLogger(LiferayWSRoleManager.class);

    public LiferayWSRoleManager(String user, String password, String host, String schema, int port) throws Exception {
        this.target = new HttpHost(host, port, schema);
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(new AuthScope(this.target.getHostName(), this.target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.target, (AuthScheme)basicAuth);
        this.localContext = HttpClientContext.create();
        this.localContext.setAuthCache((AuthCache)authCache);
        this.retrieveCompanyId();
    }

    private void retrieveCompanyId() throws Exception {
        String json = HttpUtils.executeHTTPGETRequest("/api/jsonws/company/get-company-by-web-id/web-id/liferay.com", this.credsProvider, this.localContext, this.target);
        if (json == null) {
            throw new Exception("Failed to retrieve the company-id. The following calls will fail!");
        }
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(json);
        this.companyId = (Long)jsonObject.get("companyId");
        logger.info("Company id retrieved is " + this.companyId);
    }

    protected static GCubeRole mapLRRole(String jsonRole) throws PortalException, SystemException, ParseException {
        logger.debug("Json object for role is " + jsonRole);
        if (jsonRole != null && !jsonRole.isEmpty()) {
            JSONParser parser = new JSONParser();
            JSONObject jsonRoleObject = (JSONObject)parser.parse(jsonRole);
            return new GCubeRole((Long)jsonRoleObject.get("roleId"), (String)jsonRoleObject.get("name"), (String)jsonRoleObject.get("description"));
        }
        return null;
    }

    @Override
    public boolean isAdmin(long userId) throws UserRetrievalFault {
        return false;
    }

    @Override
    public boolean hasRole(long userId, long groupId, long roleId) {
        return false;
    }

    @Override
    public boolean hasTeam(long userId, long teamId) {
        return false;
    }

    @Override
    public boolean assignRoleToUser(long userId, long groupId, long roleId) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, RoleRetrievalFault {
        return false;
    }

    @Override
    public boolean assignRolesToUser(long userId, long groupId, long[] roleId) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, RoleRetrievalFault {
        return false;
    }

    @Override
    public boolean createRole(String roleName, String roleDescription) throws UserManagementSystemException {
        return false;
    }

    @Override
    public boolean deleteRole(long roleId) throws UserManagementSystemException, RoleRetrievalFault {
        return false;
    }

    @Override
    public boolean removeRoleFromUser(long userId, long groupId, long roleId) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, RoleRetrievalFault {
        return false;
    }

    @Override
    public boolean removeAllRolesFromUser(long userId, long ... groupIds) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault {
        return false;
    }

    @Override
    public GCubeRole updateRole(long roleId, String roleName, String roleDescription) throws RoleRetrievalFault {
        return null;
    }

    @Override
    public GCubeRole getRole(long roleId) throws UserManagementSystemException, RoleRetrievalFault {
        return null;
    }

    @Override
    public GCubeRole getRole(String roleName, long groupId) throws RoleRetrievalFault, GroupRetrievalFault {
        return null;
    }

    @Override
    public long getRoleId(String roleName, long groupId) throws RoleRetrievalFault, GroupRetrievalFault {
        return 0L;
    }

    @Override
    public long getRoleIdByName(String roleName) throws RoleRetrievalFault {
        String jsonRole = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_ROLE_BY_NAME.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$NAME", roleName), this.credsProvider, this.localContext, this.target);
        logger.debug("Json returned is " + jsonRole);
        if (jsonRole != null) {
            try {
                return LiferayWSRoleManager.mapLRRole(jsonRole).getRoleId();
            }
            catch (Exception e) {
                logger.error("Exception while retrieving a role by name", (Throwable)e);
            }
        }
        return -1L;
    }

    @Override
    public List<GCubeRole> listAllRoles() {
        return null;
    }

    @Override
    public List<GCubeRole> listAllGroupRoles() {
        return null;
    }

    @Override
    public List<GCubeRole> listRolesByUserAndGroup(long userId, long groupId) throws GroupRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeRole> toReturn = new ArrayList<GCubeRole>();
        String jsonRoles = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_USER_ROLES_IN_GROUP.replace("$GROUP_ID", String.valueOf(groupId)).replace("$USER_ID", String.valueOf(userId)), this.credsProvider, this.localContext, this.target);
        if (jsonRoles != null) {
            try {
                JSONParser parser = new JSONParser();
                JSONArray array = (JSONArray)parser.parse(jsonRoles);
                for (int i = 0; i < array.size(); ++i) {
                    toReturn.add(LiferayWSRoleManager.mapLRRole(array.get(i).toString()));
                }
            }
            catch (Exception e) {
                logger.error("Exception while retrieving list of roles in group", (Throwable)e);
            }
        }
        return toReturn;
    }

    @Override
    public GCubeTeam createTeam(long creatorUserId, long groupId, String teamName, String teamDescription) throws GroupRetrievalFault, TeamRetrievalFault, UserManagementSystemException {
        return null;
    }

    @Override
    public GCubeTeam createTeam(long groupId, String teamName, String teamDescription) throws GroupRetrievalFault, TeamRetrievalFault, UserManagementSystemException {
        return null;
    }

    @Override
    public GCubeTeam getTeam(long groupId, String teamName) throws GroupRetrievalFault, TeamRetrievalFault {
        return null;
    }

    @Override
    public GCubeTeam getTeam(long teamId) throws UserManagementSystemException, TeamRetrievalFault {
        return null;
    }

    @Override
    public GCubeTeam deleteTeam(long teamId) throws UserManagementSystemException, TeamRetrievalFault {
        return null;
    }

    @Override
    public boolean deleteTeams(long groupId) throws UserManagementSystemException {
        return false;
    }

    @Override
    public boolean deleteUserTeams(long userId, long[] teamIds) {
        return false;
    }

    @Override
    public boolean deleteUserTeams(long userId, List<GCubeTeam> teams) {
        return false;
    }

    @Override
    public GCubeTeam updateTeam(long teamId, String teamName, String teamDescription) throws TeamRetrievalFault {
        return null;
    }

    @Override
    public boolean setUserTeams(long userId, long[] teamIds) throws TeamRetrievalFault {
        return false;
    }

    @Override
    public boolean assignTeamToUser(long userId, long teamId) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, TeamRetrievalFault {
        return false;
    }

    @Override
    public List<GCubeTeam> listTeamsByGroup(long groupId) throws GroupRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeTeam> listTeamsByUserAndGroup(long userId, long groupId) throws UserRetrievalFault, GroupRetrievalFault {
        return null;
    }
}

