/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.usermanagement.impl.ws;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementNameException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.VirtualGroupNotExistingException;
import org.gcube.vomanagement.usermanagement.impl.ws.utils.HttpUtils;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GroupMembershipType;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiferayWSGroupManager
implements GroupManager {
    private HttpClientContext localContext;
    private CredentialsProvider credsProvider;
    private HttpHost target;
    private Long companyId;
    private static final String API_BASE_URL = "/api/jsonws";
    private static final String GET_COMPANY_ID = "/company/get-company-by-web-id/web-id/liferay.com";
    private static final String GET_GROUP_BY_NAME = "/group/get-group/company-id/$COMPANY_ID/name/$GROUP_NAME";
    private static final String GET_GROUP_BY_ID = "/group/get-group/group-id/$GROUP_ID";
    private static final String GET_GROUPS_BY_PARENT_ID = "/group/get-groups/company-id/$COMPANY_ID/parent-group-id/$GROUP_PARENT_ID/site/$SITE";
    private static final String GET_GROUPS_BY_USERID = "/group/get-user-sites-groups/user-id/$USER_ID/class-names/%5B%22com.liferay.portal.model.Group%22%5D/max/$MAX_GROUP";
    private static final String GET_GROUP_CUSTOM_FIELDS = "/expandovalue/get-data/company-id/$COMPANY_ID/class-name/com.liferay.portal.model.Group/table-name/CUSTOM_FIELDS/column-name/$CUSTOM_KEY/class-pk/$GROUP_ID";
    private static final Logger logger = LoggerFactory.getLogger(LiferayWSGroupManager.class);

    public LiferayWSGroupManager(String user, String password, String host, String schema, int port) throws Exception {
        this.target = new HttpHost(host, port, schema);
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(new AuthScope(this.target.getHostName(), this.target.getPort()), (Credentials)new UsernamePasswordCredentials(user, password));
        BasicAuthCache authCache = new BasicAuthCache();
        BasicScheme basicAuth = new BasicScheme();
        authCache.put(this.target, (AuthScheme)basicAuth);
        this.localContext = HttpClientContext.create();
        this.localContext.setAuthCache((AuthCache)authCache);
        this.retrieveCompanyId();
    }

    private void retrieveCompanyId() throws Exception {
        String json = HttpUtils.executeHTTPGETRequest("/api/jsonws/company/get-company-by-web-id/web-id/liferay.com", this.credsProvider, this.localContext, this.target);
        if (json == null) {
            throw new Exception("Failed to retrieve the company-id. The following calls will fail!");
        }
        JSONParser parser = new JSONParser();
        JSONObject jsonObject = (JSONObject)parser.parse(json);
        this.companyId = (Long)jsonObject.get("companyId");
        logger.info("Company id retrieved is " + this.companyId);
    }

    private GCubeGroup mapLRGroup(String jsonGroup) throws PortalException, SystemException, UserManagementSystemException, GroupRetrievalFault {
        try {
            if (jsonGroup != null) {
                JSONParser parser = new JSONParser();
                JSONObject jsonGroupObject = (JSONObject)parser.parse(jsonGroup);
                long logoId = 0L;
                long groupId = (Long)jsonGroupObject.get("groupId");
                String threePath = (String)jsonGroupObject.get("treePath");
                if (this.isVREByTreePath(threePath)) {
                    logger.debug("********** IS VRE");
                    return new GCubeGroup(groupId, (Long)jsonGroupObject.get("parentGroupId"), (String)jsonGroupObject.get("name"), (String)jsonGroupObject.get("description"), (String)jsonGroupObject.get("friendlyURL"), logoId, null, this.getMappedGroupMembershipType(((Long)jsonGroupObject.get("type")).intValue()));
                }
                if (this.isVOByTreePath(threePath)) {
                    logger.debug("********** IS VO");
                    ArrayList<GCubeGroup> vres = new ArrayList<GCubeGroup>();
                    List<String> vreInJson = this.getChildren(groupId);
                    if (vreInJson != null) {
                        for (String vreJson : vreInJson) {
                            vres.add(this.mapLRGroup(vreJson));
                        }
                    }
                    return new GCubeGroup(groupId, (Long)jsonGroupObject.get("parentGroupId"), (String)jsonGroupObject.get("name"), (String)jsonGroupObject.get("description"), (String)jsonGroupObject.get("friendlyURL"), logoId, vres, this.getMappedGroupMembershipType(((Long)jsonGroupObject.get("type")).intValue()));
                }
                if (this.isRootVOByTreePath(threePath)) {
                    logger.debug("********** IS ROOT VO");
                    ArrayList<GCubeGroup> vos = new ArrayList<GCubeGroup>();
                    List<String> vosInJson = this.getChildren(groupId);
                    if (vosInJson != null) {
                        for (String voInJson : vosInJson) {
                            vos.add(this.mapLRGroup(voInJson));
                        }
                    }
                    return new GCubeGroup(groupId, (Long)jsonGroupObject.get("parentGroupId"), (String)jsonGroupObject.get("name"), (String)jsonGroupObject.get("description"), (String)jsonGroupObject.get("friendlyURL"), logoId, vos, this.getMappedGroupMembershipType(((Long)jsonGroupObject.get("type")).intValue()));
                }
                logger.warn("This groupId does not correspond to a (root-)VO ora VRE");
                return null;
            }
        }
        catch (Exception e) {
            logger.error("There was an error while trying to map the group with json " + jsonGroup + " to the GcubeGroup class", (Throwable)e);
        }
        return null;
    }

    private boolean isVREByTreePath(String threePath) throws Exception {
        if (threePath == null || threePath.isEmpty()) {
            throw new Exception("threePath is missing");
        }
        return threePath.split("/").length == 4;
    }

    private boolean isVOByTreePath(String threePath) throws Exception {
        if (threePath == null || threePath.isEmpty()) {
            throw new Exception("threePath is missing");
        }
        return threePath.split("/").length == 3;
    }

    private boolean isRootVOByTreePath(String threePath) throws Exception {
        if (threePath == null || threePath.isEmpty()) {
            throw new Exception("threePath is missing");
        }
        return threePath.split("/").length == 2;
    }

    private String getTreePathFromGroup(long groupId) {
        try {
            String jsonGroup = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUP_BY_ID.replace("$GROUP_ID", String.valueOf(groupId)), this.credsProvider, this.localContext, this.target);
            if (jsonGroup != null) {
                JSONParser parser = new JSONParser();
                JSONObject jsonGroupObject = (JSONObject)parser.parse(jsonGroup);
                return (String)jsonGroupObject.get("treePath");
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Failed to retrieve threePath information", (Throwable)e);
            return null;
        }
    }

    private List<String> getChildren(long groupId) {
        ArrayList<String> jsonChildren = new ArrayList<String>();
        try {
            String jsonGroups = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUPS_BY_PARENT_ID.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$GROUP_PARENT_ID", String.valueOf(groupId)).replace("$SITE", Boolean.toString(true)), this.credsProvider, this.localContext, this.target);
            if (jsonGroups != null) {
                logger.debug("***** CHILDREN GROUP SET IS " + jsonGroups);
                JSONParser parser = new JSONParser();
                JSONArray array = (JSONArray)parser.parse(jsonGroups);
                for (int i = 0; i < array.size(); ++i) {
                    jsonChildren.add(((JSONObject)array.get(i)).toJSONString());
                }
                return jsonChildren;
            }
        }
        catch (Exception e) {
            logger.error("Error while returning the children of the group with id " + groupId, (Throwable)e);
        }
        return null;
    }

    private GroupMembershipType getMappedGroupMembershipType(int type) {
        switch (type) {
            case 2: {
                return GroupMembershipType.RESTRICTED;
            }
            case 1: {
                return GroupMembershipType.OPEN;
            }
        }
        return GroupMembershipType.PRIVATE;
    }

    @Override
    public GCubeGroup createRootVO(String rootVOName, String description) throws UserManagementNameException, UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, UserManagementPortalException {
        return null;
    }

    @Override
    public GCubeGroup createVO(String virtualOrgName, long rootVOGroupId, String description) throws UserManagementNameException, UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, UserManagementPortalException {
        return null;
    }

    @Override
    public GCubeGroup createVRE(String virtualResearchEnvName, long virtualOrgGroupId, String description) throws UserManagementNameException, UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, UserManagementPortalException {
        return null;
    }

    @Override
    public long getGroupParentId(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            String jsonGroup = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUP_BY_ID.replace("$GROUP_ID", String.valueOf(groupId)), this.credsProvider, this.localContext, this.target);
            JSONParser parser = new JSONParser();
            JSONObject obj = (JSONObject)parser.parse(jsonGroup);
            return (Long)obj.get("parentGroupId");
        }
        catch (Exception e) {
            logger.error("Unable to determine the parent group id of the group with id " + groupId);
            return -1L;
        }
    }

    @Override
    public long getGroupId(String groupName) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            String jsonGroup = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUP_BY_NAME.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$GROUP_NAME", groupName), this.credsProvider, this.localContext, this.target);
            if (jsonGroup != null) {
                logger.debug("Trying to parse json group object");
                JSONParser parser = new JSONParser();
                JSONObject obj = (JSONObject)parser.parse(jsonGroup);
                return (Long)obj.get("groupId");
            }
            return -1L;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the group id, returning -1", (Throwable)e);
            return -1L;
        }
    }

    @Override
    public GCubeGroup getGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            String jsonGroup = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUP_BY_ID.replace("$GROUP_ID", String.valueOf(groupId)), this.credsProvider, this.localContext, this.target);
            if (jsonGroup != null) {
                return this.mapLRGroup(jsonGroup);
            }
            return null;
        }
        catch (Exception e) {
            logger.error("Error while retrieving the group id, returning null", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<VirtualGroup> getVirtualGroups() throws VirtualGroupNotExistingException {
        return null;
    }

    @Override
    public List<VirtualGroup> getVirtualGroups(long actualGroupId) throws GroupRetrievalFault, VirtualGroupNotExistingException {
        ArrayList<VirtualGroup> toReturn = new ArrayList<VirtualGroup>();
        try {
            String jsonCustomFields = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUP_CUSTOM_FIELDS.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$CUSTOM_KEY", CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()).replace("$GROUP_ID", String.valueOf(actualGroupId)), this.credsProvider, this.localContext, this.target);
            if (jsonCustomFields != null) {
                JSONParser parser = new JSONParser();
                JSONArray array = (JSONArray)parser.parse(jsonCustomFields);
                for (int i = 0; i < array.size(); ++i) {
                    String obj = (String)array.get(i);
                    String[] splits = obj.split("\\|");
                    String gName = splits[0];
                    String gDescription = splits[1];
                    toReturn.add(new VirtualGroup(gName, gDescription));
                }
            }
            return toReturn;
        }
        catch (Exception e) {
            logger.error("Failed to read Virtualgroups for this group", (Throwable)e);
            return null;
        }
    }

    @Override
    public long getGroupIdFromInfrastructureScope(String scope) throws IllegalArgumentException, UserManagementSystemException, GroupRetrievalFault {
        logger.debug("called getGroupIdFromInfrastructureScope on " + scope);
        if (!scope.startsWith("/")) {
            throw new IllegalArgumentException("Scope should start with '/' ->" + scope);
        }
        if (scope.endsWith("/")) {
            throw new IllegalArgumentException("Scope should not end with '/' ->" + scope);
        }
        String[] splits = scope.split("/");
        if (splits.length > 4) {
            throw new IllegalArgumentException("Scope is invalid, too many '/' ->" + scope);
        }
        if (splits.length == 2) {
            return this.getGroupId(splits[1]);
        }
        if (splits.length == 3) {
            try {
                long parentGroupId = this.getGroupId(splits[1]);
                List<String> vosInJson = null;
                vosInJson = this.getChildren(parentGroupId);
                return this.checkChildrenAndReturnId(vosInJson, splits[2]);
            }
            catch (Exception e) {
                logger.error("Failed to retrieve the group id for this context", (Throwable)e);
            }
        } else if (splits.length == 4) {
            try {
                logger.debug("is a VRE scope " + scope);
                long parentGroupId = this.getGroupId(splits[2]);
                List<String> vresInJson = null;
                vresInJson = this.getChildren(parentGroupId);
                return this.checkChildrenAndReturnId(vresInJson, splits[3]);
            }
            catch (Exception e) {
                logger.error("Failed to retrieve the group id for this context", (Throwable)e);
            }
        }
        return -1L;
    }

    private long checkChildrenAndReturnId(List<String> groups, String nameToFind) throws ParseException {
        JSONParser parser = new JSONParser();
        for (String group : groups) {
            JSONObject obj = (JSONObject)parser.parse(group);
            if (!obj.get("name").equals(nameToFind)) continue;
            return (Long)obj.get("groupId");
        }
        return -1L;
    }

    @Override
    public GCubeGroup getRootVO() throws UserManagementSystemException, GroupRetrievalFault {
        return null;
    }

    @Override
    public String getRootVOName() throws UserManagementSystemException, GroupRetrievalFault {
        return null;
    }

    @Override
    public String getInfrastructureScope(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            GCubeGroup group = this.getGroup(groupId);
            String treePath = this.getTreePathFromGroup(group.getGroupId());
            if (this.isVREByTreePath(treePath)) {
                long voId = group.getParentGroupId();
                GCubeGroup voGroup = this.getGroup(voId);
                long rootVoId = voGroup.getParentGroupId();
                String rootGroupName = this.getGroup(rootVoId).getGroupName();
                return "/" + rootGroupName + "/" + voGroup.getGroupName() + "/" + group.getGroupName();
            }
            if (this.isVOByTreePath(treePath)) {
                String rootVoName = this.getGroup(group.getParentGroupId()).getGroupName();
                return "/" + rootVoName + "/" + group.getGroupName();
            }
            if (this.isRootVOByTreePath(treePath)) {
                return "/" + group.getGroupName();
            }
        }
        catch (Exception e) {
            logger.error("Unable to retrieve the Infrastructure scope for group id " + groupId);
        }
        return null;
    }

    @Override
    public String getScope(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeGroup> listGroups() throws UserManagementSystemException, GroupRetrievalFault {
        return null;
    }

    @Override
    public List<GCubeGroup> listGroupsByUser(long userId) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault {
        ArrayList<GCubeGroup> toReturn;
        block4: {
            toReturn = new ArrayList<GCubeGroup>();
            try {
                String jsonGroups = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUPS_BY_USERID.replace("$USER_ID", String.valueOf(userId)).replace("$MAX_GROUP", String.valueOf(1000)), this.credsProvider, this.localContext, this.target);
                if (jsonGroups != null) {
                    logger.debug("Trying to parse json object");
                    JSONParser parser = new JSONParser();
                    JSONArray array = (JSONArray)parser.parse(jsonGroups);
                    for (int i = 0; i < array.size(); ++i) {
                        toReturn.add(this.mapLRGroup(((JSONObject)array.get(i)).toJSONString()));
                    }
                    break block4;
                }
                return null;
            }
            catch (Exception e) {
                logger.error("Error while retrieving the group id, returning -1", (Throwable)e);
            }
        }
        return toReturn;
    }

    @Override
    public List<GCubeGroup> listVresByUser(long userId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeGroup> toReturn = new ArrayList<GCubeGroup>();
        try {
            String jsonGroups = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUPS_BY_USERID.replace("$USER_ID", String.valueOf(userId)).replace("$MAX_GROUP", String.valueOf(1000)), this.credsProvider, this.localContext, this.target);
            if (jsonGroups != null) {
                logger.debug("Trying to parse json object");
                JSONParser parser = new JSONParser();
                JSONArray array = (JSONArray)parser.parse(jsonGroups);
                for (int i = 0; i < array.size(); ++i) {
                    String threePath = (String)((JSONObject)array.get(i)).get("treePath");
                    if (!this.isVREByTreePath(threePath)) continue;
                    toReturn.add(this.mapLRGroup(((JSONObject)array.get(i)).toJSONString()));
                }
                return toReturn;
            }
        }
        catch (Exception e) {
            logger.error("Error while retrieving the group id, returning -1", (Throwable)e);
        }
        return null;
    }

    @Override
    public Set<GCubeGroup> listGroupsByUserAndSite(long userId, String serverName) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault, VirtualGroupNotExistingException {
        return null;
    }

    @Override
    public Set<GCubeGroup> listGroupsByUserAndSiteGroupId(long userId, long siteGroupId) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault, VirtualGroupNotExistingException {
        return null;
    }

    @Override
    public Map<GCubeGroup, List<GCubeRole>> listGroupsAndRolesByUser(long userId) throws UserManagementSystemException {
        return null;
    }

    @Override
    public Boolean isRootVO(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            long groupParentId = this.getGroupParentId(groupId);
            return groupParentId == 0L;
        }
        catch (Exception e) {
            logger.error("Error while checking if group with id " + groupId + " is the root VO");
            return false;
        }
    }

    @Override
    public Boolean isVO(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            long groupParentId = this.getGroupParentId(groupId);
            if (groupParentId != 0L) {
                return this.isVRE(groupId) == false;
            }
        }
        catch (Exception e) {
            logger.error("Error while checking if group with id " + groupId + " is a VO");
        }
        return false;
    }

    @Override
    public Boolean isVRE(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            long groupParentId = this.getGroupParentId(groupId);
            if (groupParentId != 0L) {
                return this.getGroupParentId(groupParentId) != 0L;
            }
        }
        catch (Exception e) {
            logger.error("Error while checking if group with id " + groupId + " is a VRE");
        }
        return false;
    }

    @Override
    public Serializable readCustomAttr(long groupId, String attributeKey) throws GroupRetrievalFault {
        String result = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUP_CUSTOM_FIELDS.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$GROUP_ID", String.valueOf(groupId)).replace("$CUSTOM_KEY", attributeKey), this.credsProvider, this.localContext, this.target);
        logger.debug("Data is " + result);
        return result;
    }

    @Override
    public void saveCustomAttr(long groupId, String attributeKey, Serializable value) throws GroupRetrievalFault {
    }

    @Override
    public String updateGroupDescription(long groupId, String description) throws GroupRetrievalFault {
        return null;
    }

    @Override
    public String getGroupLogoURL(long logoId) {
        return null;
    }

    @Override
    public List<GCubeGroup> getGateways() {
        ArrayList<GCubeGroup> gateways = new ArrayList<GCubeGroup>();
        try {
            int i;
            String jsonGroups = HttpUtils.executeHTTPGETRequest(API_BASE_URL + GET_GROUPS_BY_PARENT_ID.replace("$COMPANY_ID", String.valueOf(this.companyId)).replace("$GROUP_PARENT_ID", String.valueOf(0)).replace("$SITE", Boolean.toString(true)), this.credsProvider, this.localContext, this.target);
            JSONArray candidateGateways = (JSONArray)new JSONParser().parse(jsonGroups);
            ArrayList<Long> idsCandidateGateways = new ArrayList<Long>();
            for (i = 0; i < candidateGateways.size(); ++i) {
                idsCandidateGateways.add((Long)((JSONObject)candidateGateways.get(i)).get("groupId"));
            }
            for (i = 0; i < idsCandidateGateways.size(); ++i) {
                List<String> children;
                boolean defaultGroup;
                String friendlyUrl = (String)((JSONObject)candidateGateways.get(i)).get("friendlyURL");
                boolean bl = defaultGroup = friendlyUrl.equals("/guest") || friendlyUrl.equals("/global");
                if (defaultGroup || (children = this.getChildren((Long)idsCandidateGateways.get(i))) != null && !children.isEmpty()) continue;
                gateways.add(this.mapLRGroup(((JSONObject)candidateGateways.get(i)).toJSONString()));
            }
        }
        catch (Exception e) {
            logger.error("Failed to retrieve the list of gateways", (Throwable)e);
            return null;
        }
        return gateways;
    }
}

