/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.usermanagement.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleServiceUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.webserver.WebServerServletTokenUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gcube.vomanagement.usermanagement.GroupManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementNameException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementPortalException;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.VirtualGroupNotExistingException;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GroupMembershipType;
import org.gcube.vomanagement.usermanagement.model.VirtualGroup;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;

public class LiferayGroupManager
implements GroupManager {
    private static final String DEFAULT_INFRA_NAME = "gcube";
    public static final String INFRASTRUCTURE_NAME = "infrastructure";
    private static final Log _log = LogFactoryUtil.getLog(LiferayGroupManager.class);

    private GCubeGroup mapLRGroup(Group g) throws PortalException, SystemException, UserManagementSystemException, GroupRetrievalFault {
        if (g != null) {
            long logoId = LayoutSetLocalServiceUtil.getLayoutSet((long)g.getGroupId(), (boolean)true).getLogoId();
            if (this.isVRE(g.getGroupId()).booleanValue()) {
                return new GCubeGroup(g.getGroupId(), g.getParentGroupId(), g.getName(), g.getDescription(), g.getFriendlyURL(), logoId, UserLocalServiceUtil.getGroupUsersCount((long)g.getGroupId()), null, this.getMappedGroupMembershipType(g.getType()));
            }
            if (this.isVO(g.getGroupId()).booleanValue()) {
                ArrayList<GCubeGroup> vres = new ArrayList<GCubeGroup>();
                List VREs = g.getChildren(true);
                for (Group vre : VREs) {
                    vres.add(this.mapLRGroup(vre));
                }
                return new GCubeGroup(g.getGroupId(), g.getParentGroupId(), g.getName(), g.getDescription(), g.getFriendlyURL(), logoId, UserLocalServiceUtil.getGroupUsersCount((long)g.getGroupId()), vres, this.getMappedGroupMembershipType(g.getType()));
            }
            if (this.isRootVO(g.getGroupId()).booleanValue()) {
                ArrayList<GCubeGroup> vos = new ArrayList<GCubeGroup>();
                List children = g.getChildren(true);
                for (Group vo : children) {
                    vos.add(this.mapLRGroup(vo));
                }
                return new GCubeGroup(g.getGroupId(), -1L, g.getName(), g.getDescription(), g.getFriendlyURL(), logoId, UserLocalServiceUtil.getGroupUsersCount((long)g.getGroupId()), vos, this.getMappedGroupMembershipType(g.getType()));
            }
            _log.warn((Object)"This groupId does not correspond to a VO ora VRE");
            return null;
        }
        return null;
    }

    private GroupMembershipType getMappedGroupMembershipType(int type) {
        switch (type) {
            case 2: {
                return GroupMembershipType.RESTRICTED;
            }
            case 1: {
                return GroupMembershipType.OPEN;
            }
        }
        return GroupMembershipType.PRIVATE;
    }

    private Group createGroup(String groupName, String description, long parentGroupId) {
        Group group = null;
        if (parentGroupId < 0L) {
            parentGroupId = 0L;
        }
        try {
            long companyId = PortalUtil.getDefaultCompanyId();
            long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)companyId);
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(Locale.getDefault(), groupName);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(Locale.getDefault(), description);
            group = GroupLocalServiceUtil.addGroup((long)defaultUserId, (long)parentGroupId, (String)Group.class.getName(), (long)0L, (long)0L, nameMap, descriptionMap, (int)2, (boolean)true, (int)0, (String)("/" + groupName), (boolean)true, (boolean)true, (ServiceContext)new ServiceContext());
            _log.info((Object)("Created Group with name " + groupName));
            return group;
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return group;
    }

    @Override
    public List<VirtualGroup> getVirtualGroups(long actualGroupId) throws GroupRetrievalFault, VirtualGroupNotExistingException {
        ArrayList<VirtualGroup> toReturn = new ArrayList<VirtualGroup>();
        try {
            long userId = LiferayUserManager.getAdmin().getUserId();
            PrincipalThreadLocal.setName((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            Group site = GroupLocalServiceUtil.getGroup((long)actualGroupId);
            if (site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()) == null || site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()).equals("")) {
                String warningMessage = String.format("Attribute %s not initialized.", CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
                _log.warn((Object)warningMessage);
                throw new VirtualGroupNotExistingException(warningMessage);
            }
            String[] values = (String[])site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
            VirtualGroup toAdd = new VirtualGroup();
            if (values != null && values.length > 0) {
                for (int i = 0; i < values.length; ++i) {
                    toAdd = new VirtualGroup();
                    String[] splits = values[i].split("\\|");
                    toAdd.setName(splits[0]);
                    toAdd.setDescription(splits[1]);
                    toReturn.add(toAdd);
                }
            } else {
                toAdd.setName("NoVirtualGroupAssigned");
                toAdd.setDescription("NoVirtualGroupDescription");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<VirtualGroup> getVirtualGroups() throws VirtualGroupNotExistingException {
        ExpandoBridge expandoBridge = null;
        ArrayList<VirtualGroup> toReturn = new ArrayList<VirtualGroup>();
        try {
            expandoBridge = ExpandoBridgeFactoryUtil.getExpandoBridge((long)ManagementUtils.getCompany().getCompanyId(), (String)Group.class.getName());
            String[] groups = (String[])expandoBridge.getAttributeDefault(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
            List<String> virtualGroups = Arrays.asList(groups);
            for (String vg : virtualGroups) {
                String[] splits = vg.split("\\|");
                String gName = splits[0];
                String gDescription = splits[1];
                toReturn.add(new VirtualGroup(gName, gDescription));
            }
        }
        catch (PortalException e) {
            throw new VirtualGroupNotExistingException("", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public GCubeGroup createRootVO(String rootVOName, String description) throws UserManagementNameException, UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, UserManagementPortalException {
        Group group = null;
        try {
            group = this.createGroup(rootVOName, description, -1L);
            _log.info((Object)("Created RootVO with name " + rootVOName));
            return this.mapLRGroup(group);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public GCubeGroup createVO(String virtualOrgName, long rootVOGroupId, String description) throws UserManagementNameException, UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, UserManagementPortalException {
        Group group = null;
        try {
            group = this.createGroup(virtualOrgName, description, rootVOGroupId);
            _log.info((Object)("Created VO with name " + virtualOrgName));
            return this.mapLRGroup(group);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public GCubeGroup createVRE(String virtualResearchEnvName, long virtualOrgGroupId, String description) throws UserManagementNameException, UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, UserManagementPortalException {
        Group group = null;
        try {
            group = this.createGroup(virtualResearchEnvName, description, virtualOrgGroupId);
            _log.info((Object)("Created VO with name " + virtualResearchEnvName));
            return this.mapLRGroup(group);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public long getGroupParentId(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            GroupLocalServiceUtil.getGroup((long)groupId).getParentGroupId();
        }
        catch (PortalException e) {
            throw new GroupRetrievalFault("Group id not existing ", groupId);
        }
        catch (SystemException e) {
            throw new GroupRetrievalFault("SystemException or group id not existing ", groupId);
        }
        return -1L;
    }

    @Override
    public long getGroupId(String groupName) throws UserManagementSystemException, GroupRetrievalFault {
        _log.debug((Object)("looking for groupId of " + groupName));
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)ManagementUtils.getCompany().getCompanyId(), (String)groupName);
            return g.getGroupId();
        }
        catch (PortalException e) {
            _log.warn((Object)(groupName + " Group not existing -> " + groupName));
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return -1L;
    }

    @Override
    public GCubeGroup getGroup(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        _log.debug((Object)("looking for group having id " + groupId));
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            return this.mapLRGroup(g);
        }
        catch (PortalException e) {
            throw new GroupRetrievalFault("Group not existing", groupId, e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public long getGroupIdFromInfrastructureScope(String scope) throws IllegalArgumentException, UserManagementSystemException, GroupRetrievalFault {
        block13: {
            String[] splits;
            block12: {
                _log.debug((Object)("called getGroupIdFromInfrastructureScope on " + scope));
                if (!scope.startsWith("/")) {
                    throw new IllegalArgumentException("Scope should start with '/' ->" + scope);
                }
                if (scope.endsWith("/")) {
                    throw new IllegalArgumentException("Scope should not end with '/' ->" + scope);
                }
                splits = scope.split("/");
                if (splits.length > 4) {
                    throw new IllegalArgumentException("Scope is invalid, too many '/' ->" + scope);
                }
                if (splits.length == 2) {
                    return this.getGroupId(splits[1]);
                }
                if (splits.length != 3) break block12;
                long parentGroupId = this.getGroupId(splits[1]);
                List vos = null;
                try {
                    vos = GroupLocalServiceUtil.getGroups((long)ManagementUtils.getCompany().getCompanyId(), (long)parentGroupId, (boolean)true);
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
                catch (PortalException e) {
                    e.printStackTrace();
                }
                for (Group group : vos) {
                    if (group.getName().compareTo(splits[2]) != 0) continue;
                    return group.getGroupId();
                }
                break block13;
            }
            if (splits.length != 4) break block13;
            _log.debug((Object)("is a VRE scope " + scope));
            long parentGroupId = this.getGroupId(splits[2]);
            List vres = null;
            try {
                vres = GroupLocalServiceUtil.getGroups((long)ManagementUtils.getCompany().getCompanyId(), (long)parentGroupId, (boolean)true);
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
            catch (PortalException e) {
                e.printStackTrace();
            }
            for (Group group : vres) {
                if (group.getName().compareTo(splits[3]) != 0) continue;
                long groupId = group.getGroupId();
                _log.debug((Object)("groupId found: " + groupId));
                return groupId;
            }
        }
        return -1L;
    }

    @Override
    public GCubeGroup getRootVO() throws UserManagementSystemException, GroupRetrievalFault {
        String infraName = LiferayGroupManager.readInfrastructureNameFromPropertyfile();
        long rootVOGroupId = this.getGroupId(infraName);
        return this.getGroup(rootVOGroupId);
    }

    @Override
    public String getRootVOName() throws UserManagementSystemException, GroupRetrievalFault {
        return this.getRootVO().getGroupName();
    }

    @Override
    public List<GCubeGroup> listGroups() throws UserManagementSystemException, GroupRetrievalFault {
        ArrayList<GCubeGroup> toReturn = new ArrayList<GCubeGroup>();
        GCubeGroup root = this.getRootVO();
        toReturn.add(root);
        try {
            List VOs = GroupLocalServiceUtil.getGroup((long)root.getGroupId()).getChildren(true);
            for (Group vo : VOs) {
                toReturn.add(this.mapLRGroup(vo));
                List VREs = vo.getChildren(true);
                for (Group vre : VREs) {
                    toReturn.add(this.mapLRGroup(vre));
                }
            }
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeGroup> listGroupsByUser(long userId) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault {
        ArrayList<GCubeGroup> toReturn = new ArrayList<GCubeGroup>();
        try {
            for (Group g : GroupLocalServiceUtil.getUserGroups((long)userId)) {
                toReturn.add(this.mapLRGroup(g));
            }
        }
        catch (SystemException e) {
            throw new UserManagementSystemException("Please check that the userId exists", e);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeGroup> listVresByUser(long userId) throws UserManagementSystemException, GroupRetrievalFault, UserRetrievalFault {
        List<GCubeGroup> toReturn = this.listGroupsByUser(userId);
        Iterator<GCubeGroup> iterator = toReturn.iterator();
        while (iterator.hasNext()) {
            GCubeGroup gCubeGroup = iterator.next();
            if (this.isVRE(gCubeGroup.getGroupId()).booleanValue()) continue;
            iterator.remove();
        }
        return toReturn;
    }

    @Override
    public Set<GCubeGroup> listGroupsByUserAndSite(long userId, String serverName) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault, VirtualGroupNotExistingException {
        try {
            return this.listGroupsByUserAndSiteGroupId(userId, ManagementUtils.getSiteGroupIdFromServletRequest(serverName));
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public Set<GCubeGroup> listGroupsByUserAndSiteGroupId(long userId, long siteGroupId) throws UserRetrievalFault, UserManagementSystemException, GroupRetrievalFault, VirtualGroupNotExistingException {
        HashSet<GCubeGroup> toReturn = new HashSet<GCubeGroup>();
        try {
            List<VirtualGroup> currSiteVirtualGroups = this.getVirtualGroups(siteGroupId);
            for (GCubeGroup userGroup : this.listGroupsByUser(userId)) {
                if (!this.isVRE(userGroup.getGroupId()).booleanValue()) continue;
                for (VirtualGroup currSiteVGroup : currSiteVirtualGroups) {
                    List<VirtualGroup> vGroups = this.getVirtualGroups(userGroup.getGroupId());
                    for (VirtualGroup virtualGroup : vGroups) {
                        if (virtualGroup.getName().compareTo(currSiteVGroup.getName()) != 0) continue;
                        toReturn.add(userGroup);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public Map<GCubeGroup, List<GCubeRole>> listGroupsAndRolesByUser(long userId) throws UserManagementSystemException {
        HashMap<GCubeGroup, List<GCubeRole>> toReturn = new HashMap<GCubeGroup, List<GCubeRole>>();
        try {
            List userGroups = GroupLocalServiceUtil.getUserGroups((long)userId);
            for (Group group : userGroups) {
                List userRoles = RoleServiceUtil.getUserGroupRoles((long)userId, (long)group.getGroupId());
                ArrayList<GCubeRole> toAdd = new ArrayList<GCubeRole>();
                for (Role role : userRoles) {
                    toAdd.add(LiferayRoleManager.mapLRRole(role));
                }
                toReturn.put(this.mapLRGroup(group), toAdd);
            }
        }
        catch (SystemException e) {
            throw new UserManagementSystemException("Error in listGroupsAndRolesByUser", e);
        }
        catch (PortalException e) {
            e.printStackTrace();
        }
        catch (GroupRetrievalFault e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public Boolean isRootVO(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            return g.getParentGroup() == null;
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Boolean isVO(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            if (g.getParentGroup() != null) {
                return this.isVRE(groupId) == false;
            }
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public Boolean isVRE(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            if (g.getParentGroup() != null) {
                return g.getParentGroup().getParentGroup() != null;
            }
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public String getInfrastructureScope(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            if (this.isVRE(groupId).booleanValue()) {
                return "/" + g.getParentGroup().getParentGroup().getName() + "/" + g.getParentGroup().getName() + "/" + g.getName();
            }
            if (this.isVO(groupId).booleanValue()) {
                return "/" + g.getParentGroup().getName() + "/" + g.getName();
            }
            if (this.isRootVO(groupId).booleanValue()) {
                return "/" + g.getName();
            }
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public String getScope(long groupId) throws UserManagementSystemException, GroupRetrievalFault {
        return this.getInfrastructureScope(groupId);
    }

    @Override
    public Serializable readCustomAttr(long groupId, String attributeKey) throws GroupRetrievalFault {
        try {
            this.doAsAdmin();
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            if (g.getExpandoBridge().hasAttribute(attributeKey)) {
                _log.trace((Object)("Attribute found: " + attributeKey + " trying read value"));
                return g.getExpandoBridge().getAttribute(attributeKey);
            }
            return null;
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void saveCustomAttr(long groupId, String attributeKey, Serializable value) throws GroupRetrievalFault {
        try {
            this.doAsAdmin();
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            g.getExpandoBridge().setAttribute(attributeKey, value);
            _log.trace((Object)("Custom Attribute set OK: " + attributeKey + " value: " + String.valueOf(value)));
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String updateGroupDescription(long groupId, String description) throws GroupRetrievalFault {
        try {
            Group g = GroupLocalServiceUtil.getGroup((long)groupId);
            HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
            descriptionMap.put(Locale.getDefault(), description);
            HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
            nameMap.put(Locale.getDefault(), g.getName());
            Group modifiedGroup = GroupLocalServiceUtil.updateGroup((long)groupId, (long)g.getParentGroupId(), nameMap, descriptionMap, (int)g.getType(), (boolean)g.getManualMembership(), (int)g.getMembershipRestriction(), (String)g.getFriendlyURL(), (boolean)g.isInheritContent(), (boolean)g.isActive(), (ServiceContext)new ServiceContext());
            return modifiedGroup.getDescription();
        }
        catch (PortalException e1) {
            throw new GroupRetrievalFault("Group not existing (I think you better check)", groupId, e1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void doAsAdmin() {
        try {
            User admin = LiferayUserManager.getAdmin();
            _log.debug((Object)("Admin found: " + admin.getScreenName()));
            long userId = admin.getUserId();
            PrincipalThreadLocal.setName((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    private VirtualGroup getVirtualGroup(long actualGroupId) throws GroupRetrievalFault, VirtualGroupNotExistingException {
        VirtualGroup toReturn = new VirtualGroup();
        try {
            long userId = LiferayUserManager.getAdmin().getUserId();
            PrincipalThreadLocal.setName((long)userId);
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)UserLocalServiceUtil.getUser((long)userId));
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
            Group site = GroupLocalServiceUtil.getGroup((long)actualGroupId);
            _log.debug((Object)("Set Thread Permission done, getVirtual Group of " + site.getName()));
            if (site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()) == null || site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName()).equals("")) {
                String warningMessage = String.format("Attribute %s not initialized.", CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
                _log.warn((Object)warningMessage);
                throw new VirtualGroupNotExistingException(warningMessage);
            }
            String[] values = (String[])site.getExpandoBridge().getAttribute(CustomAttributeKeys.VIRTUAL_GROUP.getKeyName());
            if (values != null && values.length > 0) {
                String[] splits = values[0].split("\\|");
                toReturn.setName(splits[0]);
                toReturn.setDescription(splits[1]);
            } else {
                toReturn.setName("NoVirtualGroupAssigned");
                toReturn.setDescription("NoVirtualGroupDescription");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private static String readInfrastructureNameFromPropertyfile() {
        Properties props = new Properties();
        String toReturn = DEFAULT_INFRA_NAME;
        try {
            String propertyfile = LiferayGroupManager.getCatalinaHome() + File.separator + "conf" + File.separator + "infrastructure.properties";
            File propsFile = new File(propertyfile);
            FileInputStream fis = new FileInputStream(propsFile);
            props.load(fis);
            toReturn = props.getProperty(INFRASTRUCTURE_NAME);
        }
        catch (IOException e) {
            _log.error((Object)("infrastructure.properties file not found under $CATALINA_HOME/conf/ dir, returning default infrastructure Name " + toReturn));
            return toReturn;
        }
        return toReturn;
    }

    private static String getCatalinaHome() {
        return System.getenv("CATALINA_HOME").endsWith("/") ? System.getenv("CATALINA_HOME") : System.getenv("CATALINA_HOME") + "/";
    }

    @Override
    public String getGroupLogoURL(long logoId) {
        String layoutSetLogo = "";
        StringBundler sb = new StringBundler(5);
        String imagePath = PortalUtil.getPathImage();
        sb.append(imagePath);
        sb.append("/layout_set_logo?img_id=");
        sb.append(logoId);
        sb.append("&t=");
        sb.append(WebServerServletTokenUtil.getToken((long)logoId));
        layoutSetLogo = sb.toString();
        return layoutSetLogo;
    }

    @Override
    public List<GCubeGroup> getGateways() {
        ArrayList<GCubeGroup> gateways = new ArrayList<GCubeGroup>();
        try {
            List candidateGateways = GroupLocalServiceUtil.getGroups((long)ManagementUtils.getCompany().getCompanyId(), (long)0L, (boolean)true);
            for (Group group : candidateGateways) {
                List children = group.getChildren(true);
                if (children != null && !children.isEmpty() || group.getFriendlyURL().equals("/guest") || group.getFriendlyURL().equals("/global")) continue;
                gateways.add(this.mapLRGroup(group));
            }
        }
        catch (Exception e) {
            _log.error((Object)"Failed to retrieve the list of gateways", (Throwable)e);
            return null;
        }
        return gateways;
    }
}

