/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.usermanagement.impl;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.portal.kernel.exception.DuplicateTeamException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.RoleLocalServiceUtil;
import com.liferay.portal.kernel.service.TeamLocalServiceUtil;
import com.liferay.portal.kernel.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.gcube.vomanagement.usermanagement.RoleManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.RoleRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.GCubeRole;
import org.gcube.vomanagement.usermanagement.model.GCubeTeam;
import org.gcube.vomanagement.usermanagement.util.ManagementUtils;

public class LiferayRoleManager
implements RoleManager {
    private static final Log _log = LogFactoryUtil.getLog(LiferayRoleManager.class);
    private static final String ADMINISTRATOR = "Administrator";
    protected static final int ROLE_TYPE = 2;

    protected static GCubeRole mapLRRole(Role r) throws PortalException, SystemException {
        if (r != null) {
            return new GCubeRole(r.getRoleId(), r.getName(), r.getDescription());
        }
        return null;
    }

    protected static GCubeTeam mapLRTeam(Team t) throws PortalException, SystemException {
        if (t != null) {
            return new GCubeTeam(t.getGroupId(), t.getTeamId(), t.getName(), t.getDescription(), t.getUserId(), t.getCreateDate(), t.getModifiedDate());
        }
        return null;
    }

    @Override
    public boolean isAdmin(long userId) throws UserRetrievalFault {
        try {
            UserLocalServiceUtil.getUser((long)userId);
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User not existing", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        try {
            long roleId = RoleLocalServiceUtil.getRole((long)ManagementUtils.getCompany().getCompanyId(), (String)ADMINISTRATOR).getRoleId();
            return UserLocalServiceUtil.hasRoleUser((long)roleId, (long)userId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public GCubeRole getRole(String roleName, long groupId) throws RoleRetrievalFault, GroupRetrievalFault {
        try {
            GroupLocalServiceUtil.getGroup((long)groupId);
            List roles = RoleLocalServiceUtil.getGroupRelatedRoles((long)groupId);
            for (Role role : roles) {
                _log.debug((Object)role.toString());
                if (role.getName().compareTo(roleName) != 0) continue;
                return LiferayRoleManager.mapLRRole(role);
            }
        }
        catch (PortalException e) {
            _log.warn((Object)(roleName + " Role not existing"));
        }
        catch (SystemException e) {
            throw new RoleRetrievalFault(e.getMessage(), e);
        }
        return null;
    }

    @Override
    public GCubeRole getRole(long roleId) throws RoleRetrievalFault, RoleRetrievalFault {
        try {
            return LiferayRoleManager.mapLRRole(RoleLocalServiceUtil.getRole((long)roleId));
        }
        catch (PortalException e) {
            _log.warn((Object)(roleId + " Role id not existing"));
        }
        catch (SystemException e) {
            _log.error((Object)"Liferay SystemException");
        }
        return null;
    }

    @Override
    public long getRoleId(String roleName, long groupId) throws RoleRetrievalFault, GroupRetrievalFault {
        return this.getRole(roleName, groupId).getRoleId();
    }

    @Override
    public long getRoleIdByName(String roleName) throws RoleRetrievalFault {
        try {
            Role toReturn = RoleLocalServiceUtil.getRole((long)ManagementUtils.getCompany().getCompanyId(), (String)roleName);
            return toReturn.getRoleId();
        }
        catch (PortalException e) {
            throw new RoleRetrievalFault("Role not existing: " + roleName);
        }
        catch (SystemException e) {
            _log.error((Object)"Liferay SystemException");
            return -1L;
        }
    }

    @Override
    public boolean hasRole(long userId, long groupId, long roleId) {
        try {
            List<GCubeRole> roles = this.listRolesByUserAndGroup(userId, groupId);
            for (GCubeRole gCubeRole : roles) {
                if (gCubeRole.getRoleId() != roleId) continue;
                return true;
            }
        }
        catch (GroupRetrievalFault | UserRetrievalFault e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean hasTeam(long userId, long teamId) {
        try {
            return UserLocalServiceUtil.hasTeamUser((long)teamId, (long)userId);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean assignRoleToUser(long userId, long groupId, long roleId) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, RoleRetrievalFault {
        try {
            _log.debug((Object)("Trying to assign role to " + UserLocalServiceUtil.getUser((long)userId).getFullName() + " in group " + groupId));
            long[] roleIds = new long[]{roleId};
            return UserGroupRoleLocalServiceUtil.addUserGroupRoles((long)userId, (long)groupId, (long[])roleIds).size() > 0;
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User, not existing or roleId could not be found", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean assignRolesToUser(long userId, long groupId, long[] roleIds) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, RoleRetrievalFault {
        try {
            _log.debug((Object)("Trying to assign role to " + UserLocalServiceUtil.getUser((long)userId).getFullName() + " in group " + groupId));
            return UserGroupRoleLocalServiceUtil.addUserGroupRoles((long)userId, (long)groupId, (long[])roleIds).size() > 0;
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User, not existing, or group/roleId could not be found", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean createRole(String roleName, String roleDescription) throws UserManagementSystemException {
        _log.debug((Object)("Check  createRole " + roleName));
        long existingroleId = -1L;
        try {
            existingroleId = this.getRoleIdByName(roleName);
        }
        catch (Exception e) {
            _log.debug((Object)("Site Role having name " + roleName + " does not exist, proceed with creation OK"));
        }
        if (existingroleId == -1L) {
            try {
                _log.debug((Object)("Trying createRole " + roleName));
                Date now = new Date();
                Long defaultCompanyId = PortalUtil.getDefaultCompanyId();
                Long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)defaultCompanyId);
                Long roleClassNameId = ClassNameLocalServiceUtil.getClassNameId(Role.class);
                Long roleId = CounterLocalServiceUtil.increment();
                Role role = RoleLocalServiceUtil.createRole((long)roleId);
                role.setName(roleName);
                role.setDescription(roleDescription);
                role.setType(2);
                role.setUserId(defaultUserId.longValue());
                role.setCompanyId(defaultCompanyId.longValue());
                role.setClassNameId(roleClassNameId.longValue());
                role.setClassPK(roleId.longValue());
                role.setCreateDate(now);
                role.setModifiedDate(now);
                RoleLocalServiceUtil.addRole((Role)role);
                _log.debug((Object)("CreateRole " + roleName + " SUCCESS"));
                return true;
            }
            catch (PortalException | SystemException e) {
                e.printStackTrace();
            }
        } else {
            _log.error((Object)("Site Role having name " + roleName + " exist already, skipping creation"));
        }
        return false;
    }

    @Override
    public boolean deleteRole(long roleId) throws UserManagementSystemException, RoleRetrievalFault {
        try {
            RoleLocalServiceUtil.deleteRole((long)roleId);
            return true;
        }
        catch (PortalException e) {
            throw new RoleRetrievalFault("The roleId does not exists", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public GCubeRole updateRole(long roleId, String roleName, String roleDescription) throws RoleRetrievalFault {
        try {
            Role toEdit = RoleLocalServiceUtil.getRole((long)roleId);
            toEdit.setName(roleName);
            toEdit.setDescription(roleDescription);
            Role toReturn = RoleLocalServiceUtil.updateRole((Role)toEdit);
            return LiferayRoleManager.mapLRRole(toReturn);
        }
        catch (PortalException e) {
            throw new RoleRetrievalFault("The roleId does not exists", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean removeRoleFromUser(long userId, long groupId, long roleId) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault, RoleRetrievalFault {
        try {
            _log.debug((Object)("Trying to remove role to " + UserLocalServiceUtil.getUser((long)userId).getFullName() + " in group " + groupId));
            long[] roleIds = new long[]{roleId};
            UserGroupRoleLocalServiceUtil.deleteUserGroupRoles((long)userId, (long)groupId, (long[])roleIds);
            return true;
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User, not existing, or group/roleId could not be found", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean removeAllRolesFromUser(long userId, long ... groupIds) throws UserManagementSystemException, UserRetrievalFault, GroupRetrievalFault {
        try {
            _log.debug((Object)("Trying to remove all roles to " + UserLocalServiceUtil.getUser((long)userId).getFullName() + " in groups " + String.valueOf(groupIds)));
            UserGroupRoleLocalServiceUtil.deleteUserGroupRoles((long)userId, (long[])groupIds);
            return true;
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User, not existing, or group/roleId could not be found", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public List<GCubeRole> listAllRoles() {
        ArrayList<GCubeRole> toReturn = new ArrayList<GCubeRole>();
        try {
            List roles = RoleLocalServiceUtil.getRoles((long)ManagementUtils.getCompany().getCompanyId());
            for (Role role : roles) {
                toReturn.add(LiferayRoleManager.mapLRRole(role));
            }
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeRole> listAllGroupRoles() {
        ArrayList<GCubeRole> toReturn = new ArrayList<GCubeRole>();
        try {
            List roles = RoleLocalServiceUtil.getRoles((long)ManagementUtils.getCompany().getCompanyId());
            for (Role role : roles) {
                if (role.getType() != 2 || role.getName().startsWith("Site")) continue;
                toReturn.add(LiferayRoleManager.mapLRRole(role));
            }
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeRole> listRolesByUserAndGroup(long userId, long groupId) throws GroupRetrievalFault, UserRetrievalFault {
        ArrayList<GCubeRole> toReturn = new ArrayList<GCubeRole>();
        try {
            List roles = UserGroupRoleLocalServiceUtil.getUserGroupRolesByGroup((long)groupId);
            for (UserGroupRole ugr : roles) {
                if (ugr.getUserId() != userId || ugr.getRole().getName().startsWith("Site")) continue;
                toReturn.add(LiferayRoleManager.mapLRRole(ugr.getRole()));
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        catch (PortalException e) {
            throw new UserRetrievalFault("User, not existing, or groupId could not be found", e);
        }
        return toReturn;
    }

    @Override
    public GCubeTeam createTeam(long userId, long groupId, String teamName, String teamDescription) throws GroupRetrievalFault, TeamRetrievalFault, UserManagementSystemException {
        try {
            return LiferayRoleManager.mapLRTeam(TeamLocalServiceUtil.addTeam((long)userId, (long)groupId, (String)teamName, (String)teamDescription, null));
        }
        catch (DuplicateTeamException ex) {
            throw new TeamRetrievalFault("A Team with this name exists already: name=" + teamName);
        }
        catch (PortalException e) {
            throw new GroupRetrievalFault("The groupId could not be found", groupId, e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public GCubeTeam createTeam(long groupId, String teamName, String teamDescription) throws GroupRetrievalFault, TeamRetrievalFault, UserManagementSystemException {
        long userId = LiferayUserManager.getAdmin().getUserId();
        return this.createTeam(userId, groupId, teamName, teamDescription);
    }

    @Override
    public GCubeTeam deleteTeam(long teamId) throws UserManagementSystemException, TeamRetrievalFault {
        try {
            Team deleted = TeamLocalServiceUtil.deleteTeam((long)teamId);
            return LiferayRoleManager.mapLRTeam(deleted);
        }
        catch (PortalException e) {
            throw new TeamRetrievalFault("The teamId does not exists", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean deleteTeams(long groupId) throws UserManagementSystemException {
        try {
            TeamLocalServiceUtil.deleteTeams((long)groupId);
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public GCubeTeam getTeam(long teamId) throws UserManagementSystemException, TeamRetrievalFault {
        try {
            return LiferayRoleManager.mapLRTeam(TeamLocalServiceUtil.getTeam((long)teamId));
        }
        catch (PortalException e) {
            _log.warn((Object)(teamId + " Team id not existing"));
        }
        catch (SystemException e) {
            _log.error((Object)"Liferay SystemException");
        }
        return null;
    }

    @Override
    public List<GCubeTeam> listTeamsByGroup(long groupId) throws GroupRetrievalFault {
        ArrayList<GCubeTeam> toReturn = new ArrayList<GCubeTeam>();
        try {
            List teams = TeamLocalServiceUtil.getGroupTeams((long)groupId);
            for (Team team : teams) {
                toReturn.add(LiferayRoleManager.mapLRTeam(team));
            }
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public List<GCubeTeam> listTeamsByUserAndGroup(long userId, long groupId) throws UserRetrievalFault, GroupRetrievalFault {
        ArrayList<GCubeTeam> toReturn = new ArrayList<GCubeTeam>();
        try {
            List teams = TeamLocalServiceUtil.getUserTeams((long)userId, (long)groupId);
            for (Team team : teams) {
                toReturn.add(LiferayRoleManager.mapLRTeam(team));
            }
        }
        catch (PortalException | SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public GCubeTeam updateTeam(long teamId, String teamName, String teamDescription) throws TeamRetrievalFault {
        try {
            Team toEdit = TeamLocalServiceUtil.updateTeam((long)teamId, (String)teamName, (String)teamDescription);
            return LiferayRoleManager.mapLRTeam(toEdit);
        }
        catch (PortalException e) {
            throw new TeamRetrievalFault("The teamId does not exists", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public boolean setUserTeams(long userId, long[] teamIds) throws TeamRetrievalFault {
        try {
            TeamLocalServiceUtil.setUserTeams((long)userId, (long[])teamIds);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteUserTeams(long userId, long[] teamIds) {
        try {
            TeamLocalServiceUtil.deleteUserTeams((long)userId, (long[])teamIds);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean deleteUserTeams(long userId, List<GCubeTeam> teams) {
        long[] teamIds = new long[teams.size()];
        int i = 0;
        for (GCubeTeam r : teams) {
            teamIds[i] = r.getTeamId();
            ++i;
        }
        try {
            TeamLocalServiceUtil.deleteUserTeams((long)userId, (long[])teamIds);
        }
        catch (SystemException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public GCubeTeam getTeam(long groupId, String teamName) throws GroupRetrievalFault, TeamRetrievalFault {
        GCubeTeam toReturn = null;
        try {
            toReturn = LiferayRoleManager.mapLRTeam(TeamLocalServiceUtil.getTeam((long)groupId, (String)teamName));
        }
        catch (PortalException e) {
            throw new TeamRetrievalFault("The teamname or groupdid does not exists", e);
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    @Override
    public boolean assignTeamToUser(long userId, long teamId) throws UserManagementSystemException, UserRetrievalFault, TeamRetrievalFault {
        try {
            _log.debug((Object)("Adding user with id " + userId + " to team with id " + teamId));
            TeamLocalServiceUtil.addUserTeam((long)userId, (long)teamId);
            _log.debug((Object)"User added to group");
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        return false;
    }
}

