/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.gcube.tools.LocalResourceConfiguration;
import org.gcube.tools.TokenSetter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Publisher {
    private static final Logger log = LoggerFactory.getLogger(Publisher.class);
    private static final String TEMP_NAME = "GN_PUBLISH";
    private String baseFolder = null;
    private boolean destroyTemp = false;
    public static final FileFilter NOT_HIDDEN = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isHidden();
        }
    };
    public static final FileFilter XML_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return !pathname.isHidden() && pathname.getName().endsWith(".xml");
        }
    };

    public void execute() {
        log.debug("Starting publishing, baseFolder is : {} ", (Object)this.baseFolder);
        if (this.baseFolder == null) {
            throw new RuntimeException("Base fodler is null");
        }
        File baseFolderDir = new File(this.baseFolder);
        if (!baseFolderDir.exists()) {
            throw new RuntimeException("Base folder not found");
        }
        if (!baseFolderDir.canRead()) {
            throw new RuntimeException("Cannot read base folder");
        }
        if (!baseFolderDir.isDirectory()) {
            throw new RuntimeException("Base folder is not a dir");
        }
        File temp = new File(System.getProperty("java.io.tmpdir"), TEMP_NAME);
        if (temp.exists()) {
            log.debug("Found temp folder " + temp.getAbsolutePath());
            if (this.destroyTemp) {
                log.debug("Cleaning temp .. ");
                try {
                    FileUtils.cleanDirectory((File)temp);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to clean temp ", e);
                }
            }
        } else {
            log.debug("Creating temp folder .. ");
            temp.mkdirs();
        }
        log.debug("Getting baseFolder info ..");
        File[] fileArray = baseFolderDir.listFiles(NOT_HIDDEN);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File firstLevel = fileArray[n2];
            try {
                String scope = Publisher.folderNameToScope(firstLevel.getName());
                log.debug("Found folder {}, assuming scope {} ", (Object)firstLevel.getName(), (Object)scope);
                TokenSetter.set(scope);
                ArrayList parents = ScopeUtils.getParentScopes();
                log.debug("Initializing parent scope configuration, parents are : " + parents);
                String scopeString = "/";
                for (String parent : parents) {
                    scopeString = String.valueOf(scopeString) + parent;
                    TokenSetter.set(scopeString);
                    GeoNetwork.get((Configuration)this.getConfiguration());
                    scopeString = String.valueOf(scopeString) + "/";
                }
                log.debug("Logging in default");
                TokenSetter.set(scope);
                GeoNetworkAdministration publisher = GeoNetwork.get((Configuration)this.getConfiguration());
                publisher.login(LoginLevel.DEFAULT);
                File currentScopeTemp = new File(temp, firstLevel.getName());
                currentScopeTemp.mkdirs();
                File[] toPublishFiles = firstLevel.listFiles(XML_FILTER);
                log.debug("Found {} xml to publish in current scope {} ", (Object)toPublishFiles.length, (Object)scope);
                long currentCount = 0L;
                File[] fileArray2 = toPublishFiles;
                int n3 = toPublishFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    block19: {
                        File toPublish = fileArray2[n4];
                        File publishedCopy = null;
                        try {
                            log.debug("Checking {} ", (Object)toPublish.getName());
                            publishedCopy = new File(currentScopeTemp, toPublish.getName());
                            if (publishedCopy.exists()) {
                                log.debug("Found copy file {} ", (Object)publishedCopy.getAbsolutePath());
                            } else {
                                publisher.insertMetadata(publisher.getCurrentUserConfiguration("dataset", "_none_"), toPublish);
                                log.debug("Published file {}, copying..", (Object)toPublish.getAbsolutePath());
                                FileUtils.copyFile((File)toPublish, (File)publishedCopy);
                                ++currentCount;
                            }
                        }
                        catch (Throwable t) {
                            log.warn("Unable to publish {}.", (Object)toPublish.getAbsolutePath(), (Object)t);
                            if (publishedCopy == null) break block19;
                            FileUtils.deleteQuietly((File)publishedCopy);
                        }
                    }
                    ++n4;
                }
                File[] publishedFiles = currentScopeTemp.listFiles(XML_FILTER);
                int totalPublishedCount = publishedFiles.length;
                log.debug("Published {} files, total count in publishedFolder {}", (Object)currentCount, (Object)totalPublishedCount);
                if (totalPublishedCount != toPublishFiles.length) {
                    throw new Exception("Incoherent file number between " + firstLevel.getAbsolutePath() + " and " + currentScopeTemp.getAbsolutePath());
                }
            }
            catch (Throwable t) {
                log.warn("ERRORS WHILE TRYING TO HANDLE FOLDER {}.", (Object)firstLevel.getAbsolutePath(), (Object)t);
            }
            ++n2;
        }
    }

    public void setBaseFolder(String baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void setDestroyTemp(boolean destroyTemp) {
        this.destroyTemp = destroyTemp;
    }

    public static String folderNameToScope(String folderName) {
        return folderName.replace("_", "/");
    }

    public abstract Configuration getConfiguration();

    public static void main(String[] args) {
        System.out.println("Instantiating publisher..");
        Publisher pub = new Publisher(){

            @Override
            public Configuration getConfiguration() {
                try {
                    return new LocalResourceConfiguration(LocalResourceConfiguration.DEFAULT_FILENAME, LocalResourceConfiguration.DEFAULT_RES_CONFIG);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        pub.setBaseFolder("/home/fabio/workspaces/GNMigration/TEST");
        System.out.println("Launching..");
        pub.execute();
    }
}

