/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.portlets.user.uriresolvermanager.UriResolverManager;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.spatial.data.geonetwork.utils.ScopeUtils;
import org.geotoolkit.metadata.iso.DefaultMetadata;
import org.geotoolkit.metadata.iso.citation.DefaultOnlineResource;
import org.geotoolkit.metadata.iso.distribution.DefaultDigitalTransferOptions;
import org.geotoolkit.metadata.iso.distribution.DefaultDistribution;
import org.geotoolkit.metadata.iso.distribution.DefaultFormat;
import org.geotoolkit.util.DefaultInternationalString;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.distribution.Format;
import org.opengis.util.InternationalString;

public class MetadataFixer {
    public static final String HTTP_PROTOCOL = "WWW:LINK-1.0-http--link";
    public static final String GIS_LINK_NAME = "GIS - LINK";

    public static boolean isGIsLinkPresent(DefaultMetadata meta) {
        for (Format format : meta.getDistributionInfo().getDistributionFormats()) {
            if (!format.getName().toString().equals("HTTP") || !format.getVersion().toString().equals("1.1.0")) continue;
            for (DigitalTransferOptions options : meta.getDistributionInfo().getTransferOptions()) {
                for (OnlineResource res : options.getOnLines()) {
                    if (!res.getProtocol().equals(HTTP_PROTOCOL) || !res.getName().equals(GIS_LINK_NAME)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static DefaultMetadata addGisLink(DefaultMetadata meta) throws UriResolverMapException, IllegalArgumentException, URISyntaxException {
        DefaultDistribution distribution = new DefaultDistribution();
        DefaultFormat format4 = new DefaultFormat();
        format4.setName((InternationalString)new DefaultInternationalString("HTTP"));
        format4.setVersion((InternationalString)new DefaultInternationalString("1.1.0"));
        ArrayList<DefaultFormat> formats = new ArrayList<DefaultFormat>();
        formats.add(format4);
        for (Format format : meta.getDistributionInfo().getDistributionFormats()) {
            formats.add((DefaultFormat)format);
        }
        distribution.setDistributionFormats(formats);
        DefaultDigitalTransferOptions transferOptions = new DefaultDigitalTransferOptions();
        for (DigitalTransferOptions options : meta.getDistributionInfo().getTransferOptions()) {
            for (OnlineResource res : options.getOnLines()) {
                transferOptions.getOnLines().add(res);
            }
        }
        String uriString = MetadataFixer.getGisLinkByUUID(meta.getFileIdentifier());
        URI uri = new URI(uriString);
        DefaultOnlineResource resource = new DefaultOnlineResource(uri);
        resource.setName(GIS_LINK_NAME);
        resource.setProtocol(HTTP_PROTOCOL);
        transferOptions.getOnLines().add(resource);
        distribution.getTransferOptions().add(transferOptions);
        meta.setDistributionInfo((Distribution)distribution);
        return meta;
    }

    public static String getGisLinkByUUID(String uuid) throws UriResolverMapException, IllegalArgumentException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("scope", ScopeUtils.getCurrentScope());
        params.put("gis-UUID", uuid);
        UriResolverManager resolver = new UriResolverManager("GIS");
        String toReturn = resolver.getLink(params, false);
        return toReturn;
    }
}

