/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools;

import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkAdministration;
import org.gcube.spatial.data.geonetwork.LoginLevel;
import org.gcube.tools.TokenSetter;
import org.gcube.tools.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Importer {
    private static final Logger log = LoggerFactory.getLogger(Importer.class);
    private List<String> scopes;
    private String outputFolder;

    public Importer(List<String> scopes, String outputFolder) {
        this.scopes = scopes;
        this.outputFolder = outputFolder;
    }

    public void execute() {
        log.debug("Executing Import.");
        log.debug("Output Folder is {} ", (Object)this.outputFolder);
        File mainFolder = new File(this.outputFolder);
        if (!mainFolder.exists()) {
            mainFolder.mkdirs();
        }
        if (!mainFolder.canWrite()) {
            throw new RuntimeException("Cannot write in destination folder.");
        }
        for (String scope : this.scopes) {
            try {
                Importer.importScopeMetadata(scope, mainFolder);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    private static final void importScopeMetadata(String scope, File folder) throws Exception {
        log.debug("Creating folder for scope {}", (Object)scope);
        String scopeFolderName = scope.replace("/", "_");
        File scopeFolder = new File(folder, scopeFolderName);
        scopeFolder.mkdirs();
        log.debug("Scope folder is {} ", (Object)scopeFolder.getAbsolutePath());
        TokenSetter.set(scope);
        GeoNetworkAdministration reader = GeoNetwork.get();
        log.debug("Getting public Ids");
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.any, "");
        GNSearchResponse resp = reader.query(req);
        Iterator it = resp.iterator();
        HashSet<Long> publicIds = new HashSet<Long>();
        while (it.hasNext()) {
            publicIds.add(((GNSearchResponse.GNMetadata)it.next()).getId());
        }
        log.debug("Found {} public ids", (Object)publicIds.size());
        log.debug("Getting local meta");
        reader.login(LoginLevel.CKAN);
        resp = reader.query(req);
        it = resp.iterator();
        log.debug("Found {} metadata", (Object)resp.getCount());
        long count = 0L;
        while (it.hasNext()) {
            GNSearchResponse.GNMetadata meta = (GNSearchResponse.GNMetadata)it.next();
            if (publicIds.contains(meta.getId())) continue;
            try {
                Utils.meta2File(scopeFolder, String.valueOf(meta.getUUID()) + ".xml", reader.getById(meta.getId().longValue()), Collections.emptyList());
                ++count;
            }
            catch (Exception e) {
                log.warn("Unable to store metadata ID {},UUID {}", (Object)meta.getId(), (Object)meta.getUUID());
            }
        }
        System.out.println("Imported " + count + " into folder " + scopeFolder.getAbsolutePath());
    }

    public static void main(String[] args) {
        ArrayList<String> scopes = new ArrayList<String>();
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/InfraScience");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ICES_TCRE");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/TabularDataLab");
        scopes.add("/d4science.research-infrastructures.eu/FARM/AquaMaps");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/PGFA-UFMT");
        scopes.add("/d4science.research-infrastructures.eu/FARM");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/EuBrazilOpenBio");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/EcologicalModelling");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BlueBRIDGE-PSC");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ENVRIPlus");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ENVRI");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BOBLME_HilsaAWG");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ScalableDataMining");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BiodiversityLab");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/DESCRAMBLE");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/FAO_TunaAtlas");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/StocksAndFisheriesKB");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BlueCommons");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ICES_TCSSM");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BlueBRIDGE-EAB");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ARIADNE");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ProtectedAreaImpactMaps");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/OpenIt");
        scopes.add("/d4science.research-infrastructures.eu");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/AquacultureAtlasGeneration");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/Parthenos");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/IGDI");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/EGIEngage");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/RStudioLab");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/TimeSeries");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/RPrototypingLab");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/TCom");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ICCAT_BFT-E");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/SoBigData.it");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BlueBridgeProject");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BlueUptake");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/gCube");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/KnowledgeBridging");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/EFG");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/StockAssessment");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/iSearch");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/ICOS_ETC");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/VesselActivitiesAnalyzer");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/BiOnym");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/SoBigData.eu");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/PerformanceEvaluationInAquaculture");
        scopes.add("/d4science.research-infrastructures.eu/gCubeApps/StrategicInvestmentAnalysis");
        String outputFolder = "/home/fabio/workspaces/GNMigration/TEST";
        Importer importer = new Importer(scopes, outputFolder);
        importer.execute();
    }
}

