/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class GZipReader {
    private static final Logger LOGGER = Logger.getLogger(GZipReader.class);

    public static byte[] getInnerEntry(String gZipArchive, String entryName) throws IOException {
        File tmpDir = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "GZipReader_" + Long.toString(System.nanoTime()));
        tmpDir.mkdir();
        String cmdLine = "tar xzf " + gZipArchive + " -C " + tmpDir.getAbsolutePath() + " " + entryName;
        LOGGER.debug((Object)("executing: " + cmdLine));
        byte[] res = null;
        try {
            String line;
            Process proc = Runtime.getRuntime().exec(cmdLine);
            BufferedReader input = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
            while ((line = input.readLine()) != null) {
                LOGGER.debug((Object)line);
            }
            input.close();
            File extractedFile = new File(tmpDir.getAbsoluteFile() + File.separator + entryName);
            res = GZipReader.file2byteArray(extractedFile);
        }
        finally {
            GZipReader.deleteDir(tmpDir);
        }
        return res;
    }

    public static boolean entryExists(String gZipArchive, String entryName) throws IOException {
        String line;
        String cmdLine = "tar tzf " + gZipArchive + " " + entryName;
        LOGGER.debug((Object)("executing: " + cmdLine));
        Process proc = Runtime.getRuntime().exec(cmdLine);
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        while ((line = input.readLine()) != null) {
            LOGGER.debug((Object)line);
        }
        input.close();
        input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        line = input.readLine();
        input.close();
        return line != null && line.equals(entryName);
    }

    private static byte[] file2byteArray(File file) throws IOException {
        int len;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileInputStream in = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        while ((len = ((InputStream)in).read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        ((InputStream)in).close();
        out.close();
        return out.toByteArray();
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = GZipReader.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }
}

