/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.tools;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.gcube.tools.report.configurations.ConfigurationsReport;
import org.gcube.tools.report.distribution.DistributionLog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ReleaseNotesGenerator {
    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(ReleaseNotesGenerator.class + " <init|add> [OPTIONS]", options);
    }

    private static void initializeChangelogReport(File report) throws ParserConfigurationException, TransformerException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("Results");
        doc.appendChild(rootElement);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "8");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult("file://" + report.getAbsolutePath());
        transformer.transform(source, result);
        StreamResult logResult = new StreamResult("file://" + report.getAbsolutePath());
        transformer.transform(source, logResult);
    }

    public static void addReleaseNotes(File saDir, File releasenotesReport, ConfigurationsReport releasedConfigs, String artifactName, DistributionLog dl) throws ParserConfigurationException, SAXException, IOException, XPathExpressionException, TransformerException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        XPathFactory factory = XPathFactory.newInstance();
        XPath xPath = factory.newXPath();
        Document releaseNotesDoc = dBuilder.parse(releasenotesReport);
        File changelogFile = new File(saDir + File.separator + "changelog.xml");
        Document changelogDoc = null;
        if (!changelogFile.exists()) {
            dl.addWarning("changelog.xml file not present for " + artifactName, artifactName);
            return;
        }
        changelogDoc = dBuilder.parse(changelogFile);
        NodeList changesets = (NodeList)xPath.evaluate("ReleaseNotes/Changeset", changelogDoc, XPathConstants.NODESET);
        boolean changeSetFound = false;
        int i = 0;
        while (i < changesets.getLength()) {
            Node changeset = changesets.item(i);
            String configurationName = (String)xPath.evaluate("@component", changeset, XPathConstants.STRING);
            Pattern pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+");
            Matcher matcher = pattern.matcher(configurationName);
            int count = 0;
            while (matcher.find()) {
                ++count;
            }
            if (count == 2) {
                configurationName = configurationName.replaceAll("-\\d+\\.\\d+\\.\\d+$", "");
            }
            if (releasedConfigs.getConfigurationStatus(configurationName) != null && !releasedConfigs.getConfigurationStatus(configurationName).equals("locked")) {
                String date = (String)xPath.evaluate("@date", changeset, XPathConstants.STRING);
                Element releasenoteNode = releaseNotesDoc.createElement("ReleaseNote");
                Element cn = releaseNotesDoc.createElement("componentName");
                cn.setTextContent(configurationName);
                releasenoteNode.appendChild(cn);
                Element daten = releaseNotesDoc.createElement("date");
                daten.setTextContent(date);
                releasenoteNode.appendChild(daten);
                Element messagen = releaseNotesDoc.createElement("message");
                releasenoteNode.appendChild(messagen);
                NodeList changes = (NodeList)xPath.evaluate("Change", changeset, XPathConstants.NODESET);
                int j = 0;
                while (j < changes.getLength()) {
                    String change = (String)xPath.evaluate("text()", changes.item(j), XPathConstants.STRING);
                    Element el = releaseNotesDoc.createElement("string");
                    el.setTextContent(change);
                    messagen.appendChild(el);
                    ++j;
                }
                Node releaseNotesRoot = releaseNotesDoc.getFirstChild();
                releaseNotesRoot.appendChild(releasenoteNode);
                changeSetFound = true;
            }
            ++i;
        }
        if (!changeSetFound && releasedConfigs.getUnlockedConfigurationsByNameContains(artifactName).size() > 0) {
            dl.addWarning("no entries for released configuration in changelog.xml", artifactName);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "8");
        DOMSource source = new DOMSource(releaseNotesDoc);
        StreamResult result = new StreamResult(releasenotesReport);
        transformer.transform(source, result);
    }

    public static void main(String[] args) throws Exception {
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.hasArg((boolean)false);
        OptionBuilder.withDescription((String)"print this message");
        Option helpOpt = OptionBuilder.create((String)"h");
        OptionBuilder.withLongOpt((String)"releasenotes");
        OptionBuilder.withArgName((String)"RELEASENOTES.XML");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the releasenotes.xml file to use as output. By default it is distribution.xml");
        Option releaseNotesOpt = OptionBuilder.create((String)"r");
        OptionBuilder.withLongOpt((String)"sadir");
        OptionBuilder.withArgName((String)"FOLDER");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the decompressed SA directory");
        Option saDirOpt = OptionBuilder.create((String)"s");
        OptionBuilder.withLongOpt((String)"logreport");
        OptionBuilder.withArgName((String)"DISTRIBUTION_LOG.XML");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the default is distribution_log.xml");
        Option logReportOpt = OptionBuilder.create((String)"l");
        OptionBuilder.withLongOpt((String)"artifactname");
        OptionBuilder.withArgName((String)"FOLDER");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"the artifact name");
        Option artifactNameOpt = OptionBuilder.create((String)"a");
        OptionBuilder.withLongOpt((String)"releasedreport");
        OptionBuilder.withArgName((String)"xml file");
        OptionBuilder.hasArg((boolean)true);
        OptionBuilder.withDescription((String)"ReleasedConfigurationReport file");
        Option releasedConfigsReportOpt = OptionBuilder.create((String)"u");
        Options options = new Options();
        options.addOption(helpOpt);
        options.addOption(releaseNotesOpt);
        options.addOption(saDirOpt);
        options.addOption(logReportOpt);
        options.addOption(artifactNameOpt);
        options.addOption(releasedConfigsReportOpt);
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption(helpOpt.getOpt())) {
            ReleaseNotesGenerator.printHelp(options);
            return;
        }
        File releasenotesReport = null;
        releasenotesReport = cmd.hasOption("r") ? new File(cmd.getOptionValue("r")) : new File("releasenotes.xml");
        File logReport = null;
        logReport = cmd.hasOption("l") ? new File(cmd.getOptionValue("l")) : new File("distribution_log.xml");
        DistributionLog dl = DistributionLog.load(logReport);
        File saDir = null;
        saDir = cmd.hasOption("s") ? new File(cmd.getOptionValue("s")) : new File("artifacttmp");
        ConfigurationsReport releasedReport = null;
        if (cmd.hasOption("u")) {
            File releasedConfigsReportFile = new File(cmd.getOptionValue("u"));
            releasedReport = ConfigurationsReport.load(releasedConfigsReportFile);
        }
        String artifactName = cmd.getOptionValue("a");
        String command = args[0];
        if (command.equals("init")) {
            ReleaseNotesGenerator.initializeChangelogReport(releasenotesReport);
        } else if (command.equals("add")) {
            if (!saDir.isDirectory()) {
                System.err.println("Ther sa directory " + saDir + " does not exist. Cannot continue");
                System.exit(1);
            }
            ReleaseNotesGenerator.addReleaseNotes(saDir, releasenotesReport, releasedReport, artifactName, dl);
        } else {
            System.err.println("command (first parameter) must be one of 'init' or 'add'. It was: " + command);
        }
        dl.save();
    }
}

