/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.repository;

import it.eng.d4s.sa3.model.Build;
import it.eng.d4s.sa3.repository.RepositoryException;
import it.eng.d4s.sa3.repository.subrepository.BuildRepository;
import it.eng.d4s.sa3.repository.subrepository.FTRepository;
import it.eng.d4s.sa3.repository.subrepository.VRETRepository;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SA3Repository {
    public static final String BUILD_NAME_PREFIX = "BUILD_";
    public static final String BUILD_NAME_PATTERN = "^BUILD_[0-9]+$";
    public static final String ARCHIVED_BUILD_FILE_EXTENSION = ".tar.gz";
    String homeDir = null;
    String name = null;

    public SA3Repository(String homeDir, String name) throws RepositoryException {
        File homeDirF = new File(homeDir);
        if (!homeDirF.exists()) {
            throw new RepositoryException("Repository's homeDir  " + homeDir + " does not exist. Impossible to initialize repository.");
        }
        this.homeDir = homeDir;
        this.name = name;
    }

    public VRETRepository getVRETRepository(String bcName, String sessionName) {
        return new VRETRepository(this, String.valueOf(this.homeDir) + "/" + bcName + "/VRE_REPORTS/" + sessionName, sessionName);
    }

    public FTRepository getFTRepository(String bcName) throws Exception {
        String ftHomeDir = String.valueOf(this.homeDir) + "/" + bcName + "/FT_REPORTS";
        return new FTRepository(this, ftHomeDir);
    }

    public BuildRepository getBuildRepository(String bcName, String buildName) throws Exception {
        String buildHomeDir = String.valueOf(this.homeDir) + "/" + bcName + "/" + buildName;
        if (new File(buildHomeDir).isDirectory()) {
            return new BuildRepository(this, buildName, buildHomeDir, false);
        }
        if (new File(String.valueOf(buildHomeDir) + ARCHIVED_BUILD_FILE_EXTENSION).exists()) {
            return new BuildRepository(this, buildName, buildHomeDir, true);
        }
        throw new RepositoryException("Build " + buildName + "(conf:" + bcName + ") not found in repository: " + this);
    }

    public Build getBuild(String bcName, String buildName) throws Exception {
        BuildRepository brepo = this.getBuildRepository(bcName, buildName);
        return new Build(brepo, bcName, buildName);
    }

    public List<String> getBuildsList(String bcName, int from, int to) {
        if (to - from < 1) {
            return null;
        }
        LinkedList<String> outcome = new LinkedList<String>();
        int i = to;
        while (i >= from) {
            outcome.add(BUILD_NAME_PREFIX + Integer.toString(i));
            --i;
        }
        return outcome;
    }

    public Build getLatestBuild(String bcName) throws Exception {
        List<Build> builds = this.getLatestNBuilds(bcName, 1);
        if (builds.size() < 1) {
            return null;
        }
        return builds.get(0);
    }

    public List<Build> getLatestNBuilds(String bcName, int num) throws Exception {
        List<String> buildsName = this.getLatestNBuildsName(bcName, num);
        LinkedList<Build> builds = new LinkedList<Build>();
        for (String buildName : buildsName) {
            builds.add(this.getBuild(bcName, buildName));
        }
        return builds;
    }

    public Set<String> listAllBuiltConfigurations() {
        return this.listSubDirs("", "^.*$");
    }

    public Set<String> listAllVRETSessions(String bcName) {
        return this.listSubDirs(String.valueOf(bcName) + "/VRE_REPORTS", "^.*$");
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getName() {
        return this.name;
    }

    private Set<String> listSubDirs(String path, final String pattern) {
        String baseDir = String.valueOf(this.homeDir) + File.separator + path;
        File[] items = new File(baseDir).listFiles(new FileFilter(){

            public boolean accept(File arg0) {
                return arg0.getName().matches(pattern) && !arg0.isHidden() && arg0.isDirectory();
            }
        });
        HashSet<String> out = new HashSet<String>();
        if (items == null) {
            return out;
        }
        int i = 0;
        while (i < items.length) {
            out.add(items[i].getName());
            ++i;
        }
        return out;
    }

    public List<String> getLatestNBuildsName(String configurationName, int num) {
        Set<String> allBuilds = this.getAllBuildsName(configurationName);
        if (allBuilds.size() < 1) {
            return new LinkedList<String>();
        }
        int[] sequence = new int[allBuilds.size()];
        int c = 0;
        for (String b : allBuilds) {
            try {
                sequence[c] = Integer.parseInt(b.substring(6));
            }
            catch (Exception e) {
                continue;
            }
            ++c;
        }
        Arrays.sort(sequence);
        if (num == -1) {
            num = sequence.length;
        }
        LinkedList<String> res = new LinkedList<String>();
        int i = sequence.length - 1;
        while (i >= sequence.length - num) {
            if (i < 0) break;
            res.add(BUILD_NAME_PREFIX + sequence[i]);
            --i;
        }
        return res;
    }

    public Set<String> getAllBuildsName(String builtConfiguration) {
        File confHomeDir = new File(String.valueOf(this.homeDir) + File.separator + builtConfiguration);
        File[] items = confHomeDir.listFiles();
        HashSet<String> out = new HashSet<String>();
        if (items == null) {
            return out;
        }
        int i = 0;
        while (i < items.length) {
            block8: {
                String name;
                block7: {
                    block6: {
                        name = null;
                        if (!items[i].isFile() || !items[i].getName().endsWith(ARCHIVED_BUILD_FILE_EXTENSION)) break block6;
                        name = items[i].getName().substring(0, items[i].getName().length() - ARCHIVED_BUILD_FILE_EXTENSION.length());
                        break block7;
                    }
                    if (!items[i].isDirectory()) break block8;
                    name = items[i].getName();
                }
                if (name.matches(BUILD_NAME_PATTERN)) {
                    out.add(name);
                }
            }
            ++i;
        }
        return out;
    }
}

