/*
 * Decompiled with CFR 0.152.
 */
package it.eng.d4s.sa3.report.checkstyle.util;

import com.thoughtworks.xstream.XStream;
import it.eng.d4s.sa3.model.Build;
import it.eng.d4s.sa3.model.ModuleBuild;
import it.eng.d4s.sa3.report.ReportException;
import it.eng.d4s.sa3.report.checkstyle.ModuleCheckstyleReport;
import it.eng.d4s.sa3.repository.resourcetype.BuildResourceType;
import it.eng.d4s.sa3.repository.subrepository.BuildRepository;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckstyleReportGenerator {
    private static final Logger LOGGER = Logger.getLogger(CheckstyleReportGenerator.class);

    public static void generate(Build build, Collection<ModuleBuild> moduleBuilds) throws ReportException {
        if (build.getRepo().isArchived()) {
            throw new ReportException("Build is archived. Checkestyle report cannot be created");
        }
        if (!build.getRepo().existsBResource(BuildResourceType.B_CHECKSTYLE_DATA_DIR)) {
            throw new ReportException("Checkstyle data directory not found for build" + build);
        }
        HashSet<ModuleCheckstyleReport> reportData = new HashSet<ModuleCheckstyleReport>();
        for (ModuleBuild mb : moduleBuilds) {
            ModuleCheckstyleReport rep = CheckstyleReportGenerator.processModuleBuild(mb);
            if (rep == null) continue;
            reportData.add(rep);
        }
        try {
            String filepath = build.getRepo().getAbsoluteResourcePath(build.getRepo().getBResorucePath(BuildResourceType.B_CHECKSTYLE_REPORT));
            CheckstyleReportGenerator.getConfiguratedXStream().toXML(reportData, (OutputStream)new FileOutputStream(filepath));
        }
        catch (Exception e) {
            throw new ReportException(e);
        }
    }

    public static XStream getConfiguratedXStream() {
        XStream xstream = new XStream();
        xstream.alias("ModuleCheckstyleReport", ModuleCheckstyleReport.class);
        return xstream;
    }

    private static ModuleCheckstyleReport processModuleBuild(ModuleBuild mb) {
        BuildRepository repo = mb.getBuild().getRepo();
        ModuleCheckstyleReport res = null;
        if (repo.existsMResource(BuildResourceType.M_CHECKSTYLE_HTML_REPORT, mb)) {
            if (res == null) {
                res = new ModuleCheckstyleReport(mb.getModuleName());
            }
            res.setHasHTMLReport(true);
        }
        if (repo.existsMResource(BuildResourceType.M_CHECKSTYLE_XML_REPORT, mb)) {
            if (res == null) {
                res = new ModuleCheckstyleReport(mb.getModuleName());
            }
            res.setHasXMLReport(true);
            try {
                InputStream is = repo.getMResourceIS(BuildResourceType.M_CHECKSTYLE_XML_REPORT, mb);
                res.setErrors(CheckstyleReportGenerator.computeNumErrors(is));
            }
            catch (Exception e) {
                LOGGER.warn((Object)("Error getting checkstyle report for module " + mb.getModuleName() + ": "));
            }
        }
        return res;
    }

    private static int computeNumErrors(InputStream xmlCheckstyleReport) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(xmlCheckstyleReport);
        xmlCheckstyleReport.close();
        Node checkstyle = document.getElementsByTagName("checkstyle").item(0);
        NodeList files = checkstyle.getChildNodes();
        int errors = 0;
        int i = 0;
        while (i < files.getLength()) {
            Node node = files.item(i);
            if (node.getNodeName().equals("file")) {
                NodeList errorList = node.getChildNodes();
                int k = 0;
                while (k < errorList.getLength()) {
                    if (errorList.item(k).getNodeName().equals("error")) {
                        ++errors;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return errors;
    }
}

