function initializeProjectSelectionTable(){
	var JSTREEToServerToken = {};
	JSTREEToServerToken.type = "LAYERTAXONOMY";
	JSTREEToServerToken.taxonomyID = null;
	
	$('table#ProjectSelectionTable').on( 'init.dt', function(){
		calculateNumberOfTotalCells();
		changeLengthMenuOptions();
	}).on( 'draw.dt', function () {
		var pageLength = $table.DataTable().page.info().pages;
		if(pageLength > 1){
			$('#ProjectSelectionTable_paginate').removeClass('hidden');
		} else {
			$('#ProjectSelectionTable_paginate').addClass('hidden');
		}

		calculateNumberOfTotalCells();
	})
	.dataTable({
		columns: [{
		        	  data: 'one',
		        	  orderable: false
		          },{
		        	  data: 'two',
		        	  orderable: false
		          },{
		        	  data: 'three',
		        	  orderable: false
		          },{
		        	  data: 'four',
		        	  orderable: false
		          },{
		        	  data: 'helperColumn',
		        	  visible: false
		          }],
		pagingType : "full_numbers",
        dom: '<"toolbarContainer">frtlp',
        "lengthMenu": [ 2, 3, 4, 5, 6 ],
		language : {
			"processing" : "Processing...",
			"paginate": {
		        "next": "",
		        "previous": "",
		        "first": "",
		        "last": ""
		    },
		    "search": "_INPUT_",
	        "searchPlaceholder": "Search projects",
	        lengthMenu : "Show _MENU_ entries of _TOTAL_",
		},
		ajax : {
				dataType : 'json',
				contentType: 'application/json',
				url: projectsSummaryURL,
				type: "post",
				data:  function(d){
					return JSON.stringify( userinfoObject );
				},
				dataSrc: function(serverResponse){
		        	if(serverResponse.status === "Success"){
		        		var tileElements = [];
		        		if(serverResponse.response === null){
		        			return [];
		        		}
		        		$.each(serverResponse.response, function(index, value) {
		        			tileElements.push(buildProjectTile(value.name, value.startDate, value.description, value.creator, value.numberOfUsers, 0, value.numberOfLayers));//[0].outerHTML);
		        		});
		        		tileElementsGlobal = tileElements;
		        		
		        		if(tileElements.length > 0) {
		        			projectDataForTheTable = tableData(sortTilesAlphabetically(tileElements, SORT_ASC));
		        			return projectDataForTheTable;
		        		}else{
		        			return [];
		        		}
		        	}
				}
		}
	});
	
	constructAndAppendToolbarElements();
}

function initializeAssignUsersToProjectTable(){
	
	var theData = {};
	theData[nameSpace + 'usersAndGroups'] = true;
	
	$('table#relateUsersToProjectsTable').on( 'init.dt', function(){
//		calculateNumberOfTotalCells();
//		changeLengthMenuOptions();
//		calculateNumberOfTotalRowsForRelateUserToProjectTable();
		putFilterInsideToolbar();
		relateUsersToProjectsButtonsEvents();
		$relateUsersToProjectsTable = $('#relateUsersToProjectsTable').DataTable();
		$relateUsersToProjectsTable2 = $('#relateUsersToProjectsTable').dataTable();
	}).on( 'draw.dt', function () {
		if(setPage){
			setPage = false;
			var thePage = currentPage+1;
			$('#relateUsersToProjectsTable_paginate span:first a:nth-child('+ thePage +')').click();
		}
		var pageLength = $('#relateUsersToProjectsTable').DataTable().page.info().pages;
		if(pageLength > 1){
			$('#relateUsersToProjectsTable_paginate').removeClass('hidden');
		} else {
			$('#relateUsersToProjectsTable_paginate').addClass('hidden');
		}

		calculateNumberOfTotalRowsForRelateUserToProjectTable();
	})
	.dataTable({
		scrollY : "200px",
		columns: [{
					title: 'name',
		        	orderable: true
		          },{
		        	  title: 'email',
		        	  orderable: true
		          },{
		        	  title: 'groups',
		        	  orderable: true
		          },{
		        	  title: 'projects',
		        	  orderable: true
		          },{
		        	  title: 'actions',
		        	  orderable: false
		          },{
		        	  title: 'auxiliaryColumn',
		        	  visible: false,
		        	  orderable: true
		          }],
		pagingType : "full_numbers",
        dom: '<"usersToProjectToolbarContainer">frtlp',
        "lengthMenu": [ 5 ],
		language : {
			"processing" : "Processing...",
			"paginate": {
		        "next": "",
		        "previous": "",
		        "first": "",
		        "last": ""
		    },
		    "search": "_INPUT_",
	        "searchPlaceholder": "Search members",
	        lengthMenu : "Show _MENU_ entries of _TOTAL_",
		},
		ajax : {
				url: retrieveAllUsers,
				type: "post",
				dataType : 'json',
		        contentType: 'application/json',
		        data: function(){
		        	return JSON.stringify(userinfoObject);
		        },
				dataSrc: function(data){
					if(data !== null && !$.isEmptyObject(data) && data.response !== null){
						var usersArray = data.response;
						
						var dtObjectsArray = [];
						
						$.each(usersArray, function(index, value) {
							var dtObj = createDatatableArrayForRelateUsersToProject(value);
							dtObjectsArray.push(dtObj);
						});
						return dtObjectsArray;
					} else return [];
				}
		}
	});
	
//	constructAndAppendToolbarElements();
}

function constructAndAppendToolbarElements(){
	var toolbarContainer = $('.toolbarContainer');
	var divTagAsText = '<div></div>';
	var toolbar = $(divTagAsText, {
		id : 'toolbar',
	});
	var newProject = $(divTagAsText, {
		id : 'createNewProject',
		class : 'customTableToolbarButtons',
		text : 'Create new project'
	});
	var plusIcon = $('<i></i>',{
		class: 'icon-plus pull-left'
	});
	var mostRecent = $(divTagAsText, {
		id: 'mostRecent',
		class : 'customTableToolbarButtons',
		text: 'Most recent'
	});
	var alphabOrder = $(divTagAsText, {
		id: 'alphabOrder',
		class : 'customTableToolbarButtons',
		text: 'Alphabetical order'
	});
	var moreRecords = $(divTagAsText, {
		id: 'moreRecords',
		class : 'customTableToolbarButtons hidden',
		text: 'More records'
	});
	
	newProject.append(plusIcon);
	
	toolbar.append(mostRecent).append(alphabOrder).append(moreRecords);
	toolbarContainer.append(newProject);
	toolbarContainer.append(toolbar);
	
	toolbarEvents();
	tableEvents();
}

function tableEvents(){
	$(document).on('click', '.projectTitle', function(){
		window.location.href = createLink(renderURL, "dss", "&projectName=" + $(this).text() + "~~");
	});
	
	$(document).on('click', '.deleteProject', function(){
		userinfoObject.projectName = $(this).closest('.projectTileTitleContainer').find('.projectTitle').text();
		var callback = function(data){
			if(data.status === "Success") {
				$table.DataTable().ajax.reload();
			}else {
				$('#projectTableErrorModal').modal('show');
				$('#projectError').text(data.message);
			}
		};
		AJAX_Call_POST(deleteProjectURL, callback, userinfoObject);
	});
	
	$(document).on('click', '.editProject', function(){
		EDITMODE = true;
		var projectName = $(this).closest('.projectTileTitleContainer').find('.projectTitle').text();
		var projectDescription = $(this).closest('.projectTileContainer').find('.projectDescription').text();
		userinfoObject.projectName = projectName
		projectNameAndDescriptionObject.name = projectName;
		projectNameAndDescriptionObject.description = projectDescription;
		$('#BBOXModal').modal('show');
	});
}

function requestProjects(){
	var JSTREEToServerToken = {};
	JSTREEToServerToken.type = "LAYERTAXONOMY";
	JSTREEToServerToken.taxonomyID = null;
	projectsSummaryURL;
	listLayersOfType;
	$.ajax({ 
		url: projectsSummaryURL,
        type: 'post',
        dataType : 'json',
        contentType: 'application/json',
        data: JSON.stringify(JSTREEToServerToken),
        success: function(serverResponse){
        	if(serverResponse.status === "Success"){
        		var tileElements = [];
        		var deleteThis = 0;
        		$.each(serverResponse.response, function(index, value) {
        			tileElements.push(buildProjectTile(value.name, value.startDate, value.description, value.creator, deleteThis, deleteThis, deleteThis));//[0].outerHTML);
        			deleteThis++;
        		});
        		tileElementsGlobal = tileElements;
        		if(tileElements.length > 0) {
        			projectDataForTheTable = tableData(sortTilesAlphabetically(tileElements, SORT_ASC));
            		$table.dataTable().fnAddData(projectDataForTheTable);
        		}
        	}
        },error: function(jqXHR, textStatus, errorThrown) {
        	$('#InternalServerErrorModal').modal('show');
        }
      });
}

function buildProjectTile(projectName, projectDate, projDescription,
		projCreatorName, numOfUsers, numOfFunctions, numOfLayers){
	var div = '<div></div>';
	var span = '<span></span>';
	var projectTileContainer = $(div,{
		class : 'projectTileContainer'
	});
	
	var projectTileTitleContainer = $(div,{
		class : 'projectTileTitleContainer'
	});
	var projectTitle = $('<h4></h4>',{
		class : 'projectTitle',
		text : projectName
	});
	projectTileTitleContainer.append(projectTitle);
	
	var projectTileDateContainer = $(div,{
		class : 'projectTileDateContainer'
	});
	var projectTileDate = $(span,{
		class : 'projectTileDate',
		text : timestampToDateString(projectDate),
		'data-date' : projectDate
	});
	var projectToolbar = $(span, {
		class: 'projectToolbar'
	});
	var editProject = $(span, {
		class: 'editProject',
		title: 'Edit Project'
	});
	var editIcon = $('<i></i>',{
		class: 'fa fa-pencil-square-o'
	});
	var deleteProject = $(span,{
		class: 'deleteProject',
		title: 'Delete Project'
	});
	var deleteIcon = $('<i></i>', {
		class: 'fa fa-trash'
	});
	editProject.append(editIcon);
	deleteProject.append(deleteIcon);
	projectToolbar.append(editProject).append(deleteProject);
	projectTileDateContainer.append(projectTileDate);
	projectTileTitleContainer.append(projectToolbar);
	
	var projectDescriptionContainer = $(div, {
		class : 'projectDescriptionContainer'
	});
	var  projectDescription = $('<p></p>', {
		class : 'projectDescription',
		text : projDescription
	});
	projectDescriptionContainer.append(projectDescription);
	
	var projectCreatorNameContainer = $(div, {
		class : 'projectCreatorNameContainer'
	});
	var projectCreatorName = $(span, {
		class : 'projectCreatorName',
		text : 'By: ' + projCreatorName
	});
	projectCreatorNameContainer.append(projectCreatorName);
	
	var projectTileIcons = $(div, {
		class : 'projectTileIcons'
	});
	
	var iconContainer = $(span, {
		class : 'iconContainer'
	});
	var iconUser = $(span,{
		class : 'iconUser projectDetailsIcons',
		title : 'Users'
	});
	var iconText = $(span,{
		class : 'iconText',
		text : numOfUsers
	});
	iconContainer.append(iconUser).append(iconText);
	
	var iconContainer2 = $(span, {
		class : 'iconContainer pull-right hidden'
	});
	var iconFunction = $(span,{
		class : 'iconFunction projectDetailsIcons',
		title : 'Functions'
	});
	var iconText2 = $(span,{
		class : 'iconText',
		text : numOfFunctions
	});
	iconContainer2.append(iconFunction).append(iconText2);
	
	var iconContainer3 = $(span, {
		class : 'iconContainer pull-right'
	});
	var iconLayers = $(span,{
		class : 'iconLayers projectDetailsIcons',
		title : 'Layers'
	});
	var iconText3 = $(span,{
		class : 'iconText',
		text : numOfLayers
	});
	iconContainer3.append(iconLayers).append(iconText3);
	projectTileIcons.append(iconContainer).append(iconContainer2).append(iconContainer3);
	
	var hiddenColumn = $(div, {
		class : 'hiddenColumn hidden'
	});
	
	projectTileContainer
	.append(projectTileTitleContainer)
	.append(projectTileDateContainer)
	.append(projectDescriptionContainer)
	.append(projectCreatorNameContainer)
	.append(projectTileIcons)
	.append(hiddenColumn);
	
	return projectTileContainer;
}

function calculateNumberOfTotalCells(){
	var cellsNumber = $table.DataTable().cells().nodes();
	var totalCellsNumber = 0;
	
	$.each(cellsNumber, function(index, value) {
		var classLength = $(value).find('.projectTileContainer').length;
		if(classLength !== 0){
			totalCellsNumber++;
		}
	});
	
	$('#ProjectSelectionTable_length label').contents().last().replaceWith(' of ' +totalCellsNumber);
}

function calculateNumberOfTotalRowsForRelateUserToProjectTable() {
	var rowsCount = $('#relateUsersToProjectsTable').DataTable().rows().nodes().length;
	$('#relateUsersToProjectsTable_length label').contents().last().replaceWith(' of ' + rowsCount);
	
	var currentPageRowsCount = $('#relateUsersToProjectsTable tbody tr').length;
	var emptyDataTable = $('#relateUsersToProjectsTable tbody td.dataTables_empty').length > 0;
	if(!emptyDataTable){
		$('#relateUsersToProjectsTable_length select option').text(currentPageRowsCount);
	} else {
		$('#relateUsersToProjectsTable_length select option').text(0);
	}
}

function changeLengthMenuOptions(){
	var options = $('#ProjectSelectionTable_length select option');
	$.each(options, function(){
		$(this).text($(this).val()*4);
	});
}

function createDatatableArrayForRelateUsersToProject(userInfo) {
	var dtObject = {};
	
	dtObject.name = userInfo.name;
	dtObject.email = userInfo.email;
	dtObject.groups = "";
	dtObject.projects = userInfo.numOfProjects;
	dtObject.actions = createAddUserToProjecButton();
	dtObject.auxiliaryColumn = '';
	dtObject.userId = '';
	
	var dtArray = [];
	for(var dtData in dtObject){
			dtArray.push(dtObject[dtData]);
	}
	
	return dtArray;
}

function createAddUserToProjecButton(){
	var $button = $('<button></button>',{
		class: 'relateUsersToProjectsButtons addUserToProject',
		text : 'Add'
	});
	var $plus = $('<i></i>',{
		class: 'icon-plus pull-left'
	});
	$button.append($plus);
	
	return $button[0].outerHTML;
}

function relateUsersToProjectsButtonsEvents(){
	$('#relateUsersToProjectsTable').on('click', '.addUserToProject', function(){
		$(this).removeClass('addUserToProject').addClass('removeUserFromProject');
		$(this).find('.icon-plus').removeClass('icon-plus').addClass('icon-remove');
		$(this).contents().first().replaceWith('Remove');
		
		var htmlRow = $(this).closest('tr')[0];
		var rowData = $relateUsersToProjectsTable.rows(htmlRow).data();
		var rowIndex = $relateUsersToProjectsTable.row(htmlRow).index();
		if(rowData !== undefined && rowData !== null) {
			var userName = rowData[0][0];
			var userId = rowData[0][6];//there might be duplicate values
			$('.usersTagsinput').tagsinput('add', userName);
		}
	});
	
	$('#relateUsersToProjectsTable').on('click', '.removeUserFromProject', function(){
		currentPage = $('#relateUsersToProjectsTable').DataTable().page.info().page;
		setPage = true;
		
		$(this).removeClass('removeUserFromProject').addClass('addUserToProject');
		$(this).find('.icon-remove').addClass('icon-plus').removeClass('icon-remove');
		$(this).contents().first().replaceWith('Add');
		
		var htmlRow = $(this).closest('tr')[0];
		var rowData = $relateUsersToProjectsTable.rows(htmlRow).data();
		var userName;
		if(rowData !== undefined && rowData !== null) {
			userName = rowData[0][0];
			$('.usersTagsinput').tagsinput('remove', userName);
		}
	});
}

function setUserInfoObject(){
	
	var theURl = $('#portletInfo').data('loginurl');
	var theData = {};
	theData[nameSpace + 'fetchTenantAndUsername'] = true;
	var callback = function(data){
		userinfoObject = JSON.parse(data);
	};

	$.ajax(
			{
				url: theURl,
				type: 'post',
				datatype:'json',
				data: theData,
				success: function(data){
					callback(data);
					initializeProjectSelectionTable();
				},
				error: function (xhr, ajaxOptions, thrownError) {
					
				}
			}
		);

}