<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ page import="com.liferay.portal.util.PortalUtil"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="http://java.sun.com/portlet_2_0" prefix="portlet"%>

<portlet:defineObjects />
<!-- CSS -->
<!-- jquery datatables css -->
<link rel="stylesheet" type="text/css" href="<c:url value="/css/pickProject/pickProejct.css?01" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/jquery_datatables/jquery.dataTables.css?01" />" />
<!-- font-awesome -->
<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/font-awesome/4.5.0/css/font-awesome.min.css">
<!-- jstree style -->
<link rel="stylesheet" href="<c:url value="/css/jstree/style.css?01" />">
<!-- my css -->
<link rel="stylesheet" type="text/css" href="<c:url value="/css/pickProject/ProjectTile.css?01" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/pickProject/Modals/Modal.css?01" />" />
<link rel="stylesheet" type="text/css" href="<c:url value="/css/Controls/NavToolbarControl.css?01" />" />
<div id="pickProjectContainer">

	<p id="portletInfo" data-namespace="<portlet:namespace/>" data-loginurl="<portlet:resourceURL />"></p>
	
	<div id="projectsHeader">
		<h4 id="projects">Projects</h4>
		<div id="projectsSubheading">choose a project or create a new one</div>
	</div>
	
	<div id="projectTilesContainer">
		<div id="tableSection">
			<table id="ProjectSelectionTable" class="no-wrap " style="width: 100%;">
				<thead>
					<tr role="row">
						<th>
							name
						</th>
						<th>
							email
						</th>
						<th>
							groups
						</th>
						<th>
							projects
						</th>
						<th>
							buttons
						</th>
						<th>
							auxiliaryColumn
						</th>
					</tr>
				</thead>
			</table>
		</div>
	</div>
	
	<div id="InternalServerErrorModal" class="modal fade" hidden="true" tabindex="-1" role="dialog">
	  <div class="modal-header">
		<div id="blueLineBottom">
		    <span id="deleteRoleHeader">Internal server error</span>
		    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
	    </div>
	  </div>
	  <div class="modal-body">
	  	<p>An internal server error has occured. Please try again later</p>
	  </div>
	  <div class="modal-footer">
	    <button id="closeInternalServerModal" class="btn btn-link btn-large" data-dismiss="modal" aria-hidden="true">OK</button>
	  </div>
	</div>
	
	<div id="projectTableErrorModal" class="modal fade" hidden="true" tabindex="-1" role="dialog">
	  <div class="modal-header">
		<div id="blueLineBottom">
		    <span id="errorHeader">Project related error</span>
		    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
	    </div>
	  </div>
	  <div class="modal-body">
	  	<p id="projectError"></p>
	  </div>
	  <div class="modal-footer">
	    <button id="closeInternalServerModal" class="btn btn-link btn-large" data-dismiss="modal" aria-hidden="true">OK</button>
	  </div>
	</div>
	
	<div id="BBOXModal" class="modal fade wizard" hidden="true" tabindex="-1" role="dialog">
	  <div class="modal-header">
		<div id="blueLineBottom">
		    <span class="modalHeader">Create a new project</span>
		    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
	    </div>
	  </div>
	  <div class="modal-body">
	  	<div class="modalBodyTitleContainer">
	  		<p class="modalBodyTitle">1. Zoom to enclose the area of interest within the bounding box</p>
	  		<p class="modalBodyTitleSubheader">Some notes could be placed here</p>
	  	</div>
	  	<div id="mapContainer">
	  		<div id="map">
	  			
	  		</div>
	  		<div id="bboxCoordsAndDrawButton">
	  			<div id='boxCoordsTitle' class="span3">You have selected the area between:</div>
	  			<button id="drawShape" class="offset6 span3 hidden"><span id='polygon'></span> Or draw custom shape</button>
	  			<button id="clearMap" class="offset7 span2">Clear map</button>
	  			<div class="span11 row-fluid coordLabelContainer">
		  			<div id="coord0" class="coordLabel span5 hidden"></div>
		  			<div id="coord1" class="coordLabel span5 hidden offset2"></div>
	  			</div>
	  			<div class="span11 row-fluid coordLabelContainer">
		  			<div id="coord2" class="coordLabel span5 hidden"></div>
		  			<div id="coord3" class="coordLabel span5 hidden offset2"></div>
	  			</div>
	  		</div>
	  	</div>
	  </div>
	  <div class="modal-footer">
	  	<span id='chooseAreaMessage' class="hidden" style='color : red; margin-right: 1em;;'>
	  		Please, select an area of interest
	  	</span>
	    <button id="goToChooseLayersModalFromBBOXModal" class="btn btn-link btn-large goToNextModal">
	    	Next <i class="fa fa-caret-right" aria-hidden="true"></i>
	    </button>
	    <button id="" class="btn btn-link btn-large cancelBtns" data-dismiss="modal" aria-hidden="true">Cancel</button>
	  </div>
	</div>
	
	<div id="ChooseLayersModal" class="modal fade wizard" hidden="true" tabindex="-1" role="dialog">
	  <div class="modal-header">
		<div id="blueLineBottom">
		    <span class="modalHeader">Create a new project</span>
		    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
	    </div>
	  </div>
	  <div class="modal-body">
	  	<div class="modalBodyTitleContainer">
	  		<p class="modalBodyTitle">2. Enter the layers for this project</p>
	  		<p class="modalBodyTitleSubheader">Some notes could be placed here</p>
	  	</div>
	  	
	  	<div id="modalLayerMapContainer">
			<div id="modalLayerMap">
				
			</div>
		
		</div>
	  	
	  	<div id='layerTabsContainer'>
	  		<ul class="nav nav-tabs" id="layerTabs">
			  <li class="active tabListItem">
			  	<a class="tabLink notClicked" href="#availableLayers">From available layers</a>
			  </li>
			  <li class="tabListItem">
			  	<a class="tabLink" href="#fromURL">From URL</a>
			  </li>
			</ul>
			 
			<div class="tab-content">
				<div class="tab-pane active" id="availableLayers">
				
					<div id='treeviewLayers'>
						
					</div>
				</div>
			  <div class="tab-pane" id="fromURL">
			  	<div id="layersFromUrlContainer">
			  		<label for='layersFromURLInput' class="span8">
			  			<input type="text" id='layersFromURLInput' name='layersFromURLInput'/> URL
			  		</label>
			  	</div>
			  </div>
			</div>
	  	</div>
	  	
	  </div>
	  <div class="modal-footer">
	  	<button id="goToBBOXModal" class="btn btn-link btn-large">
	    	Back <i class="fa fa-caret-left" aria-hidden="true"></i>
	    </button>
	    <button id="goToRelateUsersToProjectModal" class="btn btn-link btn-large">
	    	Next <i class="fa fa-caret-right" aria-hidden="true"></i>
	    </button>
	    <button id="goToRelateUsersToProjectModalSkipButton" class="btn btn-link btn-large">
	    	Skip
	    </button>
	    <button id="" class="btn btn-link btn-large cancelBtns" data-dismiss="modal" aria-hidden="true">Cancel</button>
	  </div>
	</div>
	
	<div id="RelateUsersToProjectModal" class="modal fade wizard" hidden="true" tabindex="-1" role="dialog">
	  <div class="modal-header">
		<div id="blueLineBottom">
		    <span class="modalHeader">Create a new project</span>
		    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
	    </div>
	  </div>
	  <div class="modal-body">
		<div class="modalBodyTitleContainer">
			<p class="modalBodyTitle">3. Choose who can see your project</p>
			<p class="modalBodyTitleSubheader">Some notes could be placed here</p>
	  	</div>
	  	<div class="tableTagsContainer">
		  	<div class="tableContainer">
		  		<table id="relateUsersToProjectsTable" class="no-wrap " style="width: 100%;">
					<tbody>
					</tbody>
				</table>
		  	</div>
		  	<div class="tagsContainer">
		  	</div>
	  	</div>
	  	<div class="selectedUsersSection">
	  		<div class="selectedUsersHeader">
	  			Selected Users (<span id="numOfSelectedUsers"></span>)
	  		</div>
	  		<div class="selectdUsersTagSection hidden">
	  			<input type="text" value="" data-role="tagsinput" hidden="true" class="hidden usersTagsinput"/>
	  		</div>
	  	</div>
	  </div>
	  <div class="modal-footer">
	  	<button id="goToChooseLayersModalFromRelateUsersToProjectModal" class="btn btn-link btn-large">
	    	Back <i class="fa fa-caret-left" aria-hidden="true"></i>
	    </button>
	    <button id="goToProjectNameAndDescriptionModal" class="btn btn-link btn-large">
	    	Next <i class="fa fa-caret-right" aria-hidden="true"></i>
	    </button>
	    <button id="" class="btn btn-link btn-large cancelBtns" data-dismiss="modal" aria-hidden="true">Cancel</button>
	  </div>
	</div>
	
	<div id="projectNameAndDescriptionModal" class="modal fade wizard" hidden="true" tabindex="-1" role="dialog">
	  <div class="modal-header">
		<div id="blueLineBottom">
		    <span class="modalHeader">Create a new project</span>
		    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">×</button>
	    </div>
	  </div>
	  <div class="modal-body">
		<div class="modalBodyTitleContainer">
			<p class="modalBodyTitle">4. Choose a name and a description for your project</p>
			<p class="modalBodyTitleSubheader">Some notes could be placed here</p>
			<p id="projectNameDescriptionValidation" class="hidden" style="color:red;">Project name cannot be empty</p>
			<p id="projectAlreadyExists" class="hidden" style="color:red;"></p>
	  	</div>
	  	<div class="projectAttributes">
	  		<div class="row-fluid">
	  			<div class="span3">
	  				<label for="projectName">Name:</label>
	  			</div>
	  			<div class="span9">
	  				<input type="text" id="projectName" class="span12" placeholder="Name of project">
	  			</div> 
	  		</div>
	  		<div class="row-fluid">
	  			<div class="span3">
	  				<label for="projectDescription">Description:</label>
	  			</div>
	  			<div class="span9">
	  				<textarea id="projectDescription" class="span12" rows="4" placeholder="Describe the project here"></textarea>
	  			</div>
	  		</div>
	  	</div>
	  </div>
	  <div class="modal-footer">
	  	<button id="goBackToRelateUsersToProjectModal" class="btn btn-link btn-large">
	    	Back <i class="fa fa-caret-left" aria-hidden="true"></i>
	    </button>
	    <button id="CreateProjectButton" class="btn btn-link btn-large">OK</button>
	    <button id="" class="btn btn-link btn-large cancelBtns" data-dismiss="modal" aria-hidden="true">Cancel</button>
	  </div>
	</div>

</div>

<!-- URLs -->
<portlet:resourceURL var="theResourceURL" />
<portlet:resourceURL id="projects/brief" var="projectsSummaryURL"/>
<portlet:resourceURL id="projects/create" var="projectCreateURL"/>
<portlet:resourceURL id="projects/updateProject" var="projectUpdateURL"/>
<portlet:resourceURL id="projects/retrieveAllUsersInDB" var="retrieveAllUsers"/>
<portlet:resourceURL id="projects/delete" var="deleteProjectURL"/>
<portlet:resourceURL id="projects/bbox" var="bboxURL"/>
<portlet:resourceURL id="projects/participants" var="participantsURL"/>
<portlet:resourceURL id="shapes/listLayersOfTypeOrderedByTaxonomy" var="listLayersOfType"/>
<portlet:resourceURL id="shapes/listLayersOfType" var="listOfAllLayers"/>
<portlet:resourceURL id="shapes/listLayersByProject" var="listLayersByProject"/>

<!-- scripts -->
<script type="text/javascript">
if (typeof jQuery == "undefined") {
	document.write('<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"><\/script>');
}
</script>
<script src="<c:url value="/js/bootstrap.js?01" />"></script>
<script src="<c:url value="/js/Utils/CreateLink.js?01" />"></script>

<!-- jquery datatables -->
<script src="<c:url value="/js/jquery_datatables/jquery.dataTables.js?01" />"></script>
<script src="<c:url value="/js/jquery_datatables/dataTables.responsive.min.js?01" />"></script>

<!-- jstree -->
<script src="<c:url value="/js/jstree/jstree.js?01" />"	type="text/javascript"></script>

<!-- openlayers -->
<link rel="stylesheet" href="<c:url value="/css/openlayers3/ol.css?01" />" type="text/css">
<script src="<c:url value="/js/openlayers3/ol-debug.js?01" />" type="text/javascript"></script>

<script src="<c:url value="/js/InitializeProjectSelectionTable/RetrieveLayersForProject.js?01" />"></script>

<!-- utils -->
<script src='<c:url value="/js/Utils/AjaxCalls.js?01" />'></script>
<script src="<c:url value="/js/InitializeProjectSelectionTable/EditMode.js?01" />"></script>

<!-- tables initialization -->
<script src="<c:url value="/js/InitializeProjectSelectionTable/InitializeProjectSelectionTable.js?01" />"></script>
<script src="<c:url value="/js/InitializeProjectSelectionTable/CustomSearch.js?01" />"></script>
<script src="<c:url value="/js/InitializeProjectSelectionTable/Sorting.js?01" />"></script>
<script src="<c:url value="/js/InitializeProjectSelectionTable/ToolbarEvents.js?01" />"></script>
<script src="<c:url value="/js/Utils/Utils.js?01" />"></script>

<!-- modal events -->
<script src="<c:url value="/js/InitializeProjectSelectionTable/ModalEvents.js?01" />"></script>
<script src="<c:url value="/js/InitializeProjectSelectionTable/SelectLayersTabs.js?01" />"></script>

<!-- cutom map controls -->
<script src='<c:url value="/js/Controls/CustomControls.js?01" />'></script>

<!-- Tags input -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/bootstrap.tagsinput/0.4.2/bootstrap-tagsinput.css?01" />
<script src="https://cdn.jsdelivr.net/bootstrap.tagsinput/0.4.2/bootstrap-tagsinput.min.js?01"></script>

<script type="text/javascript">
var renderURL = '<portlet:renderURL><portlet:param name="jspPage" value="{url}.jsp" /><portlet:param name="getParams" value="{params}" /></portlet:renderURL>';
var theResourceURL = '<%=theResourceURL%>';
var resourceURL = '<portlet:resourceURL id="{url}?{params}" />';
var nameSpace = $('#portletInfo').data('namespace');
var LISTLAYERSFLAG = true;
var EDITMODE = false;
var $table = $('#ProjectSelectionTable');
var $relateUsersToProjectsTable;
var $relateUsersToProjectsTable2;
var useridOfItemToBeRemoved;
var initialState;
var numOfCols = 4;//$table.find('tr:first td').length;
var mapNumbersInWordFormWihtOthers = [];
mapNumbersInWordFormWihtOthers[0] = 'zero';
mapNumbersInWordFormWihtOthers[1] = 'one';
mapNumbersInWordFormWihtOthers[2] = 'two';
mapNumbersInWordFormWihtOthers[3]= 'three';
mapNumbersInWordFormWihtOthers[4] = 'four';
mapNumbersInWordFormWihtOthers[5] = 'helperColumn';
var projectsSummaryURL = '<%= projectsSummaryURL %>';
var listLayersOfType = '<%= listLayersOfType %>';
var listOfAllLayers = '<%=listOfAllLayers %>';
var retrieveAllUsers = '<%=retrieveAllUsers%>';
var projectCreateURL = '<%=projectCreateURL%>';
var projectUpdateURL = '<%=projectUpdateURL%>';
var deleteProjectURL = '<%=deleteProjectURL%>';
var bboxURL = '<%=bboxURL%>';
var listLayersByProjectUrl = '<%=listLayersByProject%>';
var participantsURL = '<%=participantsURL%>';
var projectDataForTheTable = [];
var tileElementsGlobal = [];
var SORT_ASC = 1;
var SORT_DESC = 2;
var searchVal = '';
var map;
var updateMapInModalTheFirstTime = false;
var draw;
var source;
var coords = {};
var coordsObjectToBeSendToDSS = {};
var app = {};
var activeControls = {};
var layersObject = {};
var userinfoObject = {};
layersObject.jstreeLayers = [];
layersObject.skipped = false;
var jstreeIsLoaded = false;
var globalDataObjectForDSSApp = {};
var usersArray = [];
var projectNameAndDescriptionObject = {};
var layersByName = {};
var layerNamesObject = [];
var layersMap = null;
var currentPage;
var setPage = false;

$(document).ready(function() {
	setUserInfoObject();
	CustomSearch();
	modalEvents();
	selectLayersTabs();
	retrieveLayers();
});
</script>