package org.gcube.deploytest.client;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ServiceException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScope.MalformedScopeExpressionException;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.common.core.types.VOID;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.ReportingPortType;
import org.gcube.vremanagement.resourcemanager.stubs.reporting.service.ReportingServiceAddressingLocator;
import org.gcube.vremanagement.vremodeler.stubs.CollectionArray;
import org.gcube.vremanagement.vremodeler.stubs.CollectionList;
import org.gcube.vremanagement.vremodeler.stubs.CollectionType;
import org.gcube.vremanagement.vremodeler.stubs.FunctionalityIDArray;
import org.gcube.vremanagement.vremodeler.stubs.GHNArray;
import org.gcube.vremanagement.vremodeler.stubs.ModelerFactoryPortType;
import org.gcube.vremanagement.vremodeler.stubs.ModelerServicePortType;
import org.gcube.vremanagement.vremodeler.stubs.VREDescription;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerFactoryServiceAddressingLocator;
import org.gcube.vremanagement.vremodeler.stubs.service.ModelerServiceAddressingLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
/**
 * 
 * @author Andrea Manzi (CERN)
 *
 */
public class CreateVRE {

	public  String ghn1 = null;
	public  String ghn2 = null;
	protected String  vreName;
	private QueryInformationSystem query = null;
	private ArrayList<String> resourceIds = new ArrayList<String>();
	ModelerFactoryPortType mfptp = null;
	EndpointReferenceType eprModelerRes = null;

	/**
	 * Costructor 
	 * @param vreName the vreName
	 * @param ghn1 ghn1 host+port
	 * @param ghn2 ghn2 host+port
	 */
	public CreateVRE (String vreName, String  ghn1, String ghn2,String scope) {
		this.ghn1 = ghn1;
		this.ghn2 = ghn2;
		this.vreName = vreName;
		new Deploy(scope);
		try {
			query = new QueryInformationSystem();
		} catch (Exception e1) {
			e1.printStackTrace();
		}
	} 

	/**
	 * Calls to VREModeler to create the VRE
	 * @return the ModelerServicePortType 
	 */
	private  ModelerServicePortType createVRE() throws RemoteException{

		ModelerFactoryServiceAddressingLocator mfal =new ModelerFactoryServiceAddressingLocator();
		Deploy.logInfo("Querying IS");

		try {
			mfptp = mfal.getModelerFactoryPortTypePort(query.getVREModelerEndpoint());
		} catch (ServiceException e) {
			e.printStackTrace();
		}

		try {
			mfptp = GCUBERemotePortTypeContext.getProxy(mfptp, GCUBEScope.getScope(Deploy.SCOPE));
		} catch (MalformedScopeExpressionException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		//refresh the db
		try {
			mfptp.initDB(new VOID());
			Thread.sleep(100000);
		} catch (RemoteException e1) {
			e1.printStackTrace();
		} catch (InterruptedException e) {
			e.printStackTrace();
		}



		try {
			eprModelerRes = mfptp.createResource(new VOID());
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		Deploy.logInfo("VREModeler Resource created\n");
		ModelerServiceAddressingLocator msal= new ModelerServiceAddressingLocator();
		ModelerServicePortType msptp = null;
		try {
			msptp = msal.getModelerServicePortTypePort(eprModelerRes);
		} catch (ServiceException e) {
			e.printStackTrace();
		}


		try {
			msptp = GCUBERemotePortTypeContext.getProxy(msptp,
					GCUBEScope.getScope(Deploy.SCOPE));
		} catch (MalformedScopeExpressionException e) {
			e.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}


		VREDescription vreReq= new VREDescription();
		vreReq.setStartTime(Calendar.getInstance());
		vreReq.setEndTime(Calendar.getInstance());
		vreReq.setDescription("Testing VRE");
		vreReq.setDesigner("Andrea");
		vreReq.setManager("Andrea");


		vreReq.setName(this.vreName);
		try {
			msptp.setDescription(vreReq);
		} catch (RemoteException e) {
			e.printStackTrace();
		}
		/*
		 *  0,'Search (Browse, Simple, and Combined)'
			1,'Annotation'
			2,'Report definition'
			3,'Course management'
			4,'Thumbnail'
			5,'Metadata Editing'
			6,'Report Template Definition'
			9,'Search by Query Expression'
 			10,'Google Search'
			11,'Geographic Search'
			12,'Quick Search'
		 */


		FunctionalityIDArray fida= new FunctionalityIDArray();
		String [] functionalityArray = new String[] {"0","1","2","3","4","5","6","7","8","9","10","11","12"};
		fida.setFunctionalityIDElement(functionalityArray);
		try {
			msptp.setFunctionality(fida);

		} catch (RemoteException e) {
			e.printStackTrace();
		}

		//set Collectioninformation
		prepareCollectionsInfo(msptp);

		//Discover the two running GHN
		GHNArray ghnArray= new GHNArray();

		Deploy.logInfo("Setting GHNs for VRE:\n "+ ghn1 +"\n" + ghn2);
		String id1 = query.getGHNId(ghn1);
		String id2 = query.getGHNId(ghn2);
		Deploy.logInfo("With IDs"+ id1 +"\n" + id2);
		ghnArray.setGHNElement(new String[]{id1,id2});
		ghnArray.setCandidateGHN(id1);
		try {
			msptp.setGHNs(ghnArray);

		} catch (RemoteException e) {
			e.printStackTrace();
			throw e;
		}

		try {
			msptp.deployVRE(new VOID());
		} catch (RemoteException e) {
			e.printStackTrace();
			throw e;
		}

		Deploy.logInfo("VRE Deployment started\n");
		return msptp;
	}



	private void prepareCollectionsInfo(ModelerServicePortType msptp )
	{
		//Setting the collections
		CollectionArray coleArr = new CollectionArray();

		CollectionList list =null;
		try {
			list = msptp.getCollection(new VOID());

		}catch (RemoteException e) {
			e.printStackTrace();
		}

		ArrayList<String> collectionIds = new ArrayList<String> ();

		for (CollectionType  type: list.getList()) {
			Deploy.logDebug("Adding collection with ID " +type.getId()+" to VRE");
			collectionIds.add(type.getId());
		}
		String [] collectionIDS = new String[collectionIds.size()];
		try {
			coleArr.setCollectionElement(collectionIds.toArray(collectionIDS));
			msptp.setCollection(coleArr);

		} catch (RemoteException e) {
			e.printStackTrace();
		}

		

	}

	
	/**
	 * Check if the VRE resources have been correcty created
	 * 
	 * @param porType
	 */
	public boolean checkVREResources(ModelerServicePortType porType) {

		QueryInformationSystem queryVRE = null;
		String id;
		boolean result= true;

		try {
			queryVRE = new QueryInformationSystem(Deploy.SCOPE+'/'+this.vreName);
		} catch (Exception e) {
			e.printStackTrace();
		}

		try {
			//Check VRE Resource
			if ((id = queryVRE.getGenericResourceBySecondaryType(GCUBEGenericResource.SECONDARYTYPE_VRE))== "")
			{
				Deploy.logError("The VRE Generic Resource has not been published on the IS");
				result = false;
			}
			else {
				Deploy.logInfo("The VRE Generic Resource has been correctly published");
				resourceIds.add(id);
			}

			//Check Available portlets
			if ((id = queryVRE.getGenericResourceBySecondaryType("PortletLayoutResource"))== "")
			{
				Deploy.logError("The Available Portlet Generic Resource has not been published on the IS");
				result = false;
			}
			else {
				Deploy.logInfo("The Available Portlet Generic Resource has been correctly published");
				resourceIds.add(id);
			}

			//Check Layout
			String layoutResourceName = "Layout"+replaceBackSlash(Deploy.SCOPE)+"_"+this.vreName;

			if ((id =queryVRE.getGenericResourceByName(layoutResourceName))=="")
			{
				Deploy.logError("The VRE Layout Generic Resource has not been published on the IS");
				result = false;
			}
			else {
				Deploy.logInfo("The VRE Layout Generic Resource has been correctly published");
				resourceIds.add(id);
			}


			//Check Scenario CollectionInfo

			if ((id = queryVRE.getGenericResourceByName("ScenarioCollectionInfo"))=="")
			{
				Deploy.logError("The ScenarioCollectionInfo Generic Resource has not been published on the IS");
				result = false;
			}
			else {
				Deploy.logInfo("The ScenarioCollectionInfo Generic Resource has been correctly published");
				resourceIds.add(id);
			}


		} catch (Exception e) {
			Deploy.logError("Error checking Generic Resources Creation",e);
			result = false;
		}

		return result;
	}

	
	/**
	 * Contacts the ResourceManager to get a deployment report
	 * @param epr
	 * @param scope the VREManager scope
	 * @param deploymentId the related deployment id
	 * @return the Deployment report
	 */
	public String getDeploymentReport(EndpointReferenceType epr, String scope,String deploymentId) {

	
		ReportingPortType pt;
		String report = null;
		try {
	

			GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  
				public boolean isSecurityEnabled() {return false;}};
				pt = GCUBERemotePortTypeContext.getProxy(new ReportingServiceAddressingLocator().getReportingPortTypePort(epr), 
						GCUBEScope.getScope(scope),managerSec);

				report = pt.getReport(deploymentId);
				Deploy.logInfo("REPORT");
				Deploy.logInfo("************");

				// Get DOM Parser Factory
				DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance( );

				DocumentBuilder builder = factory.newDocumentBuilder( );
				Document doc = builder.parse(new StringBufferInputStream(report));
				TransformerFactory ft = TransformerFactory.newInstance();
				Transformer transformer = ft.newTransformer();
				transformer.setOutputProperty(OutputKeys.INDENT, "yes");
				transformer.setParameter("indent-number", new Integer(4));
				//initialize StreamResult with File object to save to file
				StreamResult result = new StreamResult(new StringWriter());
				transformer.transform(new DOMSource(doc), result);
				Deploy.logInfo(result.getWriter().toString());
				Deploy.logInfo("************");
		} catch (Exception e) {
			e.printStackTrace();
		}
		return report;
	}
	
	/**
	}
	 * Check the Status of the VRE creation
	 * 
	 * @param portType the Modeler port Type
	 */
	public boolean checkVREStatus(ModelerServicePortType portType) throws Exception{

		String response = null;
		QueryDeploymentInformation info = new QueryDeploymentInformation();
		boolean depResolution= false;
		boolean deployVREstatus = false;

		Deploy.logInfo("Checking the status of the Deployment of the ResourceManager for VRE "+this.vreName  );

		long time = System.currentTimeMillis();


		while ((depResolution == false) && 
				((System.currentTimeMillis() - time) < 600000))
		{
			try {
				response= portType.checkStatus(new VOID());
			} catch (RemoteException e) {
				e.printStackTrace();
			}
			if (response != null && response.compareTo("") != 0)
			{
				Deploy.logInfo("Getting first Report: "+response);
				info.parseXml(response);
			} else {
				try {
					Thread.sleep(10000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				continue;
			}
			try{

				depResolution = info.checkDeploymentInfo( query);

			}catch (Exception e) {
				e.printStackTrace();
				throw e;
			}

			if (depResolution == false)
			{
				try {
					Thread.sleep(60000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}


		try {
			Thread.sleep(60000);
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}

		time = System.currentTimeMillis();

		if (depResolution)
			Deploy.logInfo("The ResourceManager for VRE "+this.vreName +" has been correctly deployed\n" );
		else 	Deploy.logInfo("The ResourceManager for VRE "+this.vreName +" has not been deployed correctly\n" );

		Deploy.logInfo("Checking the deployment status of the VRE Services\n");

		QueryDeploymentInformation infoVRE = new QueryDeploymentInformation();

		while ((deployVREstatus == false) && 
				((System.currentTimeMillis() - time) < 600000))
		{

			try {
				response = portType.checkStatus(new VOID());
			} catch (RemoteException e) {
				e.printStackTrace();
			}

			if (response != null && response.compareTo("") != 0)
			{
				Deploy.logInfo("Getting second Report: "+response);
				infoVRE.parseXml(response);

			} else {
				try {
					Thread.sleep(10000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
				continue;
			}


			deployVREstatus = infoVRE.checkDeploymentInfo( query);

			if (deployVREstatus == false)
			{
				try {
					Thread.sleep(60000);
				} catch (InterruptedException e) {
					e.printStackTrace();
				}
			}
		}

		if (deployVREstatus)
			Deploy.logInfo("The VRE Services for VRE "+this.vreName +" have been correctly deployed\n" );
		else 
			Deploy.logInfo("The VRE Services for VRE "+this.vreName +" have not been deployed correctly\n" );

		return (deployVREstatus && depResolution);
	}


	private String getTextValue(Element ele, String tagName) {
		String textVal = null;
		NodeList nl = ele.getElementsByTagName(tagName);
		if(nl != null && nl.getLength() > 0) {
			Element el = (Element) nl.item(0);
			textVal = el.getFirstChild().getNodeValue();
		}

		return textVal;
	}

	/**
	 * Main 
	 * @param args Command line paramenter (vrename,  ghn1, ghn2)
	 */
	public static void main (String [] args)
	{
		boolean checkResources = true;
		boolean deployVREstatus = true;
		ModelerServicePortType portType = null;
		String vreName = args[0] +"_"+ System.currentTimeMillis();

		QueryDeploymentInformation infoVRE = new QueryDeploymentInformation();

		CreateVRE vre= new CreateVRE(vreName,args[1],args[2],args[4]);

		try {
			portType = vre.createVRE();
		} catch (RemoteException e){
			Deploy.logInfo("Error Creating VRE: " +e);
			infoVRE.writeVREFile("FAILED");
			System.exit(1);
		}

		try {
			Thread.sleep(60000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}


		try {
			deployVREstatus = vre.checkVREStatus(portType);
			Thread.sleep(20000);
		} catch (Exception e) {
			Deploy.logInfo("Error checking  VRE status: " +e);
			infoVRE.writeVREFile("FAILED");
			System.exit(1);
		}

		checkResources = vre.checkVREResources(portType);

		if (Boolean.parseBoolean(args[3]))
		{	
			QueryDeploymentInformation undeployInfo = new QueryDeploymentInformation();
			String undeploymentId= null;
			String unDeploymentReport = null;
			boolean depResolution = false;
			String vreScope = Deploy.SCOPE+'/'+vre.vreName;
			QueryInformationSystem is = null;
			try {
				is = new  QueryInformationSystem(vreScope);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
			
			Long time = System.currentTimeMillis();

			if (undeploymentId == null)
				Deploy.logError("Failed to dispose the VRE scope..");			
			else {
				while ((depResolution == false) && 
						((System.currentTimeMillis() - time) < 900000))
				{
					try {

						unDeploymentReport = vre.getDeploymentReport(is.getResourceManagerEndpoint(),vreScope,undeploymentId);

						undeployInfo.parseXml(unDeploymentReport);

						depResolution = undeployInfo.checkUnDeploymentInfo(is);

					}
					catch (Exception e){
						e.printStackTrace();
						Deploy.logError("Unable to parse a  UnDeploymentReport",e);
					}
					if (depResolution == false)
						try {
							Thread.sleep(60000);
						} catch (InterruptedException e) {
							e.printStackTrace();
						}
				}

			}


		}
		Deploy.logInfo("VRE Deployment test terminated");
		Deploy.logInfo("Deployment service check has returned: " +deployVREstatus);
		Deploy.logInfo("Generic Resource check has returned: " +checkResources);


		if (checkResources && deployVREstatus)
			System.exit(0);
		else System.exit(1);

	}

	private static String replaceBackSlash(String input) {
		return input.replaceAll("\\/", "_");
	}

}