/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vremanagement.resourcemanager.testsuite;

import java.io.IOException;
import java.rmi.Remote;
import java.util.Properties;
import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.AttributedURI;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.AddResourcesParameters;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceList;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ResourceManagerPortType;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceItem;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.ServiceList;
import org.gcube.vremanagement.resourcemanager.stubs.resourcemanager.service.ResourceManagerServiceAddressingLocator;
import org.gcube.vremanagement.resourcemanager.testsuite.security.Utils;

public class AddResourceTest {
    protected static Properties resources = new Properties();

    public static void main(String[] args) {
        if (args.length < 2) {
            AddResourceTest.printUsage();
        }
        try {
            resources.load(AddResourceTest.class.getResourceAsStream("/" + args[1]));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Runtime.getRuntime().exit(1);
        }
        EndpointReferenceType endpoint = new EndpointReferenceType();
        try {
            endpoint.setAddress((AttributedURI)new Address(args[0]));
            ResourceManagerPortType pt = new ResourceManagerServiceAddressingLocator().getResourceManagerPortTypePort(endpoint);
            if (args.length == 3) {
                GCUBESecurityManager securityManager = Utils.generateAndConfigureDefaultSecurityManager(args[2], true);
                securityManager.setSecurity((Remote)pt, GCUBESecurityManager.AuthMode.PRIVACY, GCUBESecurityManager.DelegationMode.FULL);
                pt = (ResourceManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)resources.getProperty("callerScope").trim()), (GCUBESecurityManager[])new GCUBESecurityManager[]{securityManager});
            } else {
                pt = (ResourceManagerPortType)GCUBERemotePortTypeContext.getProxy((Remote)pt, (GCUBEScope)GCUBEScope.getScope((String)resources.getProperty("callerScope").trim()), (GCUBESecurityManager[])new GCUBESecurityManager[0]);
            }
            AddResourcesParameters add = new AddResourcesParameters();
            if (new Integer(resources.getProperty("numOfServicesToAdd")) > 0) {
                ServiceItem[] servicelist = new ServiceItem[new Integer(resources.getProperty("numOfServicesToAdd")).intValue()];
                for (int i = 1; i < servicelist.length + 1; ++i) {
                    servicelist[i - 1] = new ServiceItem();
                    servicelist[i - 1].setServiceClass(resources.getProperty("service." + i + ".class"));
                    servicelist[i - 1].setServiceName(resources.getProperty("service." + i + ".name"));
                    servicelist[i - 1].setServiceVersion(resources.getProperty("service." + i + ".version"));
                    if (resources.getProperty("service." + i + ".GHN") == null) continue;
                    servicelist[i - 1].setGHN(resources.getProperty("service." + i + ".GHN"));
                }
                ServiceList l = new ServiceList();
                l.setService(servicelist);
                if (resources.getProperty("GHNSet") != null) {
                    String[] ghns = resources.getProperty("GHNSet").split(",");
                    l.setGHN(ghns);
                }
                add.setServices(l);
            }
            if (new Integer(resources.getProperty("numOfResourcesToAdd")) > 0) {
                ResourceItem[] resourcelist = new ResourceItem[new Integer(resources.getProperty("numOfResourcesToAdd")).intValue()];
                for (int i = 1; i < resourcelist.length + 1; ++i) {
                    resourcelist[i - 1] = new ResourceItem();
                    resourcelist[i - 1].setID(resources.getProperty("resource." + i + ".id"));
                    resourcelist[i - 1].setType(resources.getProperty("resource." + i + ".type"));
                }
                ResourceList r = new ResourceList();
                r.setResource(resourcelist);
                add.setResources(r);
            }
            add.setTargetScope(resources.getProperty("targetScope"));
            System.out.println("Sending the Resource request....");
            String reportID = pt.addResources(add);
            System.out.println("Returned report ID: " + reportID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static void printUsage() {
        System.out.println("AddResourceTest http://host:port/wsrf/services/gcube/vremanagement/ResourceManager <properties file>");
        System.out.println("or");
        System.out.println("AddResourceTest https://host:port/wsrf/services/gcube/vremanagement/ResourceManager <properties file> <identity>");
        System.exit(1);
    }
}

