/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.usecases.ws.thredds.engine.impl;

import org.gcube.usecases.ws.thredds.engine.impl.WorkspaceFolderManager;
import org.gcube.usecases.ws.thredds.engine.impl.security.Security;
import org.gcube.usecases.ws.thredds.faults.InternalException;
import org.gcube.usecases.ws.thredds.faults.WorkspaceInteractionException;
import org.gcube.usecases.ws.thredds.model.SynchFolderConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GuardedMethod<T> {
    private static final Logger log = LoggerFactory.getLogger(GuardedMethod.class);
    private WorkspaceFolderManager manager;
    private SynchFolderConfiguration configuration;
    private String folderId;
    private T result = null;

    public GuardedMethod(String folderId) throws WorkspaceInteractionException {
        this.folderId = folderId;
        this.manager = new WorkspaceFolderManager(folderId);
        this.configuration = this.manager.getSynchConfiguration();
        Security.checkOperator(this.configuration);
    }

    public GuardedMethod<T> execute() throws WorkspaceInteractionException, InternalException {
        try {
            this.result = this.run();
            return this;
        }
        catch (InternalException | WorkspaceInteractionException e) {
            throw e;
        }
        catch (Throwable t) {
            log.error("Unexpected error ", t);
            throw new InternalException("Unexpected internal error", t);
        }
    }

    protected abstract T run() throws WorkspaceInteractionException, InternalException, Exception;

    public WorkspaceFolderManager getManager() {
        return this.manager;
    }

    public SynchFolderConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getFolderId() {
        return this.folderId;
    }

    public T getResult() {
        return this.result;
    }
}

